/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2;

import io.ballerina.stdlib.http.transport.contract.exceptions.EndpointTimeOutException;
import io.ballerina.stdlib.http.transport.contract.exceptions.RequestCancelledException;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2TargetHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.ReceivingHeaders;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.RequestCompleted;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.SenderState;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.SendingEntityBody;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.WaitingFor100Continue;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingHeaders
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingHeaders.class);
    private final Http2TargetHandler http2TargetHandler;
    private final Http2TargetHandler.Http2RequestWriter http2RequestWriter;
    private final Http2MessageStateContext http2MessageStateContext;
    private final HttpCarbonMessage httpOutboundRequest;
    private final OutboundMsgHolder outboundMsgHolder;
    private final Http2Connection connection;
    private final Http2ConnectionEncoder encoder;
    private final Http2ClientChannel http2ClientChannel;
    private int streamId;

    public SendingHeaders(Http2TargetHandler http2TargetHandler, Http2TargetHandler.Http2RequestWriter http2RequestWriter) {
        this.http2TargetHandler = http2TargetHandler;
        this.http2RequestWriter = http2RequestWriter;
        this.http2MessageStateContext = http2RequestWriter.getHttp2MessageStateContext();
        this.httpOutboundRequest = http2RequestWriter.getHttpOutboundRequest();
        this.outboundMsgHolder = http2RequestWriter.getOutboundMsgHolder();
        this.connection = http2TargetHandler.getConnection();
        this.encoder = http2TargetHandler.getEncoder();
        this.http2ClientChannel = http2TargetHandler.getHttp2ClientChannel();
    }

    @Override
    public void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpContent httpContent) throws Http2Exception {
        this.writeHeaders(ctx, httpContent);
    }

    @Override
    public void writeOutboundRequestBody(ChannelHandlerContext ctx, HttpContent httpContent, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        this.writeOutboundRequestHeaders(ctx, httpContent);
    }

    @Override
    public void readInboundResponseHeaders(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        outboundMsgHolder.getRequest().setIoException(new IOException("Inbound response message already received"));
        http2MessageStateContext.setSenderState(new ReceivingHeaders(this.http2TargetHandler, this.http2RequestWriter));
        http2MessageStateContext.getSenderState().readInboundResponseHeaders(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundResponseBody(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        LOG.warn("readInboundResponseEntityBody is not a dependant action of this state");
    }

    @Override
    public void readInboundPromise(ChannelHandlerContext ctx, Http2PushPromise http2PushPromise, OutboundMsgHolder outboundMsgHolder) {
        LOG.warn("readInboundPromise is not a dependant action of this state");
    }

    @Override
    public void handleStreamTimeout(OutboundMsgHolder outboundMsgHolder, boolean serverPush, ChannelHandlerContext ctx, int streamId) {
        if (!serverPush) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Idle timeout triggered while writing outbound request headers", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
        }
    }

    @Override
    public void handleConnectionClose(OutboundMsgHolder outboundMsgHolder) {
        outboundMsgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Remote host closed the connection while writing outbound request headers", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
    }

    @Override
    public void handleServerGoAway(OutboundMsgHolder outboundMsgHolder) {
        outboundMsgHolder.getResponseFuture().notifyHttpListener(new RequestCancelledException("Remote host sent GOAWAY while writing outbound request headers", HttpResponseStatus.BAD_GATEWAY.code()));
    }

    @Override
    public void handleRstStream(OutboundMsgHolder outboundMsgHolder) {
        outboundMsgHolder.getResponseFuture().notifyHttpListener(new RequestCancelledException("Remote host sent RST_STREAM while writing outbound request headers", HttpResponseStatus.BAD_GATEWAY.code()));
    }

    private void writeHeaders(ChannelHandlerContext ctx, HttpContent msg) throws Http2Exception {
        boolean endStream = false;
        this.streamId = Http2StateUtil.initiateStream(ctx, this.connection, this.http2ClientChannel, this.outboundMsgHolder);
        this.http2RequestWriter.setStreamId(this.streamId);
        HttpRequest httpRequest = Util.createHttpRequest(this.httpOutboundRequest);
        if (msg instanceof LastHttpContent && msg.content().capacity() == 0) {
            endStream = true;
        }
        this.writeOutboundRequestHeaders(ctx, (HttpMessage)httpRequest, endStream);
        if (endStream) {
            this.http2MessageStateContext.setSenderState(new RequestCompleted(this.http2TargetHandler, this.http2RequestWriter));
        } else {
            String expectHeader = this.httpOutboundRequest.getHeader(HttpHeaderNames.EXPECT.toString());
            if (expectHeader != null) {
                this.http2MessageStateContext.setSenderState(new WaitingFor100Continue(this.http2TargetHandler, this.http2RequestWriter, msg, ctx, this.streamId, this.http2MessageStateContext));
            } else {
                this.http2MessageStateContext.setSenderState(new SendingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
                this.http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, msg, this.http2MessageStateContext);
            }
        }
    }

    private void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpMessage httpMsg, boolean endStream) throws Http2Exception {
        Object scheme = this.http2RequestWriter.getHttpOutboundRequest().getProperties().get("PROTOCOL");
        if (Objects.nonNull(scheme) && scheme.equals("https")) {
            httpMsg.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"https");
        } else {
            httpMsg.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"http");
        }
        Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpMsg, (boolean)true);
        Http2StateUtil.writeHttp2Headers(ctx, this.outboundMsgHolder, this.http2ClientChannel, this.encoder, this.streamId, httpMsg.headers(), http2Headers, endStream);
    }
}

