/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.message;

import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.TransportProperty;
import io.ballerina.stdlib.http.transport.contract.config.TransportsConfiguration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HttpConnectorUtil {
    public static SenderConfiguration getSenderConfiguration(TransportsConfiguration transportsConfiguration, String scheme) {
        Map<String, SenderConfiguration> senderConfigurations = transportsConfiguration.getSenderConfigurations().stream().collect(Collectors.toMap(senderConf -> senderConf.getScheme().toLowerCase(Locale.getDefault()), config -> config));
        return "https".equals(scheme) ? senderConfigurations.get("https") : senderConfigurations.get("http");
    }

    public static Map<String, Object> getTransportProperties(TransportsConfiguration transportsConfiguration) {
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        Set<TransportProperty> transportPropertiesSet = transportsConfiguration.getTransportProperties();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        return transportProperties;
    }

    private HttpConnectorUtil() {
    }
}

