/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.extension;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.openapi.extension.OpenAPIConverterRequest;
import io.ballerina.openapi.extension.OpenAPIConverterResponse;
import io.ballerina.openapi.service.mapper.ServiceToOpenAPIMapper;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="openAPILSExtension")
public class OpenAPIConverterService
implements ExtendedLanguageServerService {
    private static final String SERVICE_NAME = "serviceName";
    private static final String SPEC = "spec";
    private static final String DIAGNOSTICS = "diagnostics";
    private static final String MESSAGE = "message";
    private static final String SEVERITY = "severity";
    private static final String LOCATION = "location";
    private static final String FILE = "file";
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    @Deprecated
    public CompletableFuture<OpenAPIConverterResponse> generateOpenAPIFile(OpenAPIConverterRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            OpenAPIConverterResponse response = new OpenAPIConverterResponse();
            String fileUri = request.getDocumentFilePath();
            Optional<SyntaxTree> syntaxTree = OpenAPIConverterService.getPathFromURI(fileUri).flatMap(arg_0 -> ((WorkspaceManager)this.workspaceManager).syntaxTree(arg_0));
            Optional<SemanticModel> semanticModel = OpenAPIConverterService.getPathFromURI(fileUri).flatMap(arg_0 -> ((WorkspaceManager)this.workspaceManager).semanticModel(arg_0));
            Optional<Project> ballerinaPackage = OpenAPIConverterService.getPathFromURI(fileUri).flatMap(arg_0 -> ((WorkspaceManager)this.workspaceManager).project(arg_0));
            if (semanticModel.isEmpty() || syntaxTree.isEmpty() || ballerinaPackage.isEmpty()) {
                StringBuilder errorString = this.getErrorMessage(syntaxTree, semanticModel, ballerinaPackage);
                response.setError(errorString.toString());
            } else {
                response.setError(null);
                List yamlContent = ServiceToOpenAPIMapper.generateOAS3Definition((Project)ballerinaPackage.get(), (SyntaxTree)syntaxTree.get(), (SemanticModel)semanticModel.get(), null, (Boolean)false, (Path)Path.of(request.getDocumentFilePath(), new String[0]), (Boolean)request.isEnableBalExtension());
                if (!yamlContent.isEmpty() && ((OASResult)yamlContent.get(0)).getOpenAPI().isPresent()) {
                    Optional yaml = ((OASResult)yamlContent.get(0)).getYaml();
                    yaml.ifPresent(response::setYamlContent);
                } else {
                    response.setError("Error occurred while generating yaml.");
                }
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<OpenAPIConverterResponse> generateOpenAPI(OpenAPIConverterRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            OpenAPIConverterResponse response = new OpenAPIConverterResponse();
            Path filePath = Path.of(request.getDocumentFilePath(), new String[0]);
            Optional semanticModel = this.workspaceManager.semanticModel(filePath);
            Optional<Project> project = this.workspaceManager.project(filePath);
            if (semanticModel.isEmpty()) {
                response.setError("Error while generating semantic model.");
                return response;
            }
            if (project.isEmpty()) {
                response.setError("Error while getting the project.");
                return response;
            }
            project = Optional.of(((Project)project.get()).duplicate());
            DiagnosticResult diagnosticsFromCodeGenAndModify = project.get().currentPackage().runCodeGenAndModifyPlugins();
            boolean hasErrorsFromCodeGenAndModify = diagnosticsFromCodeGenAndModify.diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
            Collection compilationDiagnostics = project.get().currentPackage().getCompilation().diagnosticResult().diagnostics();
            boolean hasCompilationErrors = compilationDiagnostics.stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
            if (hasCompilationErrors || hasErrorsFromCodeGenAndModify) {
                response.setError("Given Ballerina file contains compilation error(s).");
                return response;
            }
            Module defaultModule = project.get().currentPackage().getDefaultModule();
            SemanticModel updatedSemanticModel = project.get().currentPackage().getCompilation().getSemanticModel(defaultModule.moduleId());
            JsonArray specs = new JsonArray();
            for (DocumentId currentDocumentID : defaultModule.documentIds()) {
                Document document = defaultModule.document(currentDocumentID);
                Optional path = defaultModule.project().documentPath(currentDocumentID);
                Path inputPath = path.orElse(null);
                SyntaxTree syntaxTree = document.syntaxTree();
                List oasResults = ServiceToOpenAPIMapper.generateOAS3Definition((Project)project.get(), (SyntaxTree)syntaxTree, (SemanticModel)updatedSemanticModel, null, (Boolean)false, (Path)inputPath, (Boolean)request.isEnableBalExtension());
                this.generateServiceJson(response, document.syntaxTree().filePath(), oasResults, specs);
            }
            response.setContent(specs);
            return response;
        });
    }

    private void generateServiceJson(OpenAPIConverterResponse response, String document, List<OASResult> oasResults, JsonArray specs) {
        for (OASResult oasResult : oasResults) {
            if (oasResult.getOpenAPI().isEmpty()) {
                response.setError("Error occurred while generating yaml.");
                continue;
            }
            if (oasResult.getJson().isEmpty()) continue;
            JsonObject spec = new JsonObject();
            JsonObject json = JsonParser.parseString((String)((String)oasResult.getJson().get())).getAsJsonObject();
            JsonArray diagnosticsJson = this.getDiagnosticsJson(oasResult);
            spec.addProperty(SERVICE_NAME, ((OpenAPI)oasResult.getOpenAPI().get()).getInfo().getTitle());
            spec.addProperty(FILE, document);
            spec.add(SPEC, (JsonElement)json);
            spec.add(DIAGNOSTICS, (JsonElement)diagnosticsJson);
            specs.add((JsonElement)spec);
        }
    }

    private JsonArray getDiagnosticsJson(OASResult oasResult) {
        List diagnostics = oasResult.getDiagnostics();
        JsonArray diagnosticsJson = new JsonArray();
        for (OpenAPIMapperDiagnostic diagnostic : diagnostics) {
            JsonObject diagnosticJson = new JsonObject();
            diagnosticJson.addProperty(MESSAGE, diagnostic.getMessage());
            diagnosticJson.addProperty(SEVERITY, diagnostic.getDiagnosticSeverity().name());
            Optional diagnosticLocation = diagnostic.getLocation();
            if (diagnosticLocation.isPresent()) {
                GsonBuilder builder = new GsonBuilder();
                builder.serializeNulls();
                Gson gson = builder.create();
                diagnosticJson.add(LOCATION, gson.toJsonTree((Object)((Location)diagnosticLocation.get()).lineRange()));
            }
            diagnosticsJson.add((JsonElement)diagnosticJson);
        }
        return diagnosticsJson;
    }

    private StringBuilder getErrorMessage(Optional<SyntaxTree> syntaxTree, Optional<SemanticModel> semanticModel, Optional<Project> project) {
        StringBuilder errorString = new StringBuilder();
        if (syntaxTree.isEmpty()) {
            errorString.append("Error while generating syntax tree.").append(System.lineSeparator());
        }
        if (semanticModel.isEmpty()) {
            errorString.append("Error while generating semantic model.").append(System.lineSeparator());
        }
        if (project.isEmpty()) {
            errorString.append("Error while generating ballerina package.").append(System.lineSeparator());
        }
        return errorString;
    }

    public static Optional<Path> getPathFromURI(String uri) {
        try {
            return Optional.of(Paths.get(new URL(uri).toURI()));
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return Optional.empty();
        }
    }
}

