/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.deserialize;

import io.ballerina.lib.avro.deserialize.ArrayDeserializer;
import io.ballerina.lib.avro.deserialize.Deserializer;
import io.ballerina.lib.avro.deserialize.FixedDeserializer;
import io.ballerina.lib.avro.deserialize.MapDeserializer;
import io.ballerina.lib.avro.deserialize.PrimitiveDeserializer;
import io.ballerina.lib.avro.deserialize.RecordDeserializer;
import io.ballerina.runtime.api.types.Type;
import org.apache.avro.Schema;

public class DeserializeFactory {
    public static Deserializer generateDeserializer(Schema schema, Type type) {
        return switch (schema.getType()) {
            case Schema.Type.ARRAY -> new ArrayDeserializer(type, schema);
            case Schema.Type.FIXED -> new FixedDeserializer(type, schema);
            case Schema.Type.MAP -> new MapDeserializer(schema, type);
            case Schema.Type.RECORD -> new RecordDeserializer(type, schema);
            default -> new PrimitiveDeserializer(type, schema);
        };
    }
}

