/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.deserialize.visitor;

import io.ballerina.lib.avro.Utils;
import io.ballerina.lib.avro.deserialize.ArrayDeserializer;
import io.ballerina.lib.avro.deserialize.Deserializer;
import io.ballerina.lib.avro.deserialize.EnumDeserializer;
import io.ballerina.lib.avro.deserialize.FixedDeserializer;
import io.ballerina.lib.avro.deserialize.MapDeserializer;
import io.ballerina.lib.avro.deserialize.PrimitiveDeserializer;
import io.ballerina.lib.avro.deserialize.RecordDeserializer;
import io.ballerina.lib.avro.deserialize.UnionDeserializer;
import io.ballerina.lib.avro.deserialize.visitor.DeserializeArrayVisitor;
import io.ballerina.lib.avro.deserialize.visitor.IDeserializeVisitor;
import io.ballerina.lib.avro.deserialize.visitor.RecordUtils;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;

public class DeserializeVisitor
implements IDeserializeVisitor {
    public static Deserializer createDeserializer(Schema schema, Type type) {
        return switch (schema.getElementType().getType()) {
            case Schema.Type.UNION -> new UnionDeserializer(type, schema);
            case Schema.Type.ARRAY -> new ArrayDeserializer(type, schema);
            case Schema.Type.ENUM -> new EnumDeserializer(type, schema);
            case Schema.Type.RECORD -> new RecordDeserializer(type, schema);
            case Schema.Type.FIXED -> new FixedDeserializer(type, schema);
            default -> new PrimitiveDeserializer(type, schema);
        };
    }

    public BMap<BString, Object> visit(RecordDeserializer recordDeserializer, GenericRecord rec) throws Exception {
        Type originalType = recordDeserializer.getType();
        Type type = recordDeserializer.getType();
        Schema schema = recordDeserializer.getSchema();
        BMap<BString, Object> avroRecord = this.createAvroRecord(type);
        block10: for (Schema.Field field : schema.getFields()) {
            Object fieldData = rec.get(field.name());
            switch (field.schema().getType()) {
                case MAP: {
                    RecordUtils.processMapField(avroRecord, field, fieldData);
                    continue block10;
                }
                case ARRAY: {
                    Type fieldType = ((Field)((RecordType)avroRecord.getType()).getFields().get(field.name())).getFieldType();
                    RecordUtils.processArrayField(avroRecord, field, fieldData, fieldType);
                    continue block10;
                }
                case BYTES: {
                    RecordUtils.processBytesField(avroRecord, field, fieldData);
                    continue block10;
                }
                case RECORD: {
                    RecordUtils.processRecordField(avroRecord, field, fieldData);
                    continue block10;
                }
                case STRING: {
                    RecordUtils.processStringField(avroRecord, field, fieldData);
                    continue block10;
                }
                case INT: {
                    avroRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)Long.parseLong(fieldData.toString()));
                    continue block10;
                }
                case FLOAT: {
                    avroRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)Double.parseDouble(fieldData.toString()));
                    continue block10;
                }
                case UNION: {
                    RecordUtils.processUnionField(type, avroRecord, field, fieldData);
                    continue block10;
                }
            }
            avroRecord.put((Object)StringUtils.fromString((String)field.name()), fieldData);
        }
        if (originalType.isReadOnly()) {
            avroRecord.freezeDirect();
        }
        if (type.getTag() == 23) {
            return (BMap)ValueUtils.convert(avroRecord, (Type)type);
        }
        return avroRecord;
    }

    public BMap<BString, Object> visit(MapDeserializer mapDeserializer, Map<String, Object> data) throws Exception {
        BMap avroRecord = ValueCreator.createMapValue();
        Object[] keys = data.keySet().toArray();
        Schema schema = mapDeserializer.getSchema();
        Type type = mapDeserializer.getType();
        block9: for (Object key : keys) {
            Object value = data.get(key);
            Schema.Type valueType = schema.getValueType().getType();
            switch (valueType) {
                case ARRAY: {
                    this.processMapArray((BMap<BString, Object>)avroRecord, schema, (MapType)Utils.getMutableType(type), key, (GenericData.Array<Object>)((GenericData.Array)value));
                    continue block9;
                }
                case BYTES: {
                    avroRecord.put((Object)StringUtils.fromString((String)key.toString()), (Object)ValueCreator.createArrayValue((byte[])((ByteBuffer)value).array()));
                    continue block9;
                }
                case FIXED: {
                    avroRecord.put((Object)StringUtils.fromString((String)key.toString()), (Object)ValueCreator.createArrayValue((byte[])((GenericFixed)value).bytes()));
                    continue block9;
                }
                case ENUM: 
                case STRING: {
                    avroRecord.put((Object)StringUtils.fromString((String)key.toString()), (Object)StringUtils.fromString((String)value.toString()));
                    continue block9;
                }
                case RECORD: {
                    this.processMapRecord((BMap<BString, Object>)avroRecord, schema, (MapType)Utils.getMutableType(type), key, (GenericRecord)value);
                    continue block9;
                }
                case FLOAT: {
                    avroRecord.put((Object)StringUtils.fromString((String)key.toString()), (Object)Double.parseDouble(value.toString()));
                    continue block9;
                }
                case MAP: {
                    this.processMaps((BMap<BString, Object>)avroRecord, schema, (MapType)Utils.getMutableType(type), key, (Map)value);
                    continue block9;
                }
                default: {
                    avroRecord.put((Object)StringUtils.fromString((String)key.toString()), value);
                }
            }
        }
        return (BMap)ValueUtils.convert((Object)avroRecord, (Type)type);
    }

    public Object visit(PrimitiveDeserializer primitiveDeserializer, Object data) throws Exception {
        Schema schema = primitiveDeserializer.getSchema();
        Type type = primitiveDeserializer.getType();
        switch (schema.getType()) {
            case ARRAY: {
                return this.visitPrimitiveArrays(primitiveDeserializer, (GenericData.Array<Object>)((GenericData.Array)data), schema, type);
            }
            case ENUM: 
            case STRING: {
                return StringUtils.fromString((String)data.toString());
            }
            case FLOAT: 
            case DOUBLE: {
                if (data instanceof Float) {
                    return Double.parseDouble(data.toString());
                }
                return data;
            }
            case NULL: {
                if (data != null) {
                    throw new Exception("The value does not match with the null schema");
                }
                return null;
            }
            case BYTES: {
                return ValueCreator.createArrayValue((byte[])((ByteBuffer)data).array());
            }
        }
        return data;
    }

    private Object visitPrimitiveArrays(PrimitiveDeserializer primitiveDeserializer, GenericData.Array<Object> data, Schema schema, Type type) {
        switch (schema.getElementType().getType()) {
            case STRING: {
                return ValueUtils.convert((Object)this.visitStringArray(data), (Type)type);
            }
            case INT: {
                return ValueUtils.convert((Object)DeserializeVisitor.visitIntArray(data), (Type)type);
            }
            case LONG: {
                return ValueUtils.convert((Object)DeserializeVisitor.visitLongArray(data), (Type)type);
            }
            case FLOAT: 
            case DOUBLE: {
                return ValueUtils.convert((Object)this.visitDoubleArray(data), (Type)type);
            }
            case BOOLEAN: {
                return ValueUtils.convert((Object)DeserializeVisitor.visitBooleanArray(data), (Type)type);
            }
        }
        return ValueUtils.convert((Object)this.visitBytesArray(data, primitiveDeserializer.getType()), (Type)type);
    }

    public BArray visit(UnionDeserializer unionDeserializer, GenericData.Array<Object> data) throws Exception {
        Type type = unionDeserializer.getType();
        Schema schema = unionDeserializer.getSchema();
        switch (((ArrayType)type).getElementType().getTag()) {
            case 5: {
                return this.visitStringArray(data);
            }
            case 3: {
                return this.visitDoubleArray(data);
            }
            case 6: {
                return DeserializeVisitor.visitBooleanArray(data);
            }
            case 1: {
                return DeserializeVisitor.visitIntegerArray(data, schema);
            }
            case 24: {
                return this.visitRecordArray(data, type, schema);
            }
            case 32: {
                return this.visitUnionArray(data, (ArrayType)type, schema);
            }
        }
        return (BArray)data;
    }

    private BArray visitRecordArray(GenericData.Array<Object> data, Type type, Schema schema) throws Exception {
        RecordDeserializer recordDeserializer = new RecordDeserializer(type, schema.getElementType());
        return (BArray)recordDeserializer.accept(this, data);
    }

    private BArray visitUnionArray(GenericData.Array<Object> data, ArrayType type, Schema schema) throws Exception {
        Object[] objects = new Object[data.size()];
        Type elementType = type.getElementType();
        ArrayDeserializer arrayDeserializer = new ArrayDeserializer(elementType, schema.getElementType());
        int index = 0;
        for (Object currentData : data) {
            Object deserializedObject = arrayDeserializer.accept(this, (GenericData.Array<Object>)((GenericData.Array)currentData));
            objects[index++] = deserializedObject;
        }
        return ValueCreator.createArrayValue((Object[])objects, (ArrayType)type);
    }

    public BArray visit(RecordDeserializer recordDeserializer, GenericData.Array<Object> data) throws Exception {
        ArrayList<Object> recordList = new ArrayList<Object>();
        boolean isReadOnly = recordDeserializer.getType().getTag() == 34;
        Type type = Utils.getMutableType(recordDeserializer.getType());
        Schema schema = recordDeserializer.getSchema();
        switch (type.getTag()) {
            case 32: {
                for (Object datum : data) {
                    Type fieldType = ((ArrayType)type).getElementType();
                    RecordDeserializer recordDes = new RecordDeserializer(fieldType, schema.getElementType());
                    recordList.add(recordDes.accept(this, datum));
                }
                break;
            }
            case 53: {
                for (Object datum : data) {
                    Type fieldType = ((ReferenceType)type).getReferredType();
                    RecordDeserializer recordDes = new RecordDeserializer(fieldType, schema.getElementType());
                    recordList.add(recordDes.accept(this, (GenericRecord)datum));
                }
                break;
            }
        }
        BArray arrayValue = ValueCreator.createArrayValue((Object[])recordList.toArray(new Object[data.size()]), (ArrayType)((ArrayType)type));
        if (isReadOnly) {
            arrayValue.freezeDirect();
        }
        return arrayValue;
    }

    private BMap<BString, Object> createAvroRecord(Type type) {
        if (type.getTag() == 23) {
            return ValueCreator.createMapValue();
        }
        return ValueCreator.createRecordValue((RecordType)((RecordType)Utils.getMutableType(type)));
    }

    private void processMaps(BMap<BString, Object> avroRecord, Schema schema, MapType type, Object key, Map<String, Object> value) throws Exception {
        Schema fieldSchema = schema.getValueType();
        Type fieldType = type.getConstrainedType();
        MapDeserializer mapDes = new MapDeserializer(fieldSchema, fieldType);
        Object fieldValue = mapDes.accept(this, value);
        avroRecord.put((Object)StringUtils.fromString((String)key.toString()), fieldValue);
    }

    private void processMapRecord(BMap<BString, Object> avroRecord, Schema schema, MapType type, Object key, GenericRecord value) throws Exception {
        Type fieldType = type.getConstrainedType();
        RecordDeserializer recordDes = new RecordDeserializer(fieldType, schema.getValueType());
        Object fieldValue = recordDes.accept(this, value);
        avroRecord.put((Object)StringUtils.fromString((String)key.toString()), fieldValue);
    }

    private void processMapArray(BMap<BString, Object> avroRecord, Schema schema, MapType type, Object key, GenericData.Array<Object> value) throws Exception {
        Type fieldType = type.getConstrainedType();
        ArrayDeserializer arrayDeserializer = new ArrayDeserializer(fieldType, schema.getValueType());
        Object fieldValue = this.visit(arrayDeserializer, value);
        avroRecord.put((Object)StringUtils.fromString((String)key.toString()), fieldValue);
    }

    public Object visit(ArrayDeserializer arrayDeserializer, GenericData.Array<Object> data) throws Exception {
        Deserializer deserializer = DeserializeVisitor.createDeserializer(arrayDeserializer.getSchema(), arrayDeserializer.getType());
        return deserializer.accept((DeserializeVisitor)new DeserializeArrayVisitor(), data);
    }

    public BArray visit(EnumDeserializer enumDeserializer, GenericData.Array<Object> data) {
        Object[] enums = new Object[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            enums[i] = this.visitString(data.get(i));
        }
        return ValueCreator.createArrayValue((Object[])enums, (ArrayType)((ArrayType)enumDeserializer.getType()));
    }

    public Object visit(FixedDeserializer fixedDeserializer, Object data) {
        if (fixedDeserializer.getSchema().getType().equals((Object)Schema.Type.ARRAY)) {
            GenericData.Array array = (GenericData.Array)data;
            Type type = fixedDeserializer.getType();
            ArrayList<BArray> values = new ArrayList<BArray>();
            for (Object datum : array) {
                values.add(this.visitFixed(datum));
            }
            return ValueCreator.createArrayValue((Object[])values.toArray(new BArray[array.size()]), (ArrayType)((ArrayType)type));
        }
        return this.visitFixed(data);
    }

    public BArray visit(FixedDeserializer fixedDeserializer, GenericData.Array<Object> data) {
        Type type = fixedDeserializer.getType();
        ArrayList<BArray> values = new ArrayList<BArray>();
        for (Object datum : data) {
            values.add(this.visitFixed(datum));
        }
        return ValueCreator.createArrayValue((Object[])values.toArray(new BArray[data.size()]), (ArrayType)((ArrayType)type));
    }

    private static BArray visitIntegerArray(GenericData.Array<Object> data, Schema schema) {
        for (Schema schemaInstance : schema.getElementType().getTypes()) {
            if (!schemaInstance.getType().equals((Object)Schema.Type.INT)) continue;
            return DeserializeVisitor.visitIntArray(data);
        }
        return DeserializeVisitor.visitLongArray(data);
    }

    private BArray visitBytesArray(GenericData.Array<Object> data, Type type) {
        ArrayList<BArray> values = new ArrayList<BArray>();
        for (Object datum : data) {
            values.add(ValueCreator.createArrayValue((byte[])((ByteBuffer)datum).array()));
        }
        return ValueCreator.createArrayValue((Object[])values.toArray(new BArray[data.size()]), (ArrayType)((ArrayType)type));
    }

    private static BArray visitBooleanArray(GenericData.Array<Object> data) {
        boolean[] booleanArray = new boolean[data.size()];
        int index = 0;
        for (Object datum : data) {
            booleanArray[index++] = (Boolean)datum;
        }
        return ValueCreator.createArrayValue((boolean[])booleanArray);
    }

    private BArray visitDoubleArray(GenericData.Array<Object> data) {
        ArrayList<Double> doubleList = new ArrayList<Double>();
        for (Object datum : data) {
            doubleList.add(this.visitDouble(datum));
        }
        double[] doubleArray = doubleList.stream().mapToDouble(Double::doubleValue).toArray();
        return ValueCreator.createArrayValue((double[])doubleArray);
    }

    private static BArray visitLongArray(GenericData.Array<Object> data) {
        ArrayList<Long> longList = new ArrayList<Long>();
        for (Object datum : data) {
            longList.add((Long)datum);
        }
        long[] longArray = longList.stream().mapToLong(Long::longValue).toArray();
        return ValueCreator.createArrayValue((long[])longArray);
    }

    private static BArray visitIntArray(GenericData.Array<Object> data) {
        ArrayList<Long> longList = new ArrayList<Long>();
        for (Object datum : data) {
            longList.add(((Integer)datum).longValue());
        }
        long[] longArray = longList.stream().mapToLong(Long::longValue).toArray();
        return ValueCreator.createArrayValue((long[])longArray);
    }

    private BArray visitStringArray(GenericData.Array<Object> data) {
        BString[] stringArray = new BString[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            stringArray[i] = this.visitString(data.get(i));
        }
        return ValueCreator.createArrayValue((BString[])stringArray);
    }

    @Override
    public double visitDouble(Object data) {
        if (data instanceof Float) {
            return Double.parseDouble(data.toString());
        }
        return (Double)data;
    }

    @Override
    public BArray visitFixed(Object data) {
        GenericData.Fixed fixed = (GenericData.Fixed)data;
        return ValueCreator.createArrayValue((byte[])fixed.bytes());
    }

    @Override
    public BString visitString(Object data) {
        return StringUtils.fromString((String)data.toString());
    }

    public static Type extractMapType(Type type) throws Exception {
        Type mapType = type;
        if (type.getTag() != 24) {
            throw new Exception("Type is not a record type.");
        }
        block4: for (Map.Entry entry : ((RecordType)type).getFields().entrySet()) {
            Field fieldValue = (Field)entry.getValue();
            if (fieldValue == null) continue;
            Type fieldType = fieldValue.getFieldType();
            switch (fieldType.getTag()) {
                case 27: {
                    mapType = fieldType;
                    break;
                }
                case 34: {
                    Type referredType = Utils.getMutableType(fieldType);
                    if (referredType.getTag() != 27) continue block4;
                    mapType = referredType;
                    break;
                }
                default: {
                    Type referType = TypeUtils.getReferredType((Type)fieldType);
                    if (referType.getTag() != 27) continue block4;
                    mapType = referType;
                }
            }
        }
        return mapType;
    }

    public static RecordType extractRecordType(RecordType type) {
        Map fieldsMap = type.getFields();
        RecordType recType = type;
        block4: for (Map.Entry entry : fieldsMap.entrySet()) {
            Field fieldValue = (Field)entry.getValue();
            if (fieldValue == null) continue;
            Type fieldType = fieldValue.getFieldType();
            switch (fieldType.getTag()) {
                case 24: {
                    recType = (RecordType)fieldType;
                    continue block4;
                }
                case 34: {
                    if (Utils.getMutableType(fieldType).getTag() != 24) continue block4;
                    recType = (RecordType)Utils.getMutableType(fieldType);
                    continue block4;
                }
            }
            Type referredType = TypeUtils.getReferredType((Type)fieldType);
            if (referredType.getTag() != 24) continue;
            recType = (RecordType)referredType;
        }
        return recType;
    }
}

