/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.deserialize.visitor;

import io.ballerina.lib.avro.deserialize.ArrayDeserializer;
import io.ballerina.lib.avro.deserialize.MapDeserializer;
import io.ballerina.lib.avro.deserialize.PrimitiveDeserializer;
import io.ballerina.lib.avro.deserialize.RecordDeserializer;
import io.ballerina.lib.avro.deserialize.visitor.DeserializeVisitor;
import io.ballerina.lib.avro.deserialize.visitor.UnionRecordUtils;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public class RecordUtils {
    public static void processMapField(BMap<BString, Object> avroRecord, Schema.Field field, Object fieldData) throws Exception {
        Type mapType = DeserializeVisitor.extractMapType(avroRecord.getType());
        MapDeserializer mapDeserializer = new MapDeserializer(field.schema(), mapType);
        Object fieldValue = mapDeserializer.accept(new DeserializeVisitor(), fieldData);
        avroRecord.put((Object)StringUtils.fromString((String)field.name()), fieldValue);
    }

    public static void processArrayField(BMap<BString, Object> avroRecord, Schema.Field field, Object fieldData, Type type) throws Exception {
        ArrayDeserializer arrayDes = new ArrayDeserializer(type, field.schema());
        Object fieldValue = arrayDes.accept(new DeserializeVisitor(), (GenericData.Array<Object>)((GenericData.Array)fieldData));
        avroRecord.put((Object)StringUtils.fromString((String)field.name()), fieldValue);
    }

    public static void processBytesField(BMap<BString, Object> avroRecord, Schema.Field field, Object fieldData) {
        ByteBuffer byteBuffer = (ByteBuffer)fieldData;
        BArray fieldValue = ValueCreator.createArrayValue((byte[])byteBuffer.array());
        avroRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)fieldValue);
    }

    public static void processRecordField(BMap<BString, Object> avroRecord, Schema.Field field, Object fieldData) throws Exception {
        RecordType recType = DeserializeVisitor.extractRecordType((RecordType)avroRecord.getType());
        RecordDeserializer recordDes = new RecordDeserializer((Type)recType, field.schema());
        Object fieldValue = recordDes.accept(new DeserializeVisitor(), fieldData);
        avroRecord.put((Object)StringUtils.fromString((String)field.name()), fieldValue);
    }

    public static void processStringField(BMap<BString, Object> avroRecord, Schema.Field field, Object fieldData) throws Exception {
        PrimitiveDeserializer stringDes = new PrimitiveDeserializer(null, field.schema());
        Object fieldValue = stringDes.accept(new DeserializeVisitor(), fieldData);
        avroRecord.put((Object)StringUtils.fromString((String)field.name()), fieldValue);
    }

    public static void processUnionField(Type type, BMap<BString, Object> avroRecord, Schema.Field field, Object fieldData) throws Exception {
        UnionRecordUtils.visitUnionRecords(type, avroRecord, field, fieldData);
    }
}

