/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.deserialize.visitor;

import io.ballerina.lib.avro.deserialize.RecordDeserializer;
import io.ballerina.lib.avro.deserialize.visitor.DeserializeVisitor;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class UnionRecordUtils {
    public static void visitUnionRecords(Type type, BMap<BString, Object> ballerinaRecord, Schema.Field field, Object fieldData) throws Exception {
        int size = ballerinaRecord.size();
        for (Schema schemaType : field.schema().getTypes()) {
            if (fieldData == null) {
                ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), null);
                break;
            }
            switch (schemaType.getType()) {
                case BYTES: {
                    UnionRecordUtils.handleBytesField(field, fieldData, ballerinaRecord);
                    break;
                }
                case FIXED: {
                    UnionRecordUtils.handleFixedField(field, fieldData, ballerinaRecord);
                    break;
                }
                case ARRAY: {
                    UnionRecordUtils.handleArrayField(field, fieldData, ballerinaRecord, schemaType);
                    break;
                }
                case MAP: {
                    UnionRecordUtils.handleMapField(field, fieldData, ballerinaRecord);
                    break;
                }
                case RECORD: {
                    UnionRecordUtils.handleRecordField(type, field, fieldData, ballerinaRecord, schemaType);
                    break;
                }
                case STRING: {
                    UnionRecordUtils.handleStringField(field, fieldData, ballerinaRecord);
                    break;
                }
                case INT: 
                case LONG: {
                    UnionRecordUtils.handleIntegerField(field, fieldData, ballerinaRecord);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    UnionRecordUtils.handleFloatField(field, fieldData, ballerinaRecord);
                    break;
                }
                case ENUM: {
                    UnionRecordUtils.handleEnumField(field, fieldData, ballerinaRecord);
                    break;
                }
                default: {
                    UnionRecordUtils.handleDefaultField(field, fieldData, ballerinaRecord);
                }
            }
            if (ballerinaRecord.size() == size) continue;
            break;
        }
    }

    private static void handleDefaultField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof Boolean) {
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), fieldData);
        }
    }

    private static void handleEnumField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof GenericEnumSymbol) {
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)StringUtils.fromString((String)fieldData.toString()));
        }
    }

    private static void handleFloatField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof Double) {
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), fieldData);
        } else {
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)Double.parseDouble(fieldData.toString()));
        }
    }

    private static void handleIntegerField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof Integer || fieldData instanceof Long) {
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)((Number)fieldData).longValue());
        }
    }

    private static void handleStringField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof Utf8) {
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)StringUtils.fromString((String)fieldData.toString()));
        }
    }

    public static void handleRecordField(Type type, Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord, Schema schemaType) throws Exception {
        if (fieldData instanceof GenericRecord) {
            RecordDeserializer recordDes = new RecordDeserializer(type, schemaType);
            Object fieldValue = recordDes.accept(new DeserializeVisitor(), (GenericRecord)fieldData);
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), fieldValue);
        }
    }

    private static void handleMapField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof Map) {
            Object[] keys;
            BMap avroMap = ValueCreator.createMapValue();
            for (Object key : keys = ((Map)fieldData).keySet().toArray()) {
                avroMap.put((Object)StringUtils.fromString((String)key.toString()), ((Map)fieldData).get(key));
            }
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)avroMap);
        }
    }

    private static void handleBytesField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof ByteBuffer) {
            BArray byteArray = ValueCreator.createArrayValue((byte[])((ByteBuffer)fieldData).array());
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)byteArray);
        }
    }

    private static void handleFixedField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord) {
        if (fieldData instanceof GenericFixed) {
            BArray byteArray = ValueCreator.createArrayValue((byte[])((GenericData.Fixed)fieldData).bytes());
            ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)byteArray);
        }
    }

    private static void handleArrayField(Schema.Field field, Object fieldData, BMap<BString, Object> ballerinaRecord, Schema schemaType) {
        if (fieldData instanceof GenericData.Array) {
            Object[] objectArray = ((GenericData.Array)fieldData).toArray();
            if (schemaType.getElementType().getType().equals((Object)Schema.Type.STRING) || schemaType.getElementType().getType().equals((Object)Schema.Type.ENUM)) {
                BString[] stringArray = new BString[objectArray.length];
                BArray ballerinaArray = ValueCreator.createArrayValue((BString[])stringArray);
                int i = 0;
                for (Object obj : objectArray) {
                    stringArray[i] = StringUtils.fromString((String)obj.toString());
                    ++i;
                }
                ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), (Object)ballerinaArray);
            } else {
                ballerinaRecord.put((Object)StringUtils.fromString((String)field.name()), fieldData);
            }
        }
    }
}

