/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.avro.serialize.visitor.array;

import io.ballerina.lib.avro.serialize.visitor.array.ArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.EnumArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.FixedArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.IArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.MapArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.PrimitiveArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.RecordArrayVisitor;
import io.ballerina.lib.avro.serialize.visitor.array.UnionArrayVisitor;
import org.apache.avro.Schema;

public class ArrayVisitorFactory {
    public static IArrayVisitor createVisitor(Schema schema) {
        switch (schema.getElementType().getType()) {
            case NULL: {
                return null;
            }
            case ARRAY: {
                return new ArrayVisitor();
            }
            case ENUM: {
                return new EnumArrayVisitor();
            }
            case UNION: {
                return new UnionArrayVisitor();
            }
            case FIXED: {
                return new FixedArrayVisitor();
            }
            case RECORD: {
                return new RecordArrayVisitor();
            }
            case MAP: {
                return new MapArrayVisitor();
            }
        }
        return new PrimitiveArrayVisitor();
    }
}

