/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.internal.values.XmlValue;
import io.ballerina.runtime.internal.xml.XmlFactory;
import java.util.Map;

public final class CreateElement {
    private static final String XML = "xml";
    private static final String XML_NS_URI_PREFIX = "{http://www.w3.org/XML/1998/namespace}";
    private static final String XMLNS_NS_URI_PREFIX = "{http://www.w3.org/2000/xmlns/}";

    private CreateElement() {
    }

    public static BXml createElement(BString name, BMap<BString, BString> attributes, BXml children) {
        String prefix = CreateElement.getPrefix(name.getValue(), attributes);
        BXmlQName xmlqName = prefix.isEmpty() ? ValueCreator.createXmlQName((BString)name) : ValueCreator.createXmlQName((BString)name, (String)prefix);
        XmlValue xmlElement = XmlFactory.createXMLElement((BXmlQName)xmlqName, (String)null);
        xmlElement.setAttributes(attributes);
        xmlElement.setChildren(CreateElement.getChildren(children));
        return xmlElement;
    }

    private static String getPrefix(String name, BMap<BString, BString> attributes) {
        int curlyBracketEndIndex = name.lastIndexOf(125);
        if (name.startsWith("{") && curlyBracketEndIndex > 0) {
            String uri = name.substring(1, curlyBracketEndIndex);
            for (Map.Entry entry : attributes.entrySet()) {
                if (!((BString)entry.getValue()).getValue().equals(uri)) continue;
                String key = ((BString)entry.getKey()).getValue();
                if (key.startsWith(XMLNS_NS_URI_PREFIX)) {
                    String prefix = key.substring(key.lastIndexOf(125) + 1);
                    if (prefix.equals(XML)) {
                        return "";
                    }
                    return prefix;
                }
                if (!key.startsWith(XML_NS_URI_PREFIX)) continue;
                return XML;
            }
        }
        return "";
    }

    private static BXml getChildren(BXml children) {
        if (children == null) {
            return ValueCreator.createXmlSequence();
        }
        return children;
    }
}

