/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.testmanagerservice.extension;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.testmanagerservice.extension.ModuleTestDetailsHolder;
import io.ballerina.testmanagerservice.extension.TestFunctionsFinder;
import io.ballerina.testmanagerservice.extension.Utils;
import io.ballerina.testmanagerservice.extension.request.AddTestFunctionRequest;
import io.ballerina.testmanagerservice.extension.request.GetTestFunctionRequest;
import io.ballerina.testmanagerservice.extension.request.TestsDiscoveryRequest;
import io.ballerina.testmanagerservice.extension.request.UpdateTestFunctionRequest;
import io.ballerina.testmanagerservice.extension.response.CommonSourceResponse;
import io.ballerina.testmanagerservice.extension.response.GetTestFunctionResponse;
import io.ballerina.testmanagerservice.extension.response.TestsDiscoveryResponse;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="testManagerService")
public class TestManagerService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return null;
    }

    @JsonRequest
    public CompletableFuture<TestsDiscoveryResponse> discoverInFile(TestsDiscoveryRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    throw new RuntimeException("Test document not found: " + String.valueOf(filePath));
                }
                ModuleTestDetailsHolder moduleTestDetailsHolder = new ModuleTestDetailsHolder();
                TestFunctionsFinder testFunctionsFinder = new TestFunctionsFinder((Document)document.get(), moduleTestDetailsHolder);
                testFunctionsFinder.find();
                return TestsDiscoveryResponse.from(moduleTestDetailsHolder.getGroupsToFunctions());
            }
            catch (Throwable e) {
                return TestsDiscoveryResponse.from(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<TestsDiscoveryResponse> discoverInProject(TestsDiscoveryRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Package currentPackage = project.currentPackage();
                Module defaultModule = currentPackage.getDefaultModule();
                ModuleTestDetailsHolder moduleTestDetailsHolder = new ModuleTestDetailsHolder();
                for (DocumentId documentId : defaultModule.testDocumentIds()) {
                    TestFunctionsFinder testFunctionsFinder = new TestFunctionsFinder(defaultModule.document(documentId), moduleTestDetailsHolder);
                    testFunctionsFinder.find();
                }
                return TestsDiscoveryResponse.from(moduleTestDetailsHolder.getGroupsToFunctions());
            }
            catch (Throwable e) {
                return TestsDiscoveryResponse.from(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<GetTestFunctionResponse> getTestFunction(GetTestFunctionRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                Project project = this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                Optional semanticModel = this.workspaceManager.semanticModel(filePath);
                if (document.isEmpty() || semanticModel.isEmpty()) {
                    return GetTestFunctionResponse.get();
                }
                ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                Optional<FunctionDefinitionNode> matchingFunc = modulePartNode.members().stream().filter(mem -> mem instanceof FunctionDefinitionNode).map(mem -> (FunctionDefinitionNode)mem).filter(mem -> mem.functionName().text().trim().equals(request.functionName())).findFirst();
                return matchingFunc.map(functionDefinitionNode -> GetTestFunctionResponse.from(Utils.getTestFunctionModel(functionDefinitionNode, (SemanticModel)semanticModel.get()))).orElseGet(GetTestFunctionResponse::get);
            }
            catch (Throwable e) {
                return GetTestFunctionResponse.from(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> addTestFunction(AddTestFunctionRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                LineRange lineRange = modulePartNode.lineRange();
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                if (!Utils.isTestModuleImportExists(modulePartNode)) {
                    edits.add(new TextEdit(Utils.toRange(lineRange.startLine()), "import ballerina/test;"));
                }
                String function = Utils.getTestFunctionTemplate(request.function());
                edits.add(new TextEdit(Utils.toRange(lineRange.endLine()), function));
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }

    @JsonRequest
    public CompletableFuture<CommonSourceResponse> updateTestFunction(UpdateTestFunctionRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                int end;
                LineRange lineRange;
                int start;
                Path filePath = Path.of(request.filePath(), new String[0]);
                this.workspaceManager.loadProject(filePath);
                Optional document = this.workspaceManager.document(filePath);
                if (document.isEmpty()) {
                    return new CommonSourceResponse();
                }
                TextDocument textDocument = ((Document)document.get()).syntaxTree().textDocument();
                ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
                NonTerminalNode node = modulePartNode.findNode(TextRange.from((int)(start = textDocument.textPositionFrom((lineRange = request.function().codedata().lineRange()).startLine())), (int)((end = textDocument.textPositionFrom(lineRange.endLine())) - start)), true);
                if (!(node instanceof FunctionDefinitionNode)) {
                    return new CommonSourceResponse();
                }
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                String functionName = functionDefinitionNode.functionName().text().trim();
                LineRange nameRange = functionDefinitionNode.functionName().lineRange();
                if (!functionName.equals(request.function().functionName().value())) {
                    edits.add(new TextEdit(Utils.toRange(nameRange), request.function().functionName().value().toString()));
                }
                LineRange signatureRange = functionDefinitionNode.functionSignature().lineRange();
                String functionSignature = Utils.buildFunctionSignature(request.function());
                edits.add(new TextEdit(Utils.toRange(signatureRange), functionSignature));
                return new CommonSourceResponse(Map.of(request.filePath(), edits));
            }
            catch (Throwable e) {
                return new CommonSourceResponse(e);
            }
        });
    }
}

