/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.testmanagerservice.extension;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.testmanagerservice.extension.Constants;
import io.ballerina.testmanagerservice.extension.model.Annotation;
import io.ballerina.testmanagerservice.extension.model.Codedata;
import io.ballerina.testmanagerservice.extension.model.FunctionParameter;
import io.ballerina.testmanagerservice.extension.model.Metadata;
import io.ballerina.testmanagerservice.extension.model.Property;
import io.ballerina.testmanagerservice.extension.model.TestFunction;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class Utils {
    private Utils() {
    }

    public static String getExprUri(String sourcePath) {
        String exprUriString = "expr" + Paths.get(sourcePath, new String[0]).toUri().toString().substring(4);
        return URI.create(exprUriString).toString();
    }

    public static TestFunction getTestFunctionModel(FunctionDefinitionNode functionDefinitionNode, SemanticModel semanticModel) {
        TestFunction.FunctionBuilder functionBuilder = new TestFunction.FunctionBuilder();
        functionBuilder.metadata(new Metadata("Test Function", "Test Function")).codedata(new Codedata(functionDefinitionNode.lineRange())).functionName(TestFunction.functionName(functionDefinitionNode.functionName().text())).parameters(TestFunction.parameters((SeparatedNodeList<ParameterNode>)functionDefinitionNode.functionSignature().parameters())).returnType(TestFunction.returnType(functionDefinitionNode.functionSignature().returnTypeDesc()));
        functionDefinitionNode.metadata().ifPresent(metadata -> {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (AnnotationNode annotationNode : metadata.annotations()) {
                annotations.add(Utils.getAnnotationModel(annotationNode, semanticModel));
            }
            functionBuilder.annotations(annotations);
        });
        functionBuilder.editable(true);
        return functionBuilder.build();
    }

    public static Annotation getAnnotationModel(AnnotationNode annotationNode, SemanticModel semanticModel) {
        AnnotationSymbol annotationSymbol = (AnnotationSymbol)semanticModel.symbol((Node)annotationNode).get();
        String annotName = annotationSymbol.getName().orElse("");
        if (annotName.isEmpty()) {
            return null;
        }
        Optional annotValue = annotationNode.annotValue();
        MappingConstructorExpressionNode mappingConstructor = annotValue.orElse(null);
        if (annotName.equals("Config")) {
            return Utils.buildConfigAnnotation(mappingConstructor);
        }
        return null;
    }

    private static Annotation buildConfigAnnotation(MappingConstructorExpressionNode mappingConstructor) {
        Annotation.ConfigAnnotationBuilder builder = new Annotation.ConfigAnnotationBuilder();
        builder.metadata(new Metadata("Config", "Test Function Configurations"));
        if (mappingConstructor == null) {
            return builder.build();
        }
        SeparatedNodeList fields = mappingConstructor.fields();
        block8: for (MappingFieldNode field : fields) {
            if (!(field instanceof SpecificFieldNode)) continue;
            SpecificFieldNode specificFieldNode = (SpecificFieldNode)field;
            String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
            Optional expressionNode = specificFieldNode.valueExpr();
            switch (fieldName) {
                case "enabled": {
                    if (!expressionNode.isPresent()) break;
                    String value = ((ExpressionNode)expressionNode.get()).toSourceCode().trim();
                    if (value.equals("false")) {
                        builder.enabled(false);
                        break;
                    }
                    builder.enabled(true);
                    break;
                }
                case "groups": {
                    Object t;
                    if (!expressionNode.isPresent() || !((t = expressionNode.get()) instanceof ListConstructorExpressionNode)) continue block8;
                    ListConstructorExpressionNode expr = (ListConstructorExpressionNode)t;
                    ArrayList<String> groupList = new ArrayList<String>();
                    for (Node groupExpr : expr.expressions()) {
                        groupList.add(groupExpr.toSourceCode().trim());
                    }
                    builder.groups(groupList);
                    break;
                }
            }
        }
        return builder.build();
    }

    public static String getTestFunctionTemplate(TestFunction function) {
        StringBuilder builder = new StringBuilder();
        builder.append(Utils.buildAnnotation(function.annotations())).append(Constants.LINE_SEPARATOR);
        builder.append("function").append(" ").append(function.functionName().value()).append(Utils.buildFunctionSignature(function));
        builder.append(" ").append("{").append(Constants.LINE_SEPARATOR).append("\t").append("do").append(" ").append("{").append(Constants.LINE_SEPARATOR).append("\t").append("}").append(" ").append("on fail error err").append(" ").append("{").append(Constants.LINE_SEPARATOR).append("\t").append("}").append(Constants.LINE_SEPARATOR).append("}");
        return builder.toString();
    }

    public static String buildFunctionSignature(TestFunction function) {
        return Utils.buildFunctionParams(function.parameters()) + Utils.buildReturnType(function.returnType());
    }

    public static String buildFunctionParams(List<FunctionParameter> parameters) {
        if (parameters.isEmpty()) {
            return "()";
        }
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        for (FunctionParameter param : parameters) {
            String type = param.type().value().toString().trim();
            String name = param.variable().value().toString().trim();
            String defaultValue = "";
            if (param.defaultValue() != null) {
                Object value = param.defaultValue().value();
                String string = defaultValue = value != null ? value.toString().trim() : "";
            }
            if (defaultValue.isEmpty()) {
                params.add((CallSite)((Object)(type + " " + name)));
                continue;
            }
            params.add((CallSite)((Object)(type + " " + name + " = " + defaultValue)));
        }
        return "(" + String.join((CharSequence)", ", params) + ")";
    }

    public static String buildReturnType(Property returnType) {
        if (returnType == null || returnType.value() == null || returnType.value().toString().trim().isEmpty()) {
            return "";
        }
        return " returns " + returnType.value().toString().trim();
    }

    public static String buildAnnotation(List<Annotation> annotations) {
        ArrayList<String> annotationStrings = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            StringBuilder builder = new StringBuilder();
            builder.append("@test:").append(annotation.name());
            String annotValue = annotation.name().equals("Config") ? Utils.buildTestConfigAnnotation(annotation) : "";
            if (!annotValue.isEmpty()) {
                builder.append("{").append(Constants.LINE_SEPARATOR).append(annotValue).append(Constants.LINE_SEPARATOR).append("}");
            }
            annotationStrings.add(builder.toString());
        }
        if (annotationStrings.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)Constants.LINE_SEPARATOR, annotationStrings);
    }

    public static String buildTestConfigAnnotation(Annotation annotation) {
        ArrayList<String> fieldStrings = new ArrayList<String>();
        block8: for (Property field : annotation.fields()) {
            String fieldName = field.originalName();
            Object value = field.value();
            switch (fieldName) {
                case "enabled": {
                    String valueStr;
                    if (!(value instanceof String) || !(valueStr = (String)value).equals("false")) continue block8;
                    fieldStrings.add("%s: %s".formatted(fieldName, "false"));
                    break;
                }
                case "groups": {
                    List valueList;
                    if (!(value instanceof List) || (valueList = (List)value).isEmpty() || !(valueList.getFirst() instanceof String)) continue block8;
                    List<String> groupList = valueList.stream().map(Object::toString).toList();
                    String groupStr = "[" + String.join((CharSequence)", ", groupList) + "]";
                    fieldStrings.add("%s: %s".formatted(fieldName, groupStr));
                    break;
                }
            }
        }
        if (fieldStrings.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)("," + Constants.LINE_SEPARATOR), fieldStrings);
    }

    public static boolean isTestModuleImportExists(ModulePartNode node) {
        return node.imports().stream().anyMatch(importDeclarationNode -> {
            String moduleName = importDeclarationNode.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
            return importDeclarationNode.orgName().isPresent() && "ballerina".equals(((ImportOrgNameNode)importDeclarationNode.orgName().get()).orgName().text()) && "test".equals(moduleName);
        });
    }

    public static Range toRange(LineRange lineRange) {
        return new Range(Utils.toPosition(lineRange.startLine()), Utils.toPosition(lineRange.endLine()));
    }

    public static Range toRange(LinePosition position) {
        return new Range(Utils.toPosition(position), Utils.toPosition(position));
    }

    public static Position toPosition(LinePosition linePosition) {
        return new Position(linePosition.line(), linePosition.offset());
    }
}

