/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.testmanagerservice.extension.model;

import io.ballerina.testmanagerservice.extension.model.Codedata;
import io.ballerina.testmanagerservice.extension.model.Metadata;
import io.ballerina.testmanagerservice.extension.model.Property;
import java.util.List;

public record Annotation(Metadata metadata, Codedata codedata, String org, String module, String name, List<Property> fields) {

    public static class ConfigAnnotationBuilder {
        private Metadata metadata;
        private Property groups;
        private Property enabled;

        public void metadata(Metadata metadata) {
            this.metadata = metadata;
        }

        public ConfigAnnotationBuilder groups(List<String> groupList) {
            this.groups = ConfigAnnotationBuilder.value("Groups", "Groups to run", groupList, "EXPRESSION_SET", "groups");
            return this;
        }

        public void enabled(boolean enabled) {
            this.enabled = ConfigAnnotationBuilder.value("Enabled", "Enable/Disable the test", enabled, "FLAG", "enabled");
        }

        private static Property value(String label, String description, Object value, String valueType, String originalName) {
            Property.PropertyBuilder builder = new Property.PropertyBuilder();
            builder.metadata(new Metadata(label, description));
            builder.valueType(valueType);
            builder.originalName(originalName);
            builder.value(value);
            builder.advanced(false);
            builder.editable(true);
            builder.optional(true);
            return builder.build();
        }

        public Annotation build() {
            if (this.groups == null) {
                this.groups = ConfigAnnotationBuilder.value("Groups", "Groups to run", List.of(), "EXPRESSION_SET", "groups");
            }
            if (this.enabled == null) {
                this.enabled = ConfigAnnotationBuilder.value("Enabled", "Enable/Disable the test", true, "FLAG", "enabled");
            }
            String org = "ballerina";
            String module = "test";
            String name = "Config";
            return new Annotation(this.metadata, null, org, module, name, List.of(this.groups, this.enabled));
        }
    }
}

