/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.deserializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.deserializers.BooleanDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.BytesDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.DoubleDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.EnumDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.Fixed32Deserializer;
import io.ballerina.stdlib.protobuf.deserializers.Fixed64Deserializer;
import io.ballerina.stdlib.protobuf.deserializers.FloatDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.Int32Deserializer;
import io.ballerina.stdlib.protobuf.deserializers.Int64Deserializer;
import io.ballerina.stdlib.protobuf.deserializers.MessageDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.StringDeserializer;
import io.ballerina.stdlib.protobuf.deserializers.UInt32Deserializer;
import io.ballerina.stdlib.protobuf.deserializers.UInt64Deserializer;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.utils.DescriptorBuilder;
import io.ballerina.stdlib.protobuf.utils.Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class DeserializeHandler {
    private final Descriptors.Descriptor messageDescriptor;
    private final CodedInputStream input;
    private final BMessage bMessage;
    private final Map<Integer, Descriptors.FieldDescriptor> fieldDescriptors;
    private final Type messageType;
    private final Type targetType;

    public DeserializeHandler(String descriptor, String hexInput, Type targetType, Type messageType) throws Descriptors.DescriptorValidationException, IOException {
        String targetTypeName = messageType.getName();
        this.input = DescriptorBuilder.getCodedInputStream(hexInput);
        this.messageDescriptor = DescriptorBuilder.getMessageDescriptor(descriptor, targetTypeName);
        this.fieldDescriptors = DescriptorBuilder.computeFieldTagValues(this.messageDescriptor);
        this.messageType = messageType;
        this.targetType = targetType;
        this.bMessage = new BMessage(this.initBMessage(this.input, this.fieldDescriptors, messageType, targetTypeName));
    }

    public DeserializeHandler(Descriptors.FieldDescriptor fieldDescriptor, CodedInputStream input, Type targetType, Type messageType) throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        this.input = input;
        this.messageDescriptor = DescriptorBuilder.getMessageDescriptor(fieldDescriptor, messageType);
        this.fieldDescriptors = DescriptorBuilder.computeFieldTagValues(this.messageDescriptor);
        this.messageType = messageType;
        this.targetType = targetType;
        this.bMessage = new BMessage(this.initBMessage(input, this.fieldDescriptors, messageType, this.messageDescriptor.getFullName()));
    }

    public DeserializeHandler(Descriptors.Descriptor messageDescriptor, String hexInput, Type targetType, Type messageType) throws IOException {
        this.input = DescriptorBuilder.getCodedInputStream(hexInput);
        this.messageDescriptor = messageDescriptor;
        this.fieldDescriptors = DescriptorBuilder.computeFieldTagValues(messageDescriptor);
        this.messageType = messageType;
        this.targetType = targetType;
        this.bMessage = new BMessage(this.initBMessage(this.input, this.fieldDescriptors, messageType, messageDescriptor.getFullName()));
    }

    public Object getBMessage() {
        return this.bMessage.getContent();
    }

    public void deserialize() throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        block17: while (!this.input.isAtEnd()) {
            int tag;
            try {
                tag = this.input.readTag();
            }
            catch (InvalidProtocolBufferException e) {
                tag = this.input.getLastTag();
            }
            Descriptors.FieldDescriptor fieldDescriptor = this.fieldDescriptors.get(tag);
            if (fieldDescriptor == null) continue;
            boolean isPacked = this.isPacked(fieldDescriptor, tag);
            int limit = 0;
            if (isPacked) {
                limit = this.pushLimit();
            }
            switch (fieldDescriptor.getType().toProto().getNumber()) {
                case 1: {
                    new DoubleDeserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 2: {
                    new FloatDeserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 3: {
                    new Int64Deserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 4: {
                    new UInt64Deserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 5: {
                    new Int32Deserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 13: {
                    new UInt32Deserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 6: {
                    new Fixed64Deserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 7: {
                    new Fixed32Deserializer(this.input, fieldDescriptor, this.bMessage, this.targetType, isPacked).deserialize();
                    break;
                }
                case 8: {
                    new BooleanDeserializer(this.input, fieldDescriptor, this.bMessage, this.targetType).deserialize();
                    break;
                }
                case 9: {
                    new StringDeserializer(this.input, fieldDescriptor, this.bMessage, this.targetType).deserialize();
                    break;
                }
                case 14: {
                    new EnumDeserializer(this.input, fieldDescriptor, this.bMessage, this.targetType).deserialize();
                    break;
                }
                case 12: {
                    new BytesDeserializer(this.input, fieldDescriptor, this.bMessage, this.targetType).deserialize();
                    break;
                }
                case 11: {
                    new MessageDeserializer(this.input, fieldDescriptor, this.messageType, this.bMessage, this.targetType).deserialize();
                    break;
                }
                default: {
                    continue block17;
                }
            }
            if (!isPacked) continue;
            this.popLimit(limit);
        }
    }

    private boolean isPacked(Descriptors.FieldDescriptor fieldDescriptor, int tag) {
        if (fieldDescriptor.isRepeated() && fieldDescriptor.isPacked()) {
            int byteCode = (fieldDescriptor.getNumber() << 3) + 2;
            return byteCode == tag;
        }
        return false;
    }

    private int pushLimit() throws IOException {
        int length = this.input.readRawVarint32();
        return this.input.pushLimit(length);
    }

    private void popLimit(int limit) {
        this.input.popLimit(limit);
    }

    Object initBMessage(CodedInputStream input, Map<Integer, Descriptors.FieldDescriptor> fieldDescriptors, Type type, String messageName) throws IOException {
        BMap bBMap = null;
        BMap bMessage = null;
        if (type != null) {
            int typeUrlTag;
            boolean isTimestampMessage;
            boolean isAnyTypedMessage = "google.protobuf.Any".equals(messageName) && fieldDescriptors.values().stream().allMatch(fd -> fd.getFullName().contains("google.protobuf.Any"));
            boolean bl = isTimestampMessage = (type.getTag() == 34 || type.getTag() == 44) && messageName.equals("google.protobuf.Timestamp");
            if (type.getTag() == 24 && !isAnyTypedMessage) {
                bMessage = bBMap = ValueCreator.createRecordValue((Module)type.getPackage(), (String)type.getName());
            } else if (isTimestampMessage) {
                TupleType tupleType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_DECIMAL));
                BArray bArray = ValueCreator.createTupleValue((TupleType)tupleType);
                bMessage = bArray;
            } else if (type.getTag() == 4) {
                bMessage = ValueCreator.createDecimalValue((BigDecimal)new BigDecimal(0));
            } else if (type.getTag() == 27 && !isAnyTypedMessage) {
                bMessage = bBMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_ANYDATA));
            } else if (type.getTag() == 44) {
                TupleType tupleType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_STRING, PredefinedTypes.TYPE_ANYDATA));
                BArray bArray = ValueCreator.createTupleValue((TupleType)tupleType);
                bMessage = bArray;
            } else if (type.getTag() == 32) {
                BArray bArray = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANYDATA));
                bMessage = bArray;
            } else if (isAnyTypedMessage && input != null && (typeUrlTag = input.readTag()) == 10) {
                String typeUrl = input.readStringRequireUtf8();
                this.skipUnnecessaryAnyTypeTags(input);
                String s = Utils.bytesToHex(this.codeInputStreamAnyTypeByteArray(input));
                bMessage = StringUtils.fromString((String)s);
                BMap anyMap = ValueCreator.createRecordValue((Module)type.getPackage(), (String)type.getName());
                anyMap.put((Object)StringUtils.fromString((String)"typeUrl"), (Object)StringUtils.fromString((String)typeUrl));
                anyMap.put((Object)StringUtils.fromString((String)"value"), (Object)bMessage);
                bMessage = anyMap;
                return bMessage;
            }
        }
        return bMessage;
    }

    public void skipUnnecessaryAnyTypeTags(CodedInputStream input) throws IOException {
        try {
            input.readTag();
            input.readTag();
        }
        catch (InvalidProtocolBufferException e) {
            input.getLastTag();
        }
    }

    private byte[] codeInputStreamAnyTypeByteArray(CodedInputStream input) throws IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (!input.isAtEnd()) {
            byteList.add(input.readRawByte());
        }
        byte[] byteArray = new byte[byteList.size()];
        for (int i = 0; i < byteList.size(); ++i) {
            byteArray[i] = (Byte)byteList.get(i);
        }
        return byteArray;
    }
}

