/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import io.ballerina.stdlib.protobuf.serializers.MessageSerializer;
import io.ballerina.stdlib.protobuf.serializers.SerializeHandler;
import io.ballerina.stdlib.protobuf.utils.DescriptorBuilder;
import java.io.IOException;

public class BytesSerializer
extends AbstractSerializer {
    public BytesSerializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() throws Descriptors.DescriptorValidationException, IOException, AnnotationUnavailableException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray && !"Any".equals(this.messageName)) {
                    BArray valueArray = (BArray)bValue;
                    this.bMessage.incrementSize(this.computeMessageSize(valueArray.getBytes()));
                } else if ("Any".equals(this.messageName)) {
                    String typeUrl = ((BMap)this.bMessage.getContent()).getStringValue(StringUtils.fromString((String)"typeUrl")).getValue();
                    String typeName = this.getTypeNameFromTypeUrl(typeUrl);
                    Object value = ((BMap)this.bMessage.getContent()).get((Object)StringUtils.fromString((String)"value"));
                    Descriptors.Descriptor descriptor = DescriptorBuilder.findFieldDescriptorFromTypeUrl(value, typeName);
                    SerializeHandler serializeHandler = new SerializeHandler(this.output, descriptor, value);
                    this.bMessage.incrementSize(serializeHandler.getSize());
                }
            }
        } else if (this.isBArray()) {
            BArray valueArray = (BArray)this.bMessage.getContent();
            this.bMessage.incrementSize(this.computeMessageSize(valueArray.getBytes()));
        }
    }

    @Override
    public void serialize() throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray && !"Any".equals(this.messageName)) {
                    BArray valueArray = (BArray)bValue;
                    this.output.writeByteArray(this.fieldDescriptor.getNumber(), valueArray.getBytes());
                } else if ("Any".equals(this.messageName)) {
                    String typeUrl = ((BMap)this.bMessage.getContent()).getStringValue(StringUtils.fromString((String)"typeUrl")).getValue();
                    String typeName = this.getTypeNameFromTypeUrl(typeUrl);
                    Object value = ((BMap)this.bMessage.getContent()).get((Object)StringUtils.fromString((String)"value"));
                    Descriptors.Descriptor descriptor = DescriptorBuilder.findFieldDescriptorFromTypeUrl(value, typeName);
                    BMessage intermediateMessage = new BMessage(value);
                    MessageSerializer messageSerializer = new MessageSerializer(descriptor.findFieldByName(typeUrl), intermediateMessage);
                    messageSerializer.computeMessageSize();
                    this.output.writeTag(this.fieldDescriptor.getNumber(), 2);
                    this.output.writeUInt32NoTag(messageSerializer.getSize());
                    messageSerializer.serialize();
                }
            }
        } else if (this.isBArray()) {
            BArray valueArray = (BArray)this.bMessage.getContent();
            this.writeContent(valueArray.getBytes());
        }
    }

    private String getTypeNameFromTypeUrl(String typeUrl) {
        String[] types = typeUrl.split("/");
        return types[types.length - 1].trim();
    }

    private int computeMessageSize(byte[] value) {
        return CodedOutputStream.computeByteArraySize((int)this.fieldDescriptor.getNumber(), (byte[])value);
    }

    private void writeContent(byte[] content) throws IOException {
        this.output.writeByteArray(this.fieldDescriptor.getNumber(), content);
    }
}

