/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;

public class DoubleSerializer
extends AbstractSerializer {
    public DoubleSerializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.bMessage.incrementSize(this.computeMessageSize(valueArray.getFloat((long)i)));
                    }
                } else {
                    this.bMessage.incrementSize(this.computeMessageSize((Double)bValue));
                }
            }
        } else if (this.bMessage.getContent() instanceof Integer) {
            this.bMessage.incrementSize(this.computeMessageSize(((Integer)this.bMessage.getContent()).intValue()));
        } else if (this.bMessage.getContent() instanceof Long) {
            this.bMessage.incrementSize(this.computeMessageSize(((Long)this.bMessage.getContent()).longValue()));
        } else if (this.bMessage.getContent() instanceof Double) {
            this.bMessage.incrementSize(this.computeMessageSize((Double)this.bMessage.getContent()));
        }
    }

    @Override
    public void serialize() throws IOException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.writeContent(valueArray.getFloat((long)i));
                    }
                } else {
                    this.writeContent((Double)bValue);
                }
            }
        } else if (this.bMessage.getContent() instanceof Double) {
            this.writeContent((Double)this.bMessage.getContent());
        } else if (this.bMessage.getContent() instanceof Integer) {
            this.writeContent(((Integer)this.bMessage.getContent()).intValue());
        } else if (this.bMessage.getContent() instanceof Long) {
            this.writeContent(((Long)this.bMessage.getContent()).longValue());
        }
    }

    private int computeMessageSize(double value) {
        return CodedOutputStream.computeDoubleSize((int)this.fieldDescriptor.getNumber(), (double)value);
    }

    private void writeContent(double content) throws IOException {
        this.output.writeDouble(this.fieldDescriptor.getNumber(), content);
    }
}

