/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.nativeimpl.ProtobufConstants;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;

public class Int32Serializer
extends AbstractSerializer {
    public Int32Serializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.bMessage.incrementSize(this.computeMessageSize(this.getIntValue(valueArray.getInt((long)i))));
                    }
                } else {
                    this.bMessage.incrementSize(this.computeMessageSize(this.getIntValue(bValue)));
                }
            }
        } else if (this.bMessage.getContent() instanceof Long) {
            this.bMessage.incrementSize(this.computeMessageSize(this.getIntValue(this.bMessage.getContent())));
        } else if (this.fieldDescriptor.getFullName().equals("google.protobuf.Timestamp.nanos") && this.isBArray()) {
            BArray array = (BArray)this.bMessage.getContent();
            BigDecimal nanos = new BigDecimal(array.get(1L).toString()).multiply(ProtobufConstants.ANALOG_GIGA, MathContext.DECIMAL128);
            this.bMessage.incrementSize(this.computeMessageSize(nanos.intValue()));
        } else if (this.bMessage.getContent() instanceof BDecimal && this.fieldDescriptor.getFullName().equals("google.protobuf.Duration.nanos")) {
            int intVal = ((BDecimal)this.bMessage.getContent()).value().intValue();
            BigDecimal b = ((BDecimal)this.bMessage.getContent()).value().subtract(new BigDecimal(intVal)).multiply(ProtobufConstants.ANALOG_GIGA, MathContext.DECIMAL128);
            this.bMessage.incrementSize(this.computeMessageSize(b.intValue()));
        }
    }

    @Override
    public void serialize() throws IOException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.writeContent(this.getIntValue(valueArray.getInt((long)i)));
                    }
                } else {
                    this.writeContent(this.getIntValue(bValue));
                }
            }
        } else if (this.isBArray() && this.fieldDescriptor.getFullName().equals("google.protobuf.Timestamp.nanos")) {
            BArray bArray = (BArray)this.bMessage.getContent();
            BigDecimal nanos = new BigDecimal(bArray.get(1L).toString()).multiply(ProtobufConstants.ANALOG_GIGA);
            this.writeContent(nanos.intValue());
        } else if (this.bMessage.getContent() instanceof BDecimal && this.fieldDescriptor.getFullName().equals("google.protobuf.Duration.nanos")) {
            int intVal = ((BDecimal)this.bMessage.getContent()).value().intValue();
            BigDecimal b = ((BDecimal)this.bMessage.getContent()).value().subtract(new BigDecimal(intVal));
            this.writeContent(b.multiply(ProtobufConstants.ANALOG_GIGA).intValue());
        } else if (this.bMessage.getContent() instanceof Long) {
            this.writeContent(this.getIntValue(this.bMessage.getContent()));
        }
    }

    private int computeMessageSize(int value) {
        return CodedOutputStream.computeInt32Size((int)this.fieldDescriptor.getNumber(), (int)value);
    }

    private void writeContent(int content) throws IOException {
        this.output.writeInt32(this.fieldDescriptor.getNumber(), content);
    }
}

