/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;

public class UInt64Serializer
extends AbstractSerializer {
    public UInt64Serializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.bMessage.incrementSize(this.computeMessageSize(valueArray.getInt((long)i)));
                    }
                } else {
                    this.bMessage.incrementSize(this.computeMessageSize((Long)bValue));
                }
            }
        } else if (this.bMessage.getContent() instanceof Long) {
            this.bMessage.incrementSize(this.computeMessageSize((Long)this.bMessage.getContent()));
        }
    }

    @Override
    public void serialize() throws IOException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.writeContent(valueArray.getInt((long)i));
                    }
                } else {
                    this.writeContent((Long)bValue);
                }
            }
        } else if (this.bMessage.getContent() instanceof Long) {
            this.writeContent((Long)this.bMessage.getContent());
        }
    }

    private int computeMessageSize(long value) {
        return CodedOutputStream.computeUInt64Size((int)this.fieldDescriptor.getNumber(), (long)value);
    }

    private void writeContent(long content) throws IOException {
        this.output.writeUInt64(this.fieldDescriptor.getNumber(), content);
    }
}

