/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.utils;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.utils.StandardDescriptorBuilder;
import io.ballerina.stdlib.protobuf.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public class DescriptorBuilder {
    private DescriptorBuilder() {
    }

    public static Map<Integer, Descriptors.FieldDescriptor> computeFieldTagValues(Descriptors.Descriptor messageDescriptor) {
        HashMap<Integer, Descriptors.FieldDescriptor> fieldDescriptors = new HashMap<Integer, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor fieldDescriptor : messageDescriptor.getFields()) {
            Descriptors.FieldDescriptor.Type fieldType = fieldDescriptor.getType();
            int number = fieldDescriptor.getNumber();
            int byteCode = (number << 3) + StandardDescriptorBuilder.getFieldWireType(fieldType);
            fieldDescriptors.put(byteCode, fieldDescriptor);
            if (!fieldDescriptor.isRepeated()) continue;
            byteCode = (number << 3) + 2;
            fieldDescriptors.put(byteCode, fieldDescriptor);
        }
        return fieldDescriptors;
    }

    public static Descriptors.Descriptor findFieldDescriptorFromTypeUrl(Object value, String messageName) throws Descriptors.DescriptorValidationException, InvalidProtocolBufferException, AnnotationUnavailableException {
        BMap bMap;
        RecordType recordType;
        if (messageName.startsWith("google.protobuf")) {
            return StandardDescriptorBuilder.findGoogleDescriptorFromName(messageName);
        }
        if (value instanceof BMap && Utils.isDescriptorAnnotationAvailable(recordType = (RecordType)(bMap = (BMap)value).getType())) {
            return DescriptorBuilder.getDescriptorFromRecord(recordType);
        }
        throw new AnnotationUnavailableException("Expected annotation unavailable in the record " + messageName);
    }

    public static Descriptors.Descriptor findFieldDescriptorFromTypeUrl(RecordType recordType, String messageName) throws AnnotationUnavailableException, Descriptors.DescriptorValidationException, InvalidProtocolBufferException {
        if (messageName.startsWith("google.protobuf")) {
            return StandardDescriptorBuilder.findGoogleDescriptorFromName(messageName);
        }
        if (Utils.isDescriptorAnnotationAvailable(recordType)) {
            return DescriptorBuilder.getDescriptorFromRecord(recordType);
        }
        throw new AnnotationUnavailableException("Expected annotation unavailable in the record " + recordType.getName());
    }

    public static Descriptors.Descriptor getDescriptorFromRecord(RecordType recordType) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        BMap annotations;
        String annotation;
        byte[] annotationAsBytes;
        DescriptorProtos.FileDescriptorProto file;
        Descriptors.FileDescriptor fileDescriptor;
        Descriptors.Descriptor desc;
        if (Utils.isDescriptorAnnotationAvailable(recordType) && (desc = (fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)(file = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])(annotationAsBytes = Utils.hexToBytes(annotation = Utils.filterDescAnnotation((BMap<BString, Object>)(annotations = recordType.getAnnotations())))))), (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0], (boolean)true)).findMessageTypeByName(recordType.getName())) != null) {
            return desc;
        }
        throw new AnnotationUnavailableException("Expected annotation unavailable in the record " + recordType.getName());
    }

    public static CodedInputStream getCodedInputStream(String hexInput) {
        byte[] byteContent = Utils.hexToBytes(hexInput);
        return CodedInputStream.newInstance((byte[])byteContent);
    }

    public static Descriptors.Descriptor getMessageDescriptor(String descriptor, String targetTypeName) throws Descriptors.DescriptorValidationException, InvalidProtocolBufferException {
        byte[] descriptorBytes = Utils.hexToBytes(descriptor);
        DescriptorProtos.FileDescriptorProto file = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])descriptorBytes);
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)file, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0], (boolean)true);
        return fileDescriptor.findMessageTypeByName(targetTypeName);
    }

    public static Descriptors.Descriptor getMessageDescriptor(Descriptors.FieldDescriptor fieldDescriptor, Type messageType) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException, AnnotationUnavailableException {
        if (fieldDescriptor.getMessageType().getFile().getFullName().endsWith(".placeholder.proto")) {
            if (fieldDescriptor.getMessageType().getFile().getFullName().startsWith("google.protobuf")) {
                String messageName = fieldDescriptor.getMessageType().getFile().getFullName().replace(".placeholder.proto", "");
                return DescriptorBuilder.getDescriptorForPredefinedTypes(messageName);
            }
            if (messageType instanceof RecordType) {
                return DescriptorBuilder.getDescriptorFromRecord((RecordType)messageType);
            }
        }
        return fieldDescriptor.getMessageType();
    }

    private static Descriptors.Descriptor getDescriptorForPredefinedTypes(String messageName) {
        Descriptors.FileDescriptor fileDescriptor = StandardDescriptorBuilder.getFileDescriptorFromMessageName(messageName);
        return fileDescriptor.findMessageTypeByName(DescriptorBuilder.extractMessageNameWithoutNamespace(messageName));
    }

    private static String extractMessageNameWithoutNamespace(String messageName) {
        String[] messageEntries = messageName.split("\\.");
        return messageEntries[messageEntries.length - 1];
    }
}

