/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.utils;

import com.google.protobuf.AnyProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DurationProto;
import com.google.protobuf.EmptyProto;
import com.google.protobuf.StructProto;
import com.google.protobuf.TimestampProto;
import com.google.protobuf.WrappersProto;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StandardDescriptorBuilder {
    private static final Map<String, Descriptors.FileDescriptor> standardLibDescriptorMapForMessageName = new HashMap<String, Descriptors.FileDescriptor>();
    public static final Map<DescriptorProtos.FieldDescriptorProto.Type, Integer> WIRE_TYPE_MAP;

    private StandardDescriptorBuilder() {
    }

    public static Descriptors.FileDescriptor getFileDescriptorFromMessageName(String messageName) {
        return standardLibDescriptorMapForMessageName.get(messageName);
    }

    public static int getFieldWireType(Descriptors.FieldDescriptor.Type fieldType) {
        if (fieldType == null) {
            return -1;
        }
        Integer wireType = WIRE_TYPE_MAP.get(fieldType.toProto());
        if (wireType != null) {
            return wireType;
        }
        return 2;
    }

    public static Descriptors.Descriptor findGoogleDescriptorFromName(String typeName) {
        String messageName = typeName.replace("google.protobuf.", "");
        switch (typeName) {
            case "google.protobuf.DoubleValue": 
            case "google.protobuf.FloatValue": 
            case "google.protobuf.Int64Value": 
            case "google.protobuf.UInt64Value": 
            case "google.protobuf.Int32Value": 
            case "google.protobuf.UInt32Value": 
            case "google.protobuf.BoolValue": 
            case "google.protobuf.StringValue": 
            case "google.protobuf.BytesValue": {
                return WrappersProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Any": {
                return AnyProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Empty": {
                return EmptyProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Timestamp": {
                return TimestampProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Duration": {
                return DurationProto.getDescriptor().findMessageTypeByName(messageName);
            }
            case "google.protobuf.Struct": {
                return StructProto.getDescriptor().findMessageTypeByName(messageName);
            }
        }
        return null;
    }

    static {
        standardLibDescriptorMapForMessageName.put("google.protobuf.Any", AnyProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.Empty", EmptyProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.Timestamp", TimestampProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.Duration", DurationProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.Struct", StructProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.DoubleValue", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.FloatValue", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.Int64Value", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.UInt64Value", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.Int32Value", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.UInt32Value", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.BoolValue", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.StringValue", WrappersProto.getDescriptor());
        standardLibDescriptorMapForMessageName.put("google.protobuf.BytesValue", WrappersProto.getDescriptor());
        HashMap<DescriptorProtos.FieldDescriptorProto.Type, Integer> wireMap = new HashMap<DescriptorProtos.FieldDescriptorProto.Type, Integer>();
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE, 1);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT, 5);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32, 5);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64, 1);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32, 5);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64, 1);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING, 2);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, 2);
        WIRE_TYPE_MAP = Collections.unmodifiableMap(wireMap);
    }
}

