/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.xmldata;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.xmldata.XmlToJson;
import io.ballerina.stdlib.xmldata.utils.XmlDataUtils;
import java.util.Map;

public final class XmlToRecord {
    private XmlToRecord() {
    }

    public static Object toRecord(BXml xml, boolean preserveNamespaces, BTypedesc type) {
        return XmlToRecord.toRecord(xml, preserveNamespaces, "_", type);
    }

    public static Object toRecord(BXml xml, boolean preserveNamespaces, String attributePrefix, BTypedesc type) {
        try {
            Object jsonObject = XmlToRecord.convertToJson(xml, preserveNamespaces, attributePrefix, type);
            if (jsonObject instanceof BError) {
                return XmlDataUtils.getError("XML type mismatch with record type: " + String.valueOf(((BError)((Object)jsonObject)).getErrorMessage()));
            }
            return XmlToRecord.getJsonObject(type, jsonObject);
        }
        catch (Exception e) {
            return XmlDataUtils.getError("Failed to convert xml to record type: " + e.getMessage());
        }
    }

    private static Object getJsonObject(BTypedesc type, Object jsonObject) {
        try {
            return ValueUtils.convert((Object)jsonObject, (Type)type.getDescribingType());
        }
        catch (BError bError) {
            return XmlDataUtils.getError("XML type mismatch with record type: " + ((Map)bError.getDetails()).get(StringUtils.fromString((String)"message")).toString());
        }
    }

    public static Object convertToJson(BXml xml, boolean preserveNamespaces, String attributePrefix, BTypedesc type) throws Exception {
        Type describingType = type.getDescribingType();
        XmlToRecord.validateRecordType(describingType);
        return XmlToJson.toJson(xml, preserveNamespaces, attributePrefix, describingType);
    }

    private static void validateRecordType(Type type) throws Exception {
        Type fieldType;
        if (type instanceof RecordType) {
            Map fields = ((RecordType)type).getFields();
            for (Map.Entry entry : fields.entrySet()) {
                Field field = (Field)entry.getValue();
                Type fieldType2 = field.getFieldType();
                if (!field.getFieldType().isNilable()) continue;
                throw new Exception("The record field: " + field.getFieldName() + " does not support the optional value type: " + String.valueOf(fieldType2));
            }
        } else if (type instanceof ArrayType && (fieldType = ((ArrayType)type).getElementType()) instanceof RecordType) {
            XmlToRecord.validateRecordType(fieldType);
        }
    }
}

