/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.parser.AbstractParserErrorHandler;
import io.ballerina.toml.internal.parser.AbstractTokenReader;
import io.ballerina.toml.internal.parser.ParserRuleContext;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.ArrayDeque;

public class TomlParserErrorHandler
extends AbstractParserErrorHandler {
    private static final ParserRuleContext[] TOP_LEVEL_NODE = new ParserRuleContext[]{ParserRuleContext.EOF, ParserRuleContext.NEWLINE, ParserRuleContext.KEY_VALUE_PAIR, ParserRuleContext.TOML_TABLE, ParserRuleContext.TOML_TABLE_ARRAY};
    private static final ParserRuleContext[] ARRAY_VALUE_END = new ParserRuleContext[]{ParserRuleContext.COMMA, ParserRuleContext.ARRAY_VALUE_LIST_END};
    private static final ParserRuleContext[] INLINE_TABLE_ENTRY_END = new ParserRuleContext[]{ParserRuleContext.COMMA, ParserRuleContext.INLINE_TABLE_END};
    private static final ParserRuleContext[] ARRAY_VALUE_START_OR_VALUE_LIST_END = new ParserRuleContext[]{ParserRuleContext.ARRAY_VALUE_LIST_END, ParserRuleContext.ARRAY_VALUE_START};
    private static final ParserRuleContext[] INLINE_TABLE_START_OR_TABLE_ENTRY_LIST_END = new ParserRuleContext[]{ParserRuleContext.INLINE_TABLE_END, ParserRuleContext.INLINE_TABLE_ENTRY_START};
    private static final ParserRuleContext[] NUMERICAL_LITERAL = new ParserRuleContext[]{ParserRuleContext.DECIMAL_INTEGER_LITERAL, ParserRuleContext.DECIMAL_FLOATING_POINT_LITERAL, ParserRuleContext.HEX_INTEGER_LITERAL, ParserRuleContext.OCTAL_INTEGER_LITERAL, ParserRuleContext.BINARY_INTEGER_LITERAL};
    private static final ParserRuleContext[] VALUE = new ParserRuleContext[]{ParserRuleContext.STRING_START, ParserRuleContext.LITERAL_STRING_START, ParserRuleContext.MULTILINE_STRING_START, ParserRuleContext.MULTILINE_LITERAL_STRING_START, ParserRuleContext.SIGN_TOKEN, ParserRuleContext.BOOLEAN_LITERAL, ParserRuleContext.NUMERICAL_LITERAL, ParserRuleContext.ARRAY_VALUE_LIST_START, ParserRuleContext.INLINE_TABLE_START};
    private static final ParserRuleContext[] ARRAY_VALUE_START = VALUE;
    private static final ParserRuleContext[] KEY_START = new ParserRuleContext[]{ParserRuleContext.IDENTIFIER_LITERAL, ParserRuleContext.NUMERICAL_LITERAL, ParserRuleContext.BOOLEAN_LITERAL, ParserRuleContext.STRING_START, ParserRuleContext.LITERAL_STRING_START};
    private static final ParserRuleContext[] KEY_END = new ParserRuleContext[]{ParserRuleContext.DOT, ParserRuleContext.KEY_LIST_END};
    private static final ParserRuleContext[] KEY_LIST_END = new ParserRuleContext[]{ParserRuleContext.ASSIGN_OP, ParserRuleContext.TABLE_END, ParserRuleContext.ARRAY_TABLE_FIRST_END};
    private static final ParserRuleContext[] STRING_CONTENT = new ParserRuleContext[]{ParserRuleContext.STRING_END, ParserRuleContext.STRING_BODY};
    private static final ParserRuleContext[] MULTILINE_STRING_CONTENT = new ParserRuleContext[]{ParserRuleContext.MULTILINE_STRING_END, ParserRuleContext.MULTILINE_STRING_BODY};
    private static final ParserRuleContext[] LITERAL_STRING_CONTENT = new ParserRuleContext[]{ParserRuleContext.LITERAL_STRING_END, ParserRuleContext.LITERAL_STRING_BODY};
    private static final ParserRuleContext[] MULTILINE_LITERAL_STRING_CONTENT = new ParserRuleContext[]{ParserRuleContext.MULTILINE_LITERAL_STRING_END, ParserRuleContext.MULTILINE_LITERAL_STRING_BODY};

    public TomlParserErrorHandler(AbstractTokenReader tokenReader) {
        super(tokenReader);
    }

    @Override
    protected AbstractParserErrorHandler.Result seekMatch(ParserRuleContext currentCtx, int lookahead, int currentDepth, boolean isEntryPoint) {
        int matchingRulesCount = 0;
        while (currentDepth < 5) {
            boolean hasMatch = true;
            boolean skipRule = false;
            STToken nextToken = this.tokenReader.peek(lookahead);
            switch (currentCtx) {
                case EOF: {
                    hasMatch = nextToken.kind == SyntaxKind.EOF_TOKEN;
                    break;
                }
                case ASSIGN_OP: {
                    hasMatch = nextToken.kind == SyntaxKind.EQUAL_TOKEN;
                    break;
                }
                case ARRAY_TABLE_FIRST_START: 
                case ARRAY_TABLE_SECOND_START: 
                case TABLE_START: 
                case ARRAY_VALUE_LIST_START: {
                    hasMatch = nextToken.kind == SyntaxKind.OPEN_BRACKET_TOKEN;
                    break;
                }
                case ARRAY_TABLE_FIRST_END: 
                case ARRAY_TABLE_SECOND_END: 
                case TABLE_END: 
                case ARRAY_VALUE_LIST_END: {
                    hasMatch = nextToken.kind == SyntaxKind.CLOSE_BRACKET_TOKEN;
                    break;
                }
                case INLINE_TABLE_END: {
                    hasMatch = nextToken.kind == SyntaxKind.CLOSE_BRACE_TOKEN;
                    break;
                }
                case STRING_START: 
                case STRING_END: {
                    hasMatch = nextToken.kind == SyntaxKind.DOUBLE_QUOTE_TOKEN;
                    break;
                }
                case MULTILINE_STRING_START: 
                case MULTILINE_STRING_END: {
                    hasMatch = nextToken.kind == SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN;
                    break;
                }
                case LITERAL_STRING_START: 
                case LITERAL_STRING_END: {
                    hasMatch = nextToken.kind == SyntaxKind.SINGLE_QUOTE_TOKEN;
                    break;
                }
                case MULTILINE_LITERAL_STRING_START: 
                case MULTILINE_LITERAL_STRING_END: {
                    hasMatch = nextToken.kind == SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN;
                    break;
                }
                case INLINE_TABLE_START: {
                    hasMatch = nextToken.kind == SyntaxKind.OPEN_BRACE_TOKEN;
                    break;
                }
                case COMMA: {
                    hasMatch = nextToken.kind == SyntaxKind.COMMA_TOKEN;
                    break;
                }
                case DOT: {
                    hasMatch = nextToken.kind == SyntaxKind.DOT_TOKEN;
                    break;
                }
                case DECIMAL_INTEGER_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.DECIMAL_INT_TOKEN;
                    break;
                }
                case DECIMAL_FLOATING_POINT_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.DECIMAL_FLOAT_TOKEN;
                    break;
                }
                case HEX_INTEGER_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.HEX_INTEGER_LITERAL_TOKEN;
                    break;
                }
                case OCTAL_INTEGER_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.OCTAL_INTEGER_LITERAL_TOKEN;
                    break;
                }
                case BINARY_INTEGER_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.BINARY_INTEGER_LITERAL_TOKEN;
                    break;
                }
                case BOOLEAN_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.TRUE_KEYWORD || nextToken.kind == SyntaxKind.FALSE_KEYWORD;
                    break;
                }
                case STRING_BODY: 
                case LITERAL_STRING_BODY: 
                case MULTILINE_STRING_BODY: 
                case MULTILINE_LITERAL_STRING_BODY: {
                    hasMatch = nextToken.kind == SyntaxKind.STRING_LITERAL_TOKEN || nextToken.kind == SyntaxKind.ML_STRING_LITERAL || nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL;
                    break;
                }
                case IDENTIFIER_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL;
                    break;
                }
                case NEWLINE: {
                    hasMatch = nextToken.kind == SyntaxKind.NEWLINE;
                    break;
                }
                case SIGN_TOKEN: {
                    hasMatch = nextToken.kind == SyntaxKind.PLUS_TOKEN || nextToken.kind == SyntaxKind.MINUS_TOKEN;
                    break;
                }
                case STRING_CONTENT: {
                    ParserRuleContext[] alternativeRules = STRING_CONTENT;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case MULTILINE_STRING_CONTENT: {
                    ParserRuleContext[] alternativeRules = MULTILINE_STRING_CONTENT;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case LITERAL_STRING_CONTENT: {
                    ParserRuleContext[] alternativeRules = LITERAL_STRING_CONTENT;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case MULTILINE_LITERAL_STRING_CONTENT: {
                    ParserRuleContext[] alternativeRules = MULTILINE_LITERAL_STRING_CONTENT;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case NUMERICAL_LITERAL: {
                    ParserRuleContext[] alternativeRules = NUMERICAL_LITERAL;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case VALUE: {
                    ParserRuleContext[] alternativeRules = VALUE;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case TOP_LEVEL_NODE: {
                    ParserRuleContext[] alternativeRules = TOP_LEVEL_NODE;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case ARRAY_VALUE_END: {
                    ParserRuleContext[] alternativeRules = ARRAY_VALUE_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case ARRAY_VALUE_START: {
                    ParserRuleContext[] alternativeRules = ARRAY_VALUE_START;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case ARRAY_VALUE_START_OR_VALUE_LIST_END: {
                    ParserRuleContext[] alternativeRules = ARRAY_VALUE_START_OR_VALUE_LIST_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case INLINE_TABLE_ENTRY_END: {
                    ParserRuleContext[] alternativeRules = INLINE_TABLE_ENTRY_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case INLINE_TABLE_START_OR_TABLE_ENTRY_LIST_END: {
                    ParserRuleContext[] alternativeRules = INLINE_TABLE_START_OR_TABLE_ENTRY_LIST_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case KEY_START: {
                    ParserRuleContext[] alternativeRules = KEY_START;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case KEY_END: {
                    ParserRuleContext[] alternativeRules = KEY_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case KEY_LIST_END: {
                    ParserRuleContext[] alternativeRules = KEY_LIST_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                default: {
                    skipRule = true;
                    hasMatch = true;
                }
            }
            if (!hasMatch) {
                return this.fixAndContinue(currentCtx, lookahead, currentDepth, matchingRulesCount, isEntryPoint);
            }
            currentCtx = this.getNextRule(currentCtx, lookahead + 1);
            if (skipRule) continue;
            ++currentDepth;
            ++matchingRulesCount;
            ++lookahead;
            isEntryPoint = false;
        }
        AbstractParserErrorHandler.Result result = new AbstractParserErrorHandler.Result(new ArrayDeque<AbstractParserErrorHandler.Solution>(), matchingRulesCount);
        result.solution = new AbstractParserErrorHandler.Solution(AbstractParserErrorHandler.Action.KEEP, currentCtx, SyntaxKind.NONE, currentCtx.toString());
        return result;
    }

    private void startContextIfRequired(ParserRuleContext currentCtx) {
        switch (currentCtx) {
            case TOML_TABLE_ARRAY: 
            case TOML_TABLE: 
            case KEY_VALUE_PAIR: 
            case ARRAY_VALUE_LIST: 
            case INLINE_TABLE_LIST: 
            case KEY_LIST: {
                this.startContext(currentCtx);
                break;
            }
        }
    }

    @Override
    protected ParserRuleContext getNextRule(ParserRuleContext currentCtx, int nextLookahead) {
        this.startContextIfRequired(currentCtx);
        ParserRuleContext parentCtx = this.getParentContext();
        switch (currentCtx) {
            case EOF: {
                return ParserRuleContext.EOF;
            }
            case ARRAY_TABLE_SECOND_END: 
            case TABLE_END: 
            case ARRAY_VALUE_LIST_END: 
            case INLINE_TABLE_END: {
                this.endContext();
                return ParserRuleContext.NEWLINE;
            }
            case ASSIGN_OP: {
                this.endContext();
                return ParserRuleContext.VALUE;
            }
            case NEWLINE: {
                return ParserRuleContext.TOP_LEVEL_NODE;
            }
            case INLINE_TABLE_ENTRY_START: {
                return ParserRuleContext.KEY_VALUE_PAIR;
            }
            case ARRAY_TABLE_SECOND_START: 
            case TABLE_START: 
            case KEY_VALUE_PAIR: {
                return ParserRuleContext.KEY_LIST;
            }
            case ARRAY_TABLE_FIRST_START: {
                return ParserRuleContext.ARRAY_TABLE_SECOND_START;
            }
            case ARRAY_TABLE_FIRST_END: {
                return ParserRuleContext.ARRAY_TABLE_SECOND_END;
            }
            case TOML_TABLE: {
                return ParserRuleContext.TABLE_START;
            }
            case TOML_TABLE_ARRAY: {
                return ParserRuleContext.ARRAY_TABLE_FIRST_START;
            }
            case COMMA: {
                return ParserRuleContext.VALUE;
            }
            case SIGN_TOKEN: {
                return ParserRuleContext.NUMERICAL_LITERAL;
            }
            case DOT: 
            case KEY_LIST: {
                return ParserRuleContext.KEY_START;
            }
            case ARRAY_VALUE_LIST_START: {
                return ParserRuleContext.ARRAY_VALUE_LIST;
            }
            case ARRAY_VALUE_LIST: {
                return ParserRuleContext.ARRAY_VALUE_START_OR_VALUE_LIST_END;
            }
            case INLINE_TABLE_START: {
                return ParserRuleContext.INLINE_TABLE_LIST;
            }
            case INLINE_TABLE_LIST: {
                return ParserRuleContext.INLINE_TABLE_START_OR_TABLE_ENTRY_LIST_END;
            }
            case STRING_START: {
                return ParserRuleContext.STRING_CONTENT;
            }
            case MULTILINE_STRING_START: {
                return ParserRuleContext.MULTILINE_STRING_CONTENT;
            }
            case LITERAL_STRING_START: {
                return ParserRuleContext.LITERAL_STRING_CONTENT;
            }
            case MULTILINE_LITERAL_STRING_START: {
                return ParserRuleContext.MULTILINE_LITERAL_STRING_CONTENT;
            }
            case STRING_BODY: {
                return ParserRuleContext.STRING_END;
            }
            case MULTILINE_STRING_BODY: {
                return ParserRuleContext.MULTILINE_STRING_END;
            }
            case LITERAL_STRING_BODY: {
                return ParserRuleContext.LITERAL_STRING_END;
            }
            case MULTILINE_LITERAL_STRING_BODY: {
                return ParserRuleContext.MULTILINE_LITERAL_STRING_END;
            }
            case STRING_END: 
            case MULTILINE_STRING_END: 
            case LITERAL_STRING_END: 
            case MULTILINE_LITERAL_STRING_END: 
            case DECIMAL_INTEGER_LITERAL: 
            case DECIMAL_FLOATING_POINT_LITERAL: 
            case HEX_INTEGER_LITERAL: 
            case OCTAL_INTEGER_LITERAL: 
            case BINARY_INTEGER_LITERAL: 
            case BOOLEAN_LITERAL: {
                if (parentCtx == ParserRuleContext.ARRAY_VALUE_LIST) {
                    return ParserRuleContext.ARRAY_VALUE_END;
                }
                if (parentCtx == ParserRuleContext.INLINE_TABLE_LIST) {
                    return ParserRuleContext.INLINE_TABLE_ENTRY_END;
                }
                if (parentCtx == ParserRuleContext.KEY_LIST) {
                    return ParserRuleContext.KEY_END;
                }
                return ParserRuleContext.NEWLINE;
            }
            case IDENTIFIER_LITERAL: {
                return ParserRuleContext.KEY_END;
            }
        }
        throw new IllegalStateException("Next rule is not handled " + String.valueOf((Object)currentCtx));
    }

    @Override
    protected SyntaxKind getExpectedTokenKind(ParserRuleContext ctx) {
        return switch (ctx) {
            case ParserRuleContext.TOML_TABLE -> SyntaxKind.TABLE;
            case ParserRuleContext.TOML_TABLE_ARRAY -> SyntaxKind.TABLE_ARRAY;
            case ParserRuleContext.KEY_VALUE_PAIR -> SyntaxKind.KEY_VALUE;
            case ParserRuleContext.ASSIGN_OP -> SyntaxKind.EQUAL_TOKEN;
            case ParserRuleContext.IDENTIFIER_LITERAL -> SyntaxKind.IDENTIFIER_LITERAL;
            case ParserRuleContext.EOF -> SyntaxKind.EOF_TOKEN;
            case ParserRuleContext.COMMA -> SyntaxKind.COMMA_TOKEN;
            case ParserRuleContext.STRING_START, ParserRuleContext.STRING_END -> SyntaxKind.DOUBLE_QUOTE_TOKEN;
            case ParserRuleContext.LITERAL_STRING_START, ParserRuleContext.LITERAL_STRING_END -> SyntaxKind.SINGLE_QUOTE_TOKEN;
            case ParserRuleContext.MULTILINE_STRING_START, ParserRuleContext.MULTILINE_STRING_END -> SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN;
            case ParserRuleContext.MULTILINE_LITERAL_STRING_START, ParserRuleContext.MULTILINE_LITERAL_STRING_END -> SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN;
            case ParserRuleContext.STRING_BODY, ParserRuleContext.LITERAL_STRING_BODY, ParserRuleContext.MULTILINE_STRING_BODY, ParserRuleContext.MULTILINE_LITERAL_STRING_BODY -> SyntaxKind.IDENTIFIER_LITERAL;
            case ParserRuleContext.INLINE_TABLE_START -> SyntaxKind.OPEN_BRACE_TOKEN;
            case ParserRuleContext.TABLE_START, ParserRuleContext.ARRAY_VALUE_LIST_START -> SyntaxKind.OPEN_BRACKET_TOKEN;
            case ParserRuleContext.TABLE_END, ParserRuleContext.ARRAY_VALUE_LIST_END -> SyntaxKind.CLOSE_BRACKET_TOKEN;
            case ParserRuleContext.INLINE_TABLE_END -> SyntaxKind.CLOSE_BRACE_TOKEN;
            case ParserRuleContext.DECIMAL_INTEGER_LITERAL -> SyntaxKind.DECIMAL_INT_TOKEN;
            case ParserRuleContext.HEX_INTEGER_LITERAL -> SyntaxKind.HEX_INTEGER_LITERAL_TOKEN;
            case ParserRuleContext.OCTAL_INTEGER_LITERAL -> SyntaxKind.OCTAL_INTEGER_LITERAL_TOKEN;
            case ParserRuleContext.BINARY_INTEGER_LITERAL -> SyntaxKind.BINARY_INTEGER_LITERAL_TOKEN;
            case ParserRuleContext.DECIMAL_FLOATING_POINT_LITERAL -> SyntaxKind.DECIMAL_FLOAT_TOKEN;
            case ParserRuleContext.BOOLEAN_LITERAL -> SyntaxKind.FALSE_KEYWORD;
            case ParserRuleContext.NEWLINE -> SyntaxKind.NEWLINE;
            case ParserRuleContext.DOT -> SyntaxKind.DOT_TOKEN;
            case ParserRuleContext.ARRAY_TABLE_FIRST_END, ParserRuleContext.ARRAY_TABLE_SECOND_END -> SyntaxKind.CLOSE_BRACKET_TOKEN;
            case ParserRuleContext.ARRAY_TABLE_FIRST_START, ParserRuleContext.ARRAY_TABLE_SECOND_START -> SyntaxKind.OPEN_BRACKET_TOKEN;
            case ParserRuleContext.SIGN_TOKEN -> SyntaxKind.PLUS_TOKEN;
            default -> SyntaxKind.NONE;
        };
    }
}

