/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TomlArrayValueNode
extends TomlValueNode {
    private final List<TomlValueNode> elements;

    public TomlArrayValueNode(ArrayNode arrayNode, List<TomlValueNode> elements, TomlNodeLocation location) {
        super(arrayNode, TomlType.ARRAY, location);
        this.elements = elements;
    }

    public <T extends TomlValueNode> T get(int index) {
        TomlValueNode tomlValue = this.elements.get(index);
        return (T)tomlValue;
    }

    public List<TomlValueNode> elements() {
        return this.elements;
    }

    @Override
    public TomlType kind() {
        return super.kind();
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Set<Diagnostic> diagnostics() {
        Set tomlDiagnostics = this.diagnostics;
        for (TomlValueNode child : this.elements) {
            tomlDiagnostics.addAll(child.diagnostics());
        }
        return tomlDiagnostics;
    }

    @Override
    public void clearDiagnostics() {
        this.diagnostics.clear();
        for (TomlValueNode child : this.elements) {
            child.clearDiagnostics();
        }
    }

    @Override
    public boolean isMissingNode() {
        ArrayNode arrayNode = (ArrayNode)this.externalTreeNode();
        if (arrayNode.isMissing()) {
            return true;
        }
        return arrayNode.openBracket().isMissing() || arrayNode.closeBracket().isMissing();
    }

    @Override
    public List<Object> toNativeValue() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (TomlValueNode element : this.elements) {
            list.add(element.toNativeValue());
        }
        return list;
    }
}

