/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator;

import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.BoolLiteralNode;
import io.ballerina.toml.syntax.tree.KeyNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Minutiae;
import io.ballerina.toml.syntax.tree.MinutiaeList;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NumericLiteralNode;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;

public final class SampleNodeGenerator {
    private static final String NEW_LINE = System.lineSeparator();

    private SampleNodeGenerator() {
    }

    public static KeyValueNode createStringKV(String key, String value, String description) {
        KeyNode keyNode = SampleNodeGenerator.getKeyNode(key);
        Token assign = SampleNodeGenerator.getAssignToken();
        Token startingDoubleQuote = NodeFactory.createToken(SyntaxKind.DOUBLE_QUOTE_TOKEN);
        MinutiaeList endingMinList = SampleNodeGenerator.getEndingMinList(description);
        Token endingDoubleQuote = NodeFactory.createToken(SyntaxKind.DOUBLE_QUOTE_TOKEN, NodeFactory.createEmptyMinutiaeList(), endingMinList);
        StringLiteralNode stringLiteralNode = NodeFactory.createStringLiteralNode(startingDoubleQuote, NodeFactory.createIdentifierToken(value), endingDoubleQuote);
        return NodeFactory.createKeyValueNode(keyNode, assign, stringLiteralNode);
    }

    public static KeyValueNode createNumericKV(String key, String value, String description) {
        KeyNode keyNode = SampleNodeGenerator.getKeyNode(key);
        Token assign = SampleNodeGenerator.getAssignToken();
        MinutiaeList endingMinList = SampleNodeGenerator.getEndingMinList(description);
        NumericLiteralNode numericLiteralNode = NodeFactory.createNumericLiteralNode(SyntaxKind.FLOAT, null, NodeFactory.createIdentifierToken(value, NodeFactory.createEmptyMinutiaeList(), endingMinList));
        return NodeFactory.createKeyValueNode(keyNode, assign, numericLiteralNode);
    }

    public static KeyValueNode createBooleanKV(String key, Boolean value, String description) {
        KeyNode keyNode = SampleNodeGenerator.getKeyNode(key);
        Token assign = SampleNodeGenerator.getAssignToken();
        MinutiaeList endingMinList = SampleNodeGenerator.getEndingMinList(description);
        SyntaxKind kind = value != false ? SyntaxKind.TRUE_KEYWORD : SyntaxKind.FALSE_KEYWORD;
        BoolLiteralNode boolLiteralNode = NodeFactory.createBoolLiteralNode(NodeFactory.createToken(kind, NodeFactory.createEmptyMinutiaeList(), endingMinList));
        return NodeFactory.createKeyValueNode(keyNode, assign, boolLiteralNode);
    }

    public static TableNode createTable(String key, String description) {
        KeyNode keyNode = SampleNodeGenerator.getKeyNode(key);
        return NodeFactory.createTableNode(NodeFactory.createToken(SyntaxKind.OPEN_BRACKET_TOKEN, SampleNodeGenerator.getLeadingTableMinList(description), NodeFactory.createEmptyMinutiaeList()), keyNode, NodeFactory.createToken(SyntaxKind.CLOSE_BRACKET_TOKEN, AbstractNodeFactory.createEmptyMinutiaeList(), SampleNodeGenerator.getEndingMinList(null)), NodeFactory.createEmptyNodeList());
    }

    public static TableArrayNode createTableArray(String key, String description) {
        KeyNode keyNode = SampleNodeGenerator.getKeyNode(key);
        return NodeFactory.createTableArrayNode(NodeFactory.createToken(SyntaxKind.OPEN_BRACKET_TOKEN, SampleNodeGenerator.getLeadingTableMinList(description), NodeFactory.createEmptyMinutiaeList()), NodeFactory.createToken(SyntaxKind.OPEN_BRACKET_TOKEN), keyNode, NodeFactory.createToken(SyntaxKind.CLOSE_BRACKET_TOKEN), NodeFactory.createToken(SyntaxKind.CLOSE_BRACKET_TOKEN, AbstractNodeFactory.createEmptyMinutiaeList(), SampleNodeGenerator.getEndingMinList(null)), NodeFactory.createEmptyNodeList());
    }

    private static MinutiaeList getLeadingTableMinList(String comment) {
        MinutiaeList minutiaeList = NodeFactory.createMinutiaeList(new Minutiae[0]);
        if (comment != null) {
            minutiaeList = minutiaeList.add(NodeFactory.createCommentMinutiae("# " + comment));
            minutiaeList = minutiaeList.add(NodeFactory.createWhitespaceMinutiae(NEW_LINE));
        }
        return minutiaeList;
    }

    private static MinutiaeList getEndingMinList(String comment) {
        Minutiae newLineMinutiae = NodeFactory.createWhitespaceMinutiae(NEW_LINE);
        MinutiaeList endingMinList = NodeFactory.createMinutiaeList(new Minutiae[0]);
        if (comment != null) {
            endingMinList = endingMinList.add(NodeFactory.createCommentMinutiae(" # " + comment));
        }
        endingMinList = endingMinList.add(newLineMinutiae);
        return endingMinList;
    }

    private static Token getAssignToken() {
        MinutiaeList whitespaceMinList = NodeFactory.createMinutiaeList(NodeFactory.createWhitespaceMinutiae(" "));
        return NodeFactory.createToken(SyntaxKind.EQUAL_TOKEN, whitespaceMinList, whitespaceMinList);
    }

    private static KeyNode getKeyNode(String key) {
        return NodeFactory.createKeyNode(NodeFactory.createSeparatedNodeList(NodeFactory.createIdentifierToken(key)));
    }
}

