/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Map;

public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static String getTypeErrorMessage(AbstractSchema schema, TomlType found, String key) {
        Map<String, String> message = schema.message();
        String typeCustomMessage = message.get("type");
        if (typeCustomMessage == null) {
            return String.format("incompatible type for key '%s': expected '%s', found '%s'", new Object[]{key, schema.type(), ValidationUtil.tomlTypeValueToSchemaType(found)});
        }
        return typeCustomMessage;
    }

    public static Type tomlTypeValueToSchemaType(TomlType tomlType) {
        return switch (tomlType) {
            case TomlType.STRING -> Type.STRING;
            case TomlType.DOUBLE, TomlType.INTEGER -> Type.NUMBER;
            case TomlType.BOOLEAN -> Type.BOOLEAN;
            case TomlType.ARRAY, TomlType.TABLE_ARRAY -> Type.ARRAY;
            case TomlType.TABLE, TomlType.INLINE_TABLE -> Type.OBJECT;
            default -> throw new IllegalArgumentException("Toml type is a invalid value");
        };
    }

    public static TomlDiagnostic getTomlDiagnostic(TomlNodeLocation location, String code, String template, DiagnosticSeverity severity, String message) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, template, severity);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }
}

