/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.ArraySchema;
import io.ballerina.toml.validator.schema.BooleanSchema;
import io.ballerina.toml.validator.schema.CompositionSchema;
import io.ballerina.toml.validator.schema.JsonSchemaException;
import io.ballerina.toml.validator.schema.NumericSchema;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.toml.validator.schema.StringSchema;
import io.ballerina.toml.validator.schema.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SchemaDeserializer
implements JsonDeserializer<AbstractSchema> {
    public static final String TYPE = "type";
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";
    public static final String INTEGER = "integer";
    public static final String NUMBER = "number";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String TITLE = "title";
    public static final String SCHEMA = "$schema";
    public static final String DESCRIPTION = "description";
    public static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    public static final String PROPERTIES = "properties";
    public static final String REQUIRED = "required";
    public static final String ITEMS = "items";
    public static final String PATTERN = "pattern";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";
    public static final String MESSAGE = "message";
    public static final String DEFAULT_VALUE = "default";
    public static final String ALL_OF = "allOf";
    public static final String ANY_OF = "anyOf";
    public static final String ONE_OF = "oneOf";
    public static final String NOT = "not";

    public AbstractSchema deserialize(JsonElement jsonElement, java.lang.reflect.Type refType, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        return this.getAbstractSchema(jsonDeserializationContext, jsonObj);
    }

    private Optional<CompositionSchema> getCompositeSchema(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObj) {
        JsonElement allOfObj = jsonObj.get(ALL_OF);
        if (allOfObj != null) {
            return Optional.of(this.getCompositeArray(jsonDeserializationContext, allOfObj, Type.ALL_OF));
        }
        JsonElement anyOfObj = jsonObj.get(ANY_OF);
        if (anyOfObj != null) {
            return Optional.of(this.getCompositeArray(jsonDeserializationContext, anyOfObj, Type.ANY_OF));
        }
        JsonElement oneOfObj = jsonObj.get(ONE_OF);
        if (oneOfObj != null) {
            return Optional.of(this.getCompositeArray(jsonDeserializationContext, oneOfObj, Type.ONE_OF));
        }
        JsonElement notObj = jsonObj.get(NOT);
        if (notObj != null) {
            return Optional.of(this.getCompositeObject(jsonDeserializationContext, notObj, Type.NOT));
        }
        return Optional.empty();
    }

    private CompositionSchema getCompositeArray(JsonDeserializationContext ctx, JsonElement object, Type type) {
        JsonArray allOfArr = object.getAsJsonArray();
        ArrayList<AbstractSchema> schemas = new ArrayList<AbstractSchema>();
        for (JsonElement element : allOfArr) {
            AbstractSchema schema = this.getAbstractSchema(ctx, element.getAsJsonObject());
            schemas.add(schema);
        }
        return new CompositionSchema(type, schemas);
    }

    private CompositionSchema getCompositeObject(JsonDeserializationContext ctx, JsonElement object, Type type) {
        return new CompositionSchema(type, Collections.singletonList(this.getAbstractSchema(ctx, object.getAsJsonObject())));
    }

    private AbstractSchema getAbstractSchema(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObj) {
        JsonElement type = jsonObj.get(TYPE);
        Optional<CompositionSchema> compositeSchema = this.getCompositeSchema(jsonDeserializationContext, jsonObj);
        if (type == null) {
            if (compositeSchema.isPresent()) {
                return compositeSchema.get();
            }
            throw new JsonSchemaException("invalid json schema found");
        }
        switch (type.getAsString()) {
            case "object": {
                return this.getObjectSchema(jsonDeserializationContext, jsonObj, compositeSchema.orElse(null));
            }
            case "array": {
                return this.getArraySchema(jsonDeserializationContext, jsonObj, compositeSchema.orElse(null));
            }
            case "integer": {
                return this.getNumericSchema(jsonObj, Type.INTEGER, compositeSchema.orElse(null));
            }
            case "number": {
                return this.getNumericSchema(jsonObj, Type.NUMBER, compositeSchema.orElse(null));
            }
            case "string": {
                return this.getStringSchema(jsonObj, compositeSchema.orElse(null));
            }
            case "boolean": {
                Map<String, String> customMessages = this.parseOptionalMapFromMessageJson(jsonObj);
                Boolean defaultValue = this.parseOptionalBooleanFromJson(jsonObj, DEFAULT_VALUE, null);
                JsonElement descriptionProperty = jsonObj.get(DESCRIPTION);
                String description = descriptionProperty != null ? descriptionProperty.getAsString() : null;
                return new BooleanSchema(Type.BOOLEAN, customMessages, defaultValue, (CompositionSchema)compositeSchema.orElse(null), description);
            }
        }
        throw new JsonSchemaException(type.getAsString() + " is not supported type in json schema");
    }

    private Schema getObjectSchema(JsonDeserializationContext context, JsonObject jsonObj, CompositionSchema comps) {
        JsonElement titleProp = jsonObj.get(TITLE);
        String title = titleProp != null ? titleProp.getAsString() : null;
        JsonElement schemaProp = jsonObj.get(SCHEMA);
        String schema = schemaProp != null ? schemaProp.getAsString() : null;
        JsonElement descriptionProperty = jsonObj.get(DESCRIPTION);
        String description = descriptionProperty != null ? descriptionProperty.getAsString() : null;
        boolean additionalProperties = this.parseOptionalBooleanFromJson(jsonObj, ADDITIONAL_PROPERTIES, false);
        JsonObject properties = jsonObj.get(PROPERTIES).getAsJsonObject();
        Set entries = properties.entrySet();
        LinkedHashMap<String, AbstractSchema> propertiesList = new LinkedHashMap<String, AbstractSchema>();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            AbstractSchema abstractSchema = (AbstractSchema)context.deserialize((JsonElement)entry.getValue(), AbstractSchema.class);
            propertiesList.put(key, abstractSchema);
        }
        List<String> requiredList = this.parseOptionalListFromJson(jsonObj, REQUIRED);
        Map<String, String> customMessages = this.parseOptionalMapFromMessageJson(jsonObj);
        return new Schema(schema, title, Type.OBJECT, customMessages, description, additionalProperties, propertiesList, requiredList, comps);
    }

    private AbstractSchema getArraySchema(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObj, CompositionSchema comps) {
        JsonObject items = jsonObj.get(ITEMS).getAsJsonObject();
        AbstractSchema abstractSchema = (AbstractSchema)jsonDeserializationContext.deserialize((JsonElement)items, AbstractSchema.class);
        Map<String, String> customMessages = this.parseOptionalMapFromMessageJson(jsonObj);
        JsonElement descriptionProperty = jsonObj.get(DESCRIPTION);
        String desc = descriptionProperty != null ? descriptionProperty.getAsString() : null;
        return new ArraySchema(Type.ARRAY, customMessages, abstractSchema, comps, desc);
    }

    private StringSchema getStringSchema(JsonObject jsonObj, CompositionSchema comps) {
        String pattern = this.parseOptionalStringFromJson(jsonObj, PATTERN);
        String defaultValue = this.parseOptionalStringFromJson(jsonObj, DEFAULT_VALUE);
        Integer minLength = this.parseOptionalIntFromJson(jsonObj, MIN_LENGTH);
        Integer maxLength = this.parseOptionalIntFromJson(jsonObj, MAX_LENGTH);
        Map<String, String> customMessages = this.parseOptionalMapFromMessageJson(jsonObj);
        JsonElement descriptionProperty = jsonObj.get(DESCRIPTION);
        String desc = descriptionProperty != null ? descriptionProperty.getAsString() : null;
        return new StringSchema(Type.STRING, customMessages, pattern, defaultValue, minLength, maxLength, comps, desc);
    }

    private NumericSchema getNumericSchema(JsonObject jsonObj, Type type, CompositionSchema comps) {
        Double minimum = this.parseOptionalDoubleFromJson(jsonObj, MINIMUM);
        Double maximum = this.parseOptionalDoubleFromJson(jsonObj, MAXIMUM);
        Double defaultValue = this.parseOptionalDoubleFromJson(jsonObj, DEFAULT_VALUE);
        Map<String, String> customMessages = this.parseOptionalMapFromMessageJson(jsonObj);
        JsonElement descriptionProperty = jsonObj.get(DESCRIPTION);
        String desc = descriptionProperty != null ? descriptionProperty.getAsString() : null;
        return new NumericSchema(type, customMessages, minimum, maximum, defaultValue, comps, desc);
    }

    private Double parseOptionalDoubleFromJson(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return jsonElement.getAsDouble();
        }
        throw new JsonSchemaException(key + " should always be a number");
    }

    private Boolean parseOptionalBooleanFromJson(JsonObject jsonObject, String key, Boolean defaultVal) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return defaultVal;
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isBoolean()) {
            return jsonElement.getAsBoolean();
        }
        throw new JsonSchemaException(key + " should always be a boolean");
    }

    private List<String> parseOptionalListFromJson(JsonObject jsonObject, String key) {
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        if (jsonArray == null || jsonArray.isJsonNull()) {
            return new ArrayList<String>();
        }
        if (!jsonArray.isJsonArray()) {
            throw new JsonSchemaException(key + " should always be an array");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement jsonElement : jsonArray) {
            if (!jsonElement.isJsonPrimitive() || !jsonElement.getAsJsonPrimitive().isString()) continue;
            list.add(jsonElement.getAsString());
        }
        return list;
    }

    private String parseOptionalStringFromJson(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            return jsonElement.getAsString();
        }
        throw new JsonSchemaException(key + " should always be a string");
    }

    private Integer parseOptionalIntFromJson(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isNumber()) {
            return jsonElement.getAsInt();
        }
        throw new JsonSchemaException(key + " should always be a int");
    }

    private Map<String, String> parseOptionalMapFromMessageJson(JsonObject jsonObject) {
        LinkedHashMap<String, String> customMessages = new LinkedHashMap<String, String>();
        JsonObject customMessageJson = jsonObject.getAsJsonObject(MESSAGE);
        if (customMessageJson == null) {
            return new LinkedHashMap<String, String>();
        }
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, TYPE);
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, PATTERN);
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, REQUIRED);
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, ADDITIONAL_PROPERTIES);
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, MINIMUM);
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, MAXIMUM);
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, MAX_LENGTH);
        this.addFieldToCustomMessagesMap(customMessages, customMessageJson, MIN_LENGTH);
        return customMessages;
    }

    private void addFieldToCustomMessagesMap(Map<String, String> customMessages, JsonObject customMessageJson, String field) {
        JsonElement type = customMessageJson.get(field);
        if (type != null && !type.isJsonNull()) {
            String customTypeMessage = type.getAsString();
            customMessages.put(field, customTypeMessage);
        }
    }
}

