/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import java.util.concurrent.CompletableFuture;

public class ModuleUtils {
    private static Module websubModule;

    private ModuleUtils() {
    }

    public static void setModule(Environment environment) {
        websubModule = environment.getCurrentModule();
    }

    public static Module getModule() {
        return websubModule;
    }

    public static void notifySuccess(CompletableFuture<Object> future, Object result) {
        BError error;
        if (result instanceof BError && !ModuleUtils.isModuleDefinedError(error = (BError)((Object)result))) {
            error.printStackTrace();
        }
        future.complete(result);
    }

    public static Object notifyFailure(BError bError, Module module) {
        bError.printStackTrace();
        BString errorMessage = StringUtils.fromString((String)("service method invocation failed: " + String.valueOf(bError.getErrorMessage())));
        return ErrorCreator.createError((Module)module, (String)"ServiceExecutionError", (BString)errorMessage, (BError)bError, null);
    }

    private static boolean isModuleDefinedError(BError error) {
        Type errorType = error.getType();
        Module packageDetails = errorType.getPackage();
        String orgName = packageDetails.getOrg();
        String packageName = packageDetails.getName();
        return "ballerina".equals(orgName) && "websub".equals(packageName);
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (BError error) {
            throw error;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }
}

