/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ftp.util;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.ftp.exception.BallerinaFtpException;
import io.ballerina.stdlib.ftp.transport.server.util.FileTransportUtils;
import io.ballerina.stdlib.ftp.util.ModuleUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static final Logger log = LoggerFactory.getLogger(FtpUtil.class);
    private static final int MAX_PORT = 65535;

    private FtpUtil() {
    }

    public static String createUrl(BObject clientConnector, String filePath) throws BallerinaFtpException {
        String username = (String)clientConnector.getNativeData("username");
        String password = (String)clientConnector.getNativeData("password");
        String host = (String)clientConnector.getNativeData("host");
        int port = (Integer)clientConnector.getNativeData("port");
        String protocol = (String)clientConnector.getNativeData("protocol");
        return FtpUtil.createUrl(protocol, host, port, username, password, filePath);
    }

    public static String createUrl(BMap config) throws BallerinaFtpException {
        BMap credentials;
        String filePath = config.getStringValue(StringUtils.fromString((String)"path")).getValue();
        String protocol = config.getStringValue(StringUtils.fromString((String)"protocol")).getValue();
        String host = config.getStringValue(StringUtils.fromString((String)"host")).getValue();
        int port = FtpUtil.extractPortValue(config.getIntValue(StringUtils.fromString((String)"port")));
        BMap auth = config.getMapValue(StringUtils.fromString((String)"auth"));
        String username = null;
        String password = null;
        if (auth != null && (credentials = auth.getMapValue(StringUtils.fromString((String)"credentials"))) != null) {
            username = credentials.getStringValue(StringUtils.fromString((String)"username")).getValue();
            if (username.isBlank()) {
                throw new BallerinaFtpException("Username cannot be empty");
            }
            password = credentials.getStringValue(StringUtils.fromString((String)"password")).getValue();
        }
        return FtpUtil.createUrl(protocol, host, port, username, password, filePath);
    }

    private static String createUrl(String protocol, String host, int port, String username, String password, String filePath) throws BallerinaFtpException {
        String userInfo = username + ":" + password;
        String normalizedPath = FtpUtil.normalizeFtpPath(filePath);
        try {
            URI uri = new URI(protocol, userInfo, host, port, normalizedPath, null, null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new BallerinaFtpException("Error occurred while constructing a URI from host: " + host + ", port: " + port + ", username: " + username + " and basePath: " + filePath + e.getMessage(), e);
        }
    }

    private static String normalizeFtpPath(String rawPath) {
        if (rawPath == null || rawPath.isEmpty()) {
            return "/";
        }
        if (rawPath.startsWith("/")) {
            return rawPath;
        }
        return "/" + rawPath;
    }

    public static Map<String, String> getAuthMap(BMap config) {
        BMap credentials;
        BMap auth = config.getMapValue(StringUtils.fromString((String)"auth"));
        String username = "anonymous";
        String password = "";
        if (auth != null && (credentials = auth.getMapValue(StringUtils.fromString((String)"credentials"))) != null) {
            username = credentials.getStringValue(StringUtils.fromString((String)"username")).getValue();
            password = credentials.getStringValue(StringUtils.fromString((String)"password")).getValue();
        }
        HashMap<String, String> authMap = new HashMap<String, String>();
        authMap.put("username", username);
        authMap.put("password", password);
        return authMap;
    }

    public static BError createError(String message, String errorTypeName) {
        String safeMessage = FileTransportUtils.maskUrlPassword(message);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorTypeName, (BString)StringUtils.fromString((String)safeMessage), null, null);
    }

    public static BError createError(String message, Throwable cause, String errorTypeName) {
        String safeMessage = FileTransportUtils.maskUrlPassword(message);
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorTypeName, (BString)StringUtils.fromString((String)safeMessage), cause == null ? null : (cause instanceof BError ? (BError)cause : ErrorCreator.createError((BString)StringUtils.fromString((String)FileTransportUtils.maskUrlPassword(cause.getMessage())))), null);
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable rootCause;
        Objects.requireNonNull(throwable);
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    public static int extractPortValue(long longValue) {
        if (longValue <= 0L || longValue > 65535L) {
            log.error("Invalid port number given in configuration");
            return -1;
        }
        try {
            return Math.toIntExact(longValue);
        }
        catch (ArithmeticException e) {
            log.warn("The value set for port needs to be less than {}. The port value is set to {}", (Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
    }

    public static Type getFileInfoType() {
        BMap fileInfoStruct = ValueCreator.createRecordValue((Module)new Module("ballerina", "ftp", FtpUtil.getFtpPackage().getMajorVersion()), (String)"FileInfo");
        return fileInfoStruct.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayInputStream compress(InputStream inputStream, String targetFilePath) {
        String fileName = new File(targetFilePath).getName();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        try {
            int length;
            zipOutputStream.putNextEntry(new ZipEntry(fileName));
            byte[] buffer = new byte[1000];
            while ((length = inputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            log.error("The file does not exist");
        }
        finally {
            try {
                inputStream.close();
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            catch (IOException e) {
                log.error("Error in closing the stream");
            }
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static String getCompressedFileName(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46)).concat(".zip");
    }

    public static Optional<MethodType> getOnFileChangeMethod(BObject service) {
        MethodType[] methodTypes = ((ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service))).getMethods();
        return Stream.of(methodTypes).filter(methodType -> "onFileChange".equals(methodType.getName())).findFirst();
    }

    public static String getAuthMethod(Object authMethodObj) {
        return authMethodObj.toString().toLowerCase().replace("_", "-");
    }

    public static String getPreferredMethodsFromAuthConfig(BMap authenticationConfig) {
        BArray preferredMethods = authenticationConfig.getArrayValue(StringUtils.fromString((String)"preferredMethods"));
        String preferredAuthMethods = "";
        if (preferredMethods != null) {
            if (preferredMethods.isEmpty()) {
                throw FtpUtil.createError("No preferred auth method is specified in the SFTP client configurations", ErrorType.Error.errorType());
            }
            preferredAuthMethods = Arrays.stream(preferredMethods.getValues()).limit(preferredMethods.size()).map(FtpUtil::getAuthMethod).collect(Collectors.joining(","));
        }
        return preferredAuthMethods;
    }

    public static Module getFtpPackage() {
        return ModuleUtils.getModule();
    }

    public static enum ErrorType {
        Error("Error");

        private String errorType;

        private ErrorType(String errorType) {
            this.errorType = errorType;
        }

        public String errorType() {
            return this.errorType;
        }
    }
}

