/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.SubTransactionCoordinatorParticipant;
import com.atomikos.icatch.imp.TxRollbackOnlyStateHandler;
import com.atomikos.icatch.imp.TxTerminatedStateHandler;
import com.atomikos.icatch.imp.TxTerminatingStateHandler;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;

abstract class TransactionStateHandler
implements SubTxAwareParticipant {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionStateHandler.class);
    private int subtxs_;
    private Stack<Synchronization> synchronizations_;
    private List<SubTxAwareParticipant> subtxawares_;
    private CompositeTransactionImp ct_;

    protected TransactionStateHandler(CompositeTransactionImp ct) {
        this.ct_ = ct;
        this.subtxs_ = 0;
        this.subtxawares_ = new ArrayList<SubTxAwareParticipant>();
        this.synchronizations_ = new Stack();
    }

    protected TransactionStateHandler(CompositeTransactionImp ct, TransactionStateHandler handler) {
        this.subtxs_ = handler.getSubTransactionCount();
        this.synchronizations_ = handler.getSynchronizations();
        this.subtxawares_ = handler.getSubtxawares();
        this.ct_ = ct;
    }

    private synchronized void localDecSubTxCount() {
        --this.subtxs_;
    }

    private synchronized void localIncSubTxCount() {
        ++this.subtxs_;
    }

    private synchronized int localGetSubTxCount() {
        return this.subtxs_;
    }

    private synchronized void localPushSynchronization(Synchronization sync) {
        this.synchronizations_.push(sync);
    }

    private Synchronization localPopSynchronization() {
        Synchronization ret = null;
        if (!this.synchronizations_.isEmpty()) {
            ret = this.synchronizations_.pop();
        }
        return ret;
    }

    private synchronized void localAddSubTxAwareParticipant(SubTxAwareParticipant p) {
        if (!this.subtxawares_.contains(p)) {
            this.subtxawares_.add(p);
        }
    }

    protected CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        CompositeTransaction ct = null;
        ct = this.ct_.getTransactionService().createSubTransaction(this.ct_);
        ct.addSubTxAwareParticipant(this);
        this.localIncSubTxCount();
        return ct;
    }

    protected RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        CoordinatorImp coord = this.ct_.getCoordinatorImp();
        try {
            coord.addParticipant(participant);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("addParticipant ( " + participant + " ) for transaction " + this.getCT().getTid());
            }
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Transaction already rolled back");
        }
        return coord;
    }

    protected void registerSynchronization(Synchronization sync) throws IllegalStateException, UnsupportedOperationException, SysException {
        if (sync != null) {
            try {
                this.ct_.getCoordinatorImp().registerSynchronization(sync);
            }
            catch (RollbackException e) {
                throw new IllegalStateException("Transaction already rolled back");
            }
            this.localPushSynchronization(sync);
        }
    }

    protected void addSubTxAwareParticipant(SubTxAwareParticipant subtxaware) throws SysException, IllegalStateException {
        this.localAddSubTxAwareParticipant(subtxaware);
    }

    private void rollback() throws IllegalStateException, SysException {
        for (int i = 0; i < this.subtxawares_.size(); ++i) {
            SubTxAwareParticipant subtxaware = this.subtxawares_.get(i);
            subtxaware.rolledback(this.ct_);
        }
        Extent extent = this.ct_.getExtent();
        if (extent != null) {
            Enumeration enumm = extent.getParticipants().elements();
            while (enumm.hasMoreElements()) {
                Participant part = (Participant)enumm.nextElement();
                this.addParticipant(part);
            }
        }
        this.ct_.localSetTransactionStateHandler(new TxTerminatedStateHandler(this.ct_, this, false));
        try {
            this.ct_.getCoordinatorImp().rollback();
        }
        catch (HeurCommitException e) {
            throw new SysException("Unexpected error in rollback", e);
        }
        catch (HeurMixedException e) {
            throw new SysException("Unexpected error in rollback", e);
        }
        catch (HeurHazardException e) {
            throw new SysException("Unexpected error in rollback", e);
        }
    }

    protected void rollbackWithStateCheck() throws IllegalStateException, SysException {
        this.ct_.localTestAndSetTransactionStateHandler(this, new TxTerminatingStateHandler(false, this.ct_, this));
        this.rollback();
    }

    protected void commit() throws SysException, IllegalStateException, RollbackException {
        this.ct_.localTestAndSetTransactionStateHandler(this, new TxTerminatingStateHandler(true, this.ct_, this));
        if (this.ct_.isLocalRoot()) {
            Enumeration enumm = this.ct_.getExtent().getParticipants().elements();
            while (enumm.hasMoreElements()) {
                Participant part = (Participant)enumm.nextElement();
                this.addParticipant(part);
            }
        }
        if (this.subtxs_ > 0) {
            throw new IllegalStateException("Active subtransactions exist");
        }
        Throwable cause = this.notifyBeforeCompletion();
        if (this.ct_.getState().equals((Object)TxState.MARKED_ABORT)) {
            this.rollback();
            throw new RollbackException("The transaction was set to rollback only", cause);
        }
        for (int i = 0; i < this.subtxawares_.size(); ++i) {
            SubTxAwareParticipant subtxaware = this.subtxawares_.get(i);
            subtxaware.committed(this.ct_);
        }
        this.ct_.localSetTransactionStateHandler(new TxTerminatedStateHandler(this.ct_, this, true));
    }

    private Throwable notifyBeforeCompletion() {
        RuntimeException cause = null;
        Synchronization sync = this.localPopSynchronization();
        while (sync != null) {
            try {
                sync.beforeCompletion();
            }
            catch (RuntimeException error2) {
                this.setRollbackOnly();
                if (cause == null) {
                    cause = error2;
                }
                LOGGER.logError("Unexpected error in beforeCompletion: ", error2);
            }
            sync = this.localPopSynchronization();
        }
        return cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRollbackOnly() {
        this.ct_.getCoordinatorImp().setRollbackOnly();
        TransactionStateHandler transactionStateHandler = this;
        synchronized (transactionStateHandler) {
            this.ct_.localSetTransactionStateHandler(new TxRollbackOnlyStateHandler(this.ct_, this));
        }
    }

    @Override
    public void committed(CompositeTransaction subtx) {
        CompositeTransactionImp ct = (CompositeTransactionImp)subtx;
        Extent toAdd = subtx.getExtent();
        Extent target = this.ct_.getExtent();
        target.add(toAdd);
        CoordinatorImp subTxCoordinator = ct.getCoordinatorImp();
        if (!subTxCoordinator.getParticipants().isEmpty()) {
            SubTransactionCoordinatorParticipant part = new SubTransactionCoordinatorParticipant(subTxCoordinator);
            this.addParticipant(part);
        }
        this.localDecSubTxCount();
    }

    @Override
    public void rolledback(CompositeTransaction subtx) {
        this.localDecSubTxCount();
    }

    protected abstract TxState getState();

    protected List<SubTxAwareParticipant> getSubtxawares() {
        return this.subtxawares_;
    }

    protected CompositeTransactionImp getCT() {
        return this.ct_;
    }

    protected int getSubTransactionCount() {
        return this.localGetSubTxCount();
    }

    protected Stack<Synchronization> getSynchronizations() {
        return this.synchronizations_;
    }

    protected void addSynchronizations(Stack<Synchronization> synchronizations) {
        while (!synchronizations.isEmpty()) {
            Synchronization next2 = synchronizations.pop();
            this.localPushSynchronization(next2);
        }
    }
}

