/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.creators;

import com.github.benmanes.caffeine.cache.Interner;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeIdentifier;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.XmlType;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BJsonType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BStreamType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.BXmlType;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class TypeCreator {
    private static final RecordTypeCache registeredRecordTypes = new RecordTypeCache();
    private static final ConstraintTypeCache<List<Type>, TupleType> TUPLE_TYPE_CACHE = new ConstraintTypeCache<List, TupleType>(BTupleType::new);
    private static final ConstraintTypeCache<Type, ArrayType> ARRAY_TYPE_CACHE = new ConstraintTypeCache<Type, ArrayType>(BArrayType::new);
    private static final ConstraintTypeCache<Type, MapType> MAP_TYPE_CACHE = new ConstraintTypeCache<Type, MapType>(BMapType::new);
    private static final ConstraintTypeCache<List<Type>, UnionType> UNION_TYPE_CACHE = new ConstraintTypeCache<List, UnionType>(BUnionType::new);
    private static final LoadingCache<String, FiniteType> FINITE_TYPE_CACHE = CacheFactory.createCache(BFiniteType::new);

    public static ArrayType createArrayType(Type elementType) {
        return ARRAY_TYPE_CACHE.get(elementType);
    }

    public static ArrayType createArrayType(Type elementType, boolean readonly) {
        return new BArrayType(elementType, readonly);
    }

    public static ArrayType createArrayType(Type elementType, int size) {
        return new BArrayType(elementType, size, false);
    }

    public static ArrayType createArrayType(Type elementType, int size, boolean readonly) {
        return new BArrayType(elementType, size, readonly);
    }

    public static TupleType createTupleType(List<Type> typeList) {
        if (typeList.size() > 20) {
            return new BTupleType(typeList);
        }
        return TUPLE_TYPE_CACHE.get(typeList);
    }

    public static TupleType createTupleType(List<Type> typeList, int typeFlags) {
        return new BTupleType(typeList, typeFlags);
    }

    public static TupleType createTupleType(List<Type> typeList, Type restType, int typeFlags, boolean readonly) {
        return new BTupleType(typeList, restType, typeFlags, readonly);
    }

    public static TupleType createTupleType(List<Type> typeList, Type restType, int typeFlags, boolean isCyclic, boolean readonly) {
        return new BTupleType(typeList, restType, typeFlags, isCyclic, readonly);
    }

    public static TupleType createTupleType(String name, Module pkg, int typeFlags, boolean isCyclic, boolean readonly) {
        return new BTupleType(name, pkg, typeFlags, isCyclic, readonly);
    }

    public static MapType createMapType(Type constraint) {
        return MAP_TYPE_CACHE.get(constraint);
    }

    public static MapType createMapType(Type constraint, boolean readonly) {
        return new BMapType(constraint, readonly);
    }

    public static MapType createMapType(String typeName, Type constraint, Module module) {
        return new BMapType(typeName, constraint, module);
    }

    public static MapType createMapType(String typeName, Type constraint, Module module, boolean readonly) {
        return new BMapType(typeName, constraint, module, readonly);
    }

    public static RecordType createRecordType(String typeName, Module module, long flags, boolean sealed, int typeFlags) {
        BRecordType memo = TypeCreator.registeredRecordType(typeName, module);
        if (memo != null) {
            return memo;
        }
        return new BRecordType(typeName, typeName, module, flags, sealed, typeFlags);
    }

    public static RecordType createRecordType(String typeName, Module module, long flags, Map<String, Field> fields, Type restFieldType, boolean sealed, int typeFlags) {
        BRecordType memo = TypeCreator.registeredRecordType(typeName, module);
        if (memo != null) {
            return memo;
        }
        return new BRecordType(typeName, module, flags, fields, restFieldType, sealed, typeFlags);
    }

    public static ObjectType createObjectType(String typeName, Module module, long flags) {
        return new BObjectType(typeName, module, flags);
    }

    public static StreamType createStreamType(Type constraint, Type completionType) {
        return new BStreamType(constraint, completionType);
    }

    public static StreamType createStreamType(String typeName, Type constraint, Type completionType, Module modulePath) {
        return new BStreamType(typeName, constraint, completionType, modulePath);
    }

    @Deprecated
    public static StreamType createStreamType(Type constraint) {
        return new BStreamType(constraint);
    }

    @Deprecated
    public static StreamType createStreamType(String typeName, Type completionType, Module modulePath) {
        return new BStreamType(typeName, completionType, modulePath);
    }

    public static UnionType createUnionType(Type ... memberTypes) {
        return TypeCreator.createUnionType(Arrays.asList(memberTypes));
    }

    public static UnionType createUnionType(List<Type> memberTypes) {
        if (memberTypes.size() > 20) {
            return new BUnionType(memberTypes);
        }
        return UNION_TYPE_CACHE.get(memberTypes);
    }

    public static UnionType createUnionType(List<Type> memberTypes, int typeFlags) {
        return new BUnionType(memberTypes, typeFlags, false, false);
    }

    public static UnionType createUnionType(List<Type> memberTypes, boolean readonly) {
        return new BUnionType(memberTypes, readonly);
    }

    public static UnionType createUnionType(List<Type> memberTypes, int typeFlags, boolean readonly) {
        return new BUnionType(memberTypes, typeFlags, readonly, false);
    }

    public static UnionType createUnionType(List<Type> memberTypes, String name, Module pkg, int typeFlags, boolean isCyclic, long flags) {
        return new BUnionType(memberTypes, name, pkg, typeFlags, isCyclic, flags);
    }

    public static ErrorType createErrorType(String typeName, Module module) {
        return new BErrorType(typeName, module);
    }

    public static ErrorType createErrorType(String typeName, Module module, Type detailType) {
        return new BErrorType(typeName, module, detailType);
    }

    public static Field createField(Type fieldType, String fieldName, long flags) {
        return new BField(fieldType, fieldName, flags);
    }

    public static TableType createTableType(Type constraint, String[] fieldNames, boolean readonly) {
        return new BTableType(constraint, fieldNames, readonly);
    }

    public static TableType createTableType(Type constraint, Type keyType, boolean readonly) {
        return new BTableType(constraint, keyType, readonly);
    }

    public static TableType createTableType(Type constraint, boolean readonly) {
        return new BTableType(constraint, readonly);
    }

    public static XmlType createXMLType(String typeName, Type constraint, Module module) {
        return new BXmlType(typeName, constraint, module);
    }

    public static XmlType createXMLType(String typeName, Module module, int tag, boolean readonly) {
        return new BXmlType(typeName, module, tag, readonly);
    }

    public static XmlType createXMLType(Type constraint, boolean readonly) {
        return new BXmlType(constraint, readonly);
    }

    public static JsonType createJSONType(String typeName, Module module, boolean readonly) {
        return new BJsonType(typeName, module, readonly);
    }

    public static FiniteType createFiniteType(String typeName) {
        return FINITE_TYPE_CACHE.get(typeName);
    }

    public static FiniteType createFiniteType(String typeName, Set<Object> values, int typeFlags) {
        return new BFiniteType(typeName, values, typeFlags);
    }

    private TypeCreator() {
    }

    private static BRecordType registeredRecordType(String typeName, Module pkg) {
        if (typeName == null || pkg == null) {
            return null;
        }
        return registeredRecordTypes.get(new TypeIdentifier(pkg, typeName));
    }

    public static void registerRecordType(BRecordType recordType) {
        String name = recordType.getName();
        Module pkg = recordType.getPackage();
        if (name == null || pkg == null) {
            return;
        }
        TypeIdentifier typeIdentifier = new TypeIdentifier(pkg, name);
        if (typeIdentifier.avoidCaching()) {
            return;
        }
        registeredRecordTypes.put(typeIdentifier, recordType);
    }

    public static void resetAllCaches() {
        RecordTypeCache.cache.clear();
    }

    public static class ConstraintTypeCache<C, T> {
        private final Interner<C> constraintInterner = CacheFactory.createInterner();
        private final Map<C, T> cache = new IdentityHashMap<C, T>();
        private final Function<C, T> createFn;

        protected ConstraintTypeCache(Function<C, T> createFn) {
            this.createFn = createFn;
        }

        T get(C constraint) {
            C canonical = this.constraintInterner.intern(constraint);
            T cached = this.cache.get(canonical);
            if (cached != null) {
                return cached;
            }
            cached = this.createFn.apply(constraint);
            this.cache.put(constraint, cached);
            return cached;
        }
    }

    private static final class RecordTypeCache {
        private static final Map<TypeIdentifier, BRecordType> cache = CacheFactory.createCachingHashMap();

        private RecordTypeCache() {
        }

        BRecordType get(TypeIdentifier key) {
            return cache.get(key);
        }

        void put(TypeIdentifier identifier, BRecordType value2) {
            cache.put(identifier, value2);
        }
    }
}

