/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.creators;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BStreamingJson;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.internal.json.JsonDataSource;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.DecimalValueKind;
import io.ballerina.runtime.internal.values.FPValue;
import io.ballerina.runtime.internal.values.HandleValue;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.StreamValue;
import io.ballerina.runtime.internal.values.StreamingJsonValue;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.values.XmlQName;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.xml.XmlFactory;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.namespace.QName;

public final class ValueCreator {
    public static BArray createArrayValue(ArrayType type) {
        return new ArrayValueImpl(type);
    }

    public static BArray createArrayValue(long[] values) {
        return new ArrayValueImpl(values, false);
    }

    public static BArray createReadonlyArrayValue(long[] values) {
        return new ArrayValueImpl(values, true);
    }

    public static BArray createArrayValue(boolean[] values) {
        return new ArrayValueImpl(values, false);
    }

    public static BArray createReadonlyArrayValue(boolean[] values) {
        return new ArrayValueImpl(values, true);
    }

    public static BArray createArrayValue(byte[] values) {
        return new ArrayValueImpl(values, false);
    }

    public static BArray createReadonlyArrayValue(byte[] values) {
        return new ArrayValueImpl(values, true);
    }

    public static BArray createArrayValue(double[] values) {
        return new ArrayValueImpl(values, false);
    }

    public static BArray createReadonlyArrayValue(double[] values) {
        return new ArrayValueImpl(values, true);
    }

    public static BArray createArrayValue(BString[] values) {
        return new ArrayValueImpl(values, false);
    }

    public static BArray createReadonlyArrayValue(BString[] values) {
        return new ArrayValueImpl(values, true);
    }

    public static BArray createArrayValue(Object[] values, ArrayType type) {
        return new ArrayValueImpl(values, type);
    }

    @Deprecated
    public static BArray createArrayValue(ArrayType type, int length) {
        return new ArrayValueImpl(type, (long)length);
    }

    @Deprecated
    public static BArray createArrayValue(ArrayType type, long size, BListInitialValueEntry[] initialValues) {
        return new ArrayValueImpl(type, size, initialValues);
    }

    public static BArray createArrayValue(ArrayType type, BListInitialValueEntry[] initialValues) {
        return new ArrayValueImpl((Type)type, initialValues);
    }

    public static BArray createTupleValue(TupleType type) {
        return new TupleValueImpl(type);
    }

    @Deprecated
    public static BArray createTupleValue(TupleType type, long size, BListInitialValueEntry[] initialValues) {
        return new TupleValueImpl(type, size, initialValues);
    }

    public static BArray createTupleValue(TupleType type, BListInitialValueEntry[] initialValues) {
        return new TupleValueImpl(type, initialValues);
    }

    public static BDecimal createDecimalValue(BigDecimal value2) {
        return new DecimalValue(value2);
    }

    public static BDecimal createDecimalValue(String value2) {
        return new DecimalValue(value2);
    }

    @Deprecated(since="2201.6.0", forRemoval=true)
    public static BDecimal createDecimalValue(String value2, DecimalValueKind valueKind) {
        return new DecimalValue(value2, valueKind);
    }

    public static BFunctionPointer createFPValue(Function function2, FunctionType type) {
        return new FPValue(function2, type, null, false);
    }

    public static BFunctionPointer createFPValue(Function function2, FunctionType type, String strandName) {
        return new FPValue(function2, type, strandName, false);
    }

    @Deprecated(since="2201.6.0", forRemoval=true)
    public static BStreamingJson createStreamingJsonValue(JsonDataSource datasource) {
        return new StreamingJsonValue(datasource);
    }

    public static BStream createStreamValue(StreamType type) {
        return new StreamValue(type);
    }

    public static BStream createStreamValue(StreamType type, BObject iteratorObj) {
        return new StreamValue(type, iteratorObj);
    }

    public static BTypedesc createTypedescValue(Type describingType) {
        return new TypedescValueImpl(describingType);
    }

    public static BXmlItem createXmlItem() {
        return new XmlItem(new QName(null), new XmlSequence());
    }

    public static BXmlItem createXmlItem(QName name, BXmlSequence children) {
        return new XmlItem(name, (XmlSequence)children);
    }

    public static BXmlItem createXmlItem(QName name) {
        return new XmlItem(name);
    }

    public static BXmlItem createXmlItem(QName name, boolean readonly) {
        return new XmlItem(name, readonly);
    }

    public static BXmlItem createXmlItem(QName name, BXmlSequence children, boolean readonly) {
        return new XmlItem(name, (XmlSequence)children, readonly);
    }

    public static BXml createXmlValue(String xmlValue) {
        return XmlFactory.parse(xmlValue);
    }

    public static BXml createXmlValue(InputStream inputStream) {
        return XmlFactory.parse(inputStream);
    }

    @Deprecated
    public static BXml createXmlValue(BXmlQName startTagName, BXmlQName endTagName, String defaultNsUri) {
        return XmlFactory.createXMLElement(startTagName, endTagName, defaultNsUri);
    }

    @Deprecated
    public static BXml createXmlValue(BXmlQName startTagName, String defaultNsUri) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUri);
    }

    public static BXml createXmlValue(BXmlQName startTagName, BString defaultNsUriVal) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUriVal);
    }

    @Deprecated
    public static BXml createXmlValue(BXmlQName startTagName, String defaultNsUri, boolean readonly) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUri, readonly);
    }

    public static BXml createXmlValue(BXmlQName startTagName, BString defaultNsUriVal, boolean readonly) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUriVal, readonly);
    }

    public static BXmlQName createXmlQName(BString qNameStr, String prefix) {
        return new XmlQName(qNameStr.getValue(), prefix);
    }

    public static BXmlQName createXmlQName(String localName, String uri, String prefix) {
        return new XmlQName(localName, uri, prefix);
    }

    public static BXmlQName createXmlQName(BString localName, BString uri, BString prefix) {
        return new XmlQName(localName, uri, prefix);
    }

    public static BXmlQName createXmlQName(String qNameStr) {
        return new XmlQName(qNameStr);
    }

    public static BXmlQName createXmlQName(BString qNameStr) {
        return new XmlQName(qNameStr);
    }

    public static BXmlSequence createXmlSequence() {
        return XmlFactory.createXmlSequence();
    }

    public static BXmlSequence createXmlSequence(BArray sequence) {
        return XmlFactory.createXmlSequence(sequence);
    }

    public static BXmlSequence createXmlSequence(List<BXml> sequence) {
        ArrayList<BXml> flattenedSequence = new ArrayList<BXml>();
        for (BXml item : sequence) {
            if (item.getNodeType() == XmlNodeType.SEQUENCE) {
                flattenedSequence.addAll(((XmlSequence)item).getChildrenList());
                continue;
            }
            flattenedSequence.add(item);
        }
        return XmlFactory.createXmlSequence(flattenedSequence);
    }

    public static BXmlSequence createXmlSequence(BXml child) {
        return XmlFactory.createXmlSequence(child);
    }

    @Deprecated
    public static BXml createXmlComment(String content) {
        return XmlFactory.createXMLComment(content);
    }

    public static BXml createXmlComment(BString content) {
        return XmlFactory.createXMLComment(content.getValue());
    }

    @Deprecated
    public static BXml createXmlComment(String content, boolean readonly) {
        return XmlFactory.createXMLComment(content, readonly);
    }

    public static BXml createXmlComment(BString content, boolean readonly) {
        return XmlFactory.createXMLComment(content, readonly);
    }

    @Deprecated
    public static BXml createXmlText(String content) {
        return XmlFactory.createXMLText(content);
    }

    public static BXml createXmlText(BString content) {
        return XmlFactory.createXMLText(content);
    }

    @Deprecated
    public static BXml createXmlProcessingInstruction(String target, String data) {
        return XmlFactory.createXMLProcessingInstruction(data, target);
    }

    public static BXml createXmlProcessingInstruction(BString target, BString data) {
        return XmlFactory.createXMLProcessingInstruction(target, data);
    }

    @Deprecated
    public static BXml createXmlProcessingInstruction(String target, String data, boolean readonly) {
        return XmlFactory.createXMLProcessingInstruction(data, target, readonly);
    }

    public static BXml createXmlProcessingInstruction(BString target, BString data, boolean readonly) {
        return XmlFactory.createXMLProcessingInstruction(target, data, readonly);
    }

    public static BMap<BString, Object> createMapValue() {
        return new MapValueImpl<BString, Object>();
    }

    @Deprecated
    public static BMap<BString, Object> createMapValue(Type mapType) {
        return new MapValueImpl<BString, Object>(mapType);
    }

    public static BMap<BString, Object> createMapValue(MapType mapType) {
        return new MapValueImpl<BString, Object>(mapType);
    }

    @Deprecated
    public static BMap<BString, Object> createMapValue(Type mapType, BMapInitialValueEntry[] keyValues) {
        return new MapValueImpl<BString, Object>(mapType, keyValues);
    }

    public static BMap<BString, Object> createMapValue(RecordType recordType, BMapInitialValueEntry[] keyValues) {
        return new MapValueImpl<BString, Object>(recordType, keyValues);
    }

    public static BMap<BString, Object> createMapValue(MapType mapType, BMapInitialValueEntry[] keyValues) {
        return new MapValueImpl<BString, Object>(mapType, keyValues);
    }

    public static BMapInitialValueEntry createKeyFieldEntry(Object key, Object value2) {
        return new MappingInitialValueEntry.KeyValueEntry(key, value2);
    }

    public static BMapInitialValueEntry createSpreadFieldEntry(BMap<?, ?> mappingValue) {
        return new MappingInitialValueEntry.SpreadFieldEntry(mappingValue);
    }

    public static BListInitialValueEntry createListInitialValueEntry(Object value2) {
        return new ListInitialValueEntry.ExpressionEntry(value2);
    }

    public static BMap<BString, Object> createRecordValue(RecordType recordType) {
        return new MapValueImpl<BString, Object>(recordType);
    }

    public static BMap<BString, Object> createRecordValue(RecordType recordType, BMapInitialValueEntry[] keyValues) {
        return new MapValueImpl<BString, Object>(recordType, keyValues);
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName) throws BError {
        return ValueUtils.createRecordValue(packageId, recordTypeName);
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName, Map<String, Object> valueMap) throws BError {
        valueMap = RuntimeUtils.validateBMapValues(valueMap);
        return ValueUtils.createRecordValue(packageId, recordTypeName, valueMap);
    }

    public static BMap<BString, Object> createReadonlyRecordValue(Module packageId, String recordTypeName, Map<String, Object> valueMap) throws BError {
        valueMap = RuntimeUtils.validateBMapValues(valueMap);
        MapValueImpl bMapValue = (MapValueImpl)ValueUtils.createRecordValue(packageId, recordTypeName, valueMap);
        bMapValue.freezeDirect();
        return bMapValue;
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName, BMap<BString, Object> valueMap) throws BError {
        valueMap = RuntimeUtils.validateBMapValues(valueMap);
        return ValueUtils.createRecordValue(packageId, recordTypeName, valueMap);
    }

    public static BMap<BString, Object> createReadonlyRecordValue(Module packageId, String recordTypeName, BMap<BString, Object> valueMap) throws BError {
        valueMap = RuntimeUtils.validateBMapValues(valueMap);
        MapValueImpl bMapValue = (MapValueImpl)ValueUtils.createRecordValue(packageId, recordTypeName, valueMap);
        bMapValue.freezeDirect();
        return bMapValue;
    }

    public static BMap<BString, Object> createRecordValue(BMap<BString, Object> record, Object ... values) {
        record = RuntimeUtils.validateBMapValues(record);
        return ValueUtils.createRecordValue(record, values);
    }

    public static BObject createObjectValue(Module packageId, String objectTypeName, Object ... fieldValues) throws BError {
        return ValueUtils.createObjectValue(packageId, objectTypeName, fieldValues);
    }

    public static BHandle createHandleValue(Object value2) {
        return new HandleValue(value2);
    }

    public static BTable<?, ?> createTableValue(TableType tableType) {
        return new TableValueImpl(tableType);
    }

    public static BTable<?, ?> createTableValue(TableType tableType, BArray data, BArray fieldNames) {
        return new TableValueImpl(tableType, (ArrayValue)data, (ArrayValue)fieldNames);
    }

    private ValueCreator() {
    }
}

