/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.BddAllOrNothing;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.BddNodeImpl;
import io.ballerina.runtime.api.types.semtype.BddPredicate;
import io.ballerina.runtime.api.types.semtype.Conjunction;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;

public abstract sealed class Bdd
extends SubType
implements SubTypeData
permits BddAllOrNothing, BddNode {
    Bdd(boolean all, boolean nothing) {
        super(all, nothing);
    }

    @Override
    public SubType union(SubType other) {
        return this.bddUnion((Bdd)other);
    }

    private Bdd bddUnion(Bdd other) {
        if (other == this) {
            return this;
        }
        if (this == BddAllOrNothing.ALL || other == BddAllOrNothing.ALL) {
            return BddAllOrNothing.ALL;
        }
        if (other == BddAllOrNothing.NOTHING) {
            return this;
        }
        if (this == BddAllOrNothing.NOTHING) {
            return other;
        }
        BddNode b1Bdd = (BddNode)this;
        BddNode b2Bdd = (BddNode)other;
        int cmp = this.atomCmp(b1Bdd.atom(), b2Bdd.atom());
        if (cmp < 0) {
            return this.bddCreate(b1Bdd.atom(), b1Bdd.left(), b1Bdd.middle().bddUnion(other), b1Bdd.right());
        }
        if (cmp > 0) {
            return this.bddCreate(b2Bdd.atom(), b2Bdd.left(), this.bddUnion(b2Bdd.middle()), b2Bdd.right());
        }
        return this.bddCreate(b1Bdd.atom(), b1Bdd.left().bddUnion(b2Bdd.left()), b1Bdd.middle().bddUnion(b2Bdd.middle()), b1Bdd.right().bddUnion(b2Bdd.right()));
    }

    private int atomCmp(Atom a1, Atom a2) {
        if (a1 instanceof RecAtom) {
            RecAtom r1 = (RecAtom)a1;
            if (a2 instanceof RecAtom) {
                RecAtom r2 = (RecAtom)a2;
                return r1.index() - r2.index();
            }
            return -1;
        }
        if (a2 instanceof RecAtom) {
            return 1;
        }
        return a1.index() - a2.index();
    }

    @Override
    public SubType intersect(SubType other) {
        return this.bddIntersect((Bdd)other);
    }

    private Bdd bddIntersect(Bdd other) {
        if (other == this) {
            return this;
        }
        if (this == BddAllOrNothing.NOTHING || other == BddAllOrNothing.NOTHING) {
            return BddAllOrNothing.NOTHING;
        }
        if (other == BddAllOrNothing.ALL) {
            return this;
        }
        if (this == BddAllOrNothing.ALL) {
            return other;
        }
        BddNode b1Bdd = (BddNode)this;
        BddNode b2Bdd = (BddNode)other;
        int cmp = this.atomCmp(b1Bdd.atom(), b2Bdd.atom());
        if (cmp < 0) {
            return this.bddCreate(b1Bdd.atom(), b1Bdd.left().bddIntersect(other), b1Bdd.middle().bddIntersect(other), b1Bdd.right().bddIntersect(other));
        }
        if (cmp > 0) {
            return this.bddCreate(b2Bdd.atom(), this.bddIntersect(b2Bdd.left()), this.bddIntersect(b2Bdd.middle()), this.bddIntersect(b2Bdd.right()));
        }
        return this.bddCreate(b1Bdd.atom(), b1Bdd.left().bddUnion(b1Bdd.middle()).bddIntersect(b2Bdd.left().bddUnion(b2Bdd.middle())), BddAllOrNothing.NOTHING, b1Bdd.right().bddUnion(b1Bdd.middle()).bddIntersect(b2Bdd.right().bddUnion(b2Bdd.middle())));
    }

    @Override
    public SubType diff(SubType other) {
        return this.bddDiff((Bdd)other);
    }

    private Bdd bddDiff(Bdd other) {
        if (this == other || other == BddAllOrNothing.ALL || this == BddAllOrNothing.NOTHING) {
            return BddAllOrNothing.NOTHING;
        }
        if (other == BddAllOrNothing.NOTHING) {
            return this;
        }
        if (this == BddAllOrNothing.ALL) {
            return other.bddComplement();
        }
        BddNode b1Bdd = (BddNode)this;
        BddNode b2Bdd = (BddNode)other;
        int cmp = this.atomCmp(b1Bdd.atom(), b2Bdd.atom());
        if ((long)cmp < 0L) {
            return this.bddCreate(b1Bdd.atom(), b1Bdd.left().bddUnion(b1Bdd.middle()).bddDiff(other), BddAllOrNothing.NOTHING, b1Bdd.right().bddUnion(b1Bdd.middle()).bddDiff(other));
        }
        if ((long)cmp > 0L) {
            return this.bddCreate(b2Bdd.atom(), this.bddDiff(b2Bdd.left().bddUnion(b2Bdd.middle())), BddAllOrNothing.NOTHING, this.bddDiff(b2Bdd.right().bddUnion(b2Bdd.middle())));
        }
        return this.bddCreate(b1Bdd.atom(), b1Bdd.left().bddUnion(b1Bdd.middle()).bddDiff(b2Bdd.left().bddUnion(b2Bdd.middle())), BddAllOrNothing.NOTHING, b1Bdd.right().bddUnion(b1Bdd.middle()).bddDiff(b2Bdd.right().bddUnion(b2Bdd.middle())));
    }

    @Override
    public SubType complement() {
        return this.bddComplement();
    }

    private Bdd bddComplement() {
        if (this == BddAllOrNothing.ALL) {
            return BddAllOrNothing.NOTHING;
        }
        if (this == BddAllOrNothing.NOTHING) {
            return BddAllOrNothing.ALL;
        }
        BddAllOrNothing nothing = BddAllOrNothing.NOTHING;
        BddNode b = (BddNode)this;
        if (b.right() == nothing) {
            return this.bddCreate(b.atom(), nothing, b.left().bddUnion(b.middle()).bddComplement(), b.middle().bddComplement());
        }
        if (b.left() == nothing) {
            return this.bddCreate(b.atom(), b.middle().bddComplement(), b.right().bddUnion(b.middle()).bddComplement(), nothing);
        }
        if (b.middle() == nothing) {
            return this.bddCreate(b.atom(), b.left().bddComplement(), b.left().bddUnion(b.right()).bddComplement(), b.right().bddComplement());
        }
        return this.bddCreate(b.atom(), b.left().bddUnion(b.middle()).bddComplement(), nothing, b.right().bddUnion(b.middle()).bddComplement());
    }

    private Bdd bddCreate(Atom atom, Bdd left, Bdd middle, Bdd right) {
        if (middle == BddAllOrNothing.ALL) {
            return middle;
        }
        if (left.equals(right)) {
            return left.bddUnion(right);
        }
        return new BddNodeImpl(atom, left, middle, right);
    }

    @Override
    public boolean isEmpty(Context cx) {
        throw new IllegalStateException("Bdd don't support isEmpty");
    }

    @Override
    public SubTypeData data() {
        throw new IllegalStateException("Bdd don't support data");
    }

    public static boolean bddEvery(Context cx, Bdd b, BddPredicate predicate) {
        return Bdd.bddEvery(cx, b, null, null, predicate);
    }

    private static boolean bddEvery(Context cx, Bdd b, Conjunction pos, Conjunction neg, BddPredicate predicate) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing == BddAllOrNothing.NOTHING || predicate.apply(cx, pos, neg);
        }
        BddNode bn = (BddNode)b;
        return Bdd.bddEvery(cx, bn.left(), Conjunction.and(bn.atom(), pos), neg, predicate) && Bdd.bddEvery(cx, bn.middle(), pos, neg, predicate) && Bdd.bddEvery(cx, bn.right(), pos, Conjunction.and(bn.atom(), neg), predicate);
    }

    public static boolean bddEveryPositive(Context cx, Bdd b, Conjunction pos, Conjunction neg, BddPredicate predicate) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing == BddAllOrNothing.NOTHING || predicate.apply(cx, pos, neg);
        }
        BddNode bn = (BddNode)b;
        return Bdd.bddEveryPositive(cx, bn.left(), Bdd.andIfPositive(bn.atom(), pos), neg, predicate) && Bdd.bddEveryPositive(cx, bn.middle(), pos, neg, predicate) && Bdd.bddEveryPositive(cx, bn.right(), pos, Bdd.andIfPositive(bn.atom(), neg), predicate);
    }

    private static Conjunction andIfPositive(Atom atom, Conjunction next2) {
        RecAtom recAtom;
        if (atom instanceof RecAtom && (recAtom = (RecAtom)atom).index() < 0) {
            return next2;
        }
        return Conjunction.and(atom, next2);
    }

    public abstract boolean posMaybeEmpty();

    public static String bddToString(Bdd b, boolean inner) {
        if (b instanceof BddAllOrNothing) {
            return b.isAll() ? "1" : "0";
        }
        BddNode bdd = (BddNode)b;
        Atom a = bdd.atom();
        Object str = a instanceof RecAtom ? "r" : "a";
        str = (String)str + a.index();
        str = (String)str + "?" + Bdd.bddToString(bdd.left(), true) + ":" + Bdd.bddToString(bdd.middle(), true) + ":" + Bdd.bddToString(bdd.right(), true);
        if (inner) {
            str = "(" + (String)str + ")";
        }
        return str;
    }
}

