/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import io.ballerina.runtime.api.types.TypeIdentifier;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.internal.types.semtype.CacheFactory;
import java.util.Map;

public class TypeCheckCacheFactory {
    private static final Map<TypeIdentifier, TypeCheckCache> cache = CacheFactory.createCachingHashMap();

    private TypeCheckCacheFactory() {
    }

    public static TypeCheckCache get(TypeIdentifier identifier) {
        if (identifier.avoidCaching()) {
            return TypeCheckCacheFactory.create();
        }
        TypeCheckCache cached = cache.get(identifier);
        if (cached != null) {
            return cached;
        }
        TypeCheckCache newCache = TypeCheckCacheFactory.create();
        cache.put(identifier, newCache);
        return newCache;
    }

    public static TypeCheckCache create() {
        return new TypeCheckCache();
    }

    public static void reset() {
        cache.clear();
    }
}

