/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.json;

import io.ballerina.runtime.api.constants.TypeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.json.TableJsonDataSource;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BJsonType;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class JsonInternalUtils {
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";

    public static boolean hasElement(Object json, String elementName) {
        if (!JsonInternalUtils.isJSONObject(json)) {
            return false;
        }
        return ((MapValueImpl)json).containsKey(StringUtils.fromString(elementName));
    }

    public static ArrayValue convertArrayToJSON(BArray bArray) {
        if (bArray == null) {
            return null;
        }
        Type elementType = TypeUtils.getImpliedType(bArray.getElementType());
        if (elementType == PredefinedTypes.TYPE_INT) {
            return JsonInternalUtils.convertIntArrayToJSON(bArray);
        }
        if (elementType == PredefinedTypes.TYPE_BOOLEAN) {
            return JsonInternalUtils.convertBooleanArrayToJSON(bArray);
        }
        if (elementType == PredefinedTypes.TYPE_FLOAT) {
            return JsonInternalUtils.convertFloatArrayToJSON(bArray);
        }
        if (elementType == PredefinedTypes.TYPE_STRING) {
            return JsonInternalUtils.convertStringArrayToJSON(bArray);
        }
        return JsonInternalUtils.convertRefArrayToJSON(bArray);
    }

    public static Object convertMapToJSON(BMap<BString, ?> map2, JsonType targetType) {
        if (map2 == null) {
            return null;
        }
        MapValueImpl<BString, Object> json = new MapValueImpl<BString, Object>(targetType);
        for (Map.Entry<BString, ?> structField : map2.entrySet()) {
            BString key = structField.getKey();
            Object value2 = structField.getValue();
            JsonInternalUtils.populateJSON(json, key, value2, PredefinedTypes.TYPE_JSON);
        }
        return json;
    }

    public static Object getElementOrNil(Object json, BString elementName) {
        return JsonInternalUtils.getMappingElement(json, elementName, true);
    }

    public static Object getElement(Object json, BString elementName) {
        return JsonInternalUtils.getMappingElement(json, elementName, false);
    }

    private static Object getMappingElement(Object json, BString elementName, boolean returnNilOnMissingKey) {
        if (!JsonInternalUtils.isJSONObject(json)) {
            return ErrorCreator.createError(ErrorReasons.JSON_OPERATION_ERROR, StringUtils.fromString("JSON value is not a mapping"));
        }
        MapValueImpl jsonObject = (MapValueImpl)json;
        if (!jsonObject.containsKey(elementName)) {
            if (returnNilOnMissingKey) {
                return null;
            }
            return ErrorCreator.createError(ErrorReasons.MAP_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_IN_JSON_MAPPING, elementName));
        }
        try {
            return jsonObject.get(elementName);
        }
        catch (Throwable t) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.JSON_GET_ERROR, t.getMessage());
        }
    }

    public static void setElement(Object json, String elementName, Object element) {
        if (!JsonInternalUtils.isJSONObject(json)) {
            return;
        }
        try {
            ((MapValueImpl)json).put(StringUtils.fromString(elementName), element);
        }
        catch (ErrorValue e) {
            throw e;
        }
        catch (Throwable t) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), ErrorCodes.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static boolean isJSONArray(Object json) {
        if (!(json instanceof BRefValue)) {
            return false;
        }
        BRefValue refValue = (BRefValue)json;
        return TypeUtils.getImpliedType(refValue.getType()).getTag() == 32;
    }

    public static boolean isJSONObject(Object json) {
        if (!(json instanceof BRefValue)) {
            return false;
        }
        BRefValue refValue = (BRefValue)json;
        Type type = TypeUtils.getImpliedType(refValue.getType());
        int typeTag = type.getTag();
        return typeTag == 27 || typeTag == 24;
    }

    public static MapValueImpl<BString, ?> jsonToMap(Object json, MapType mapType) {
        Type mapConstraint;
        MapValueImpl map2;
        block5: {
            block4: {
                if (!JsonInternalUtils.isJSONObject(json)) {
                    throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, JsonInternalUtils.getComplexObjectTypeName(OBJECT), JsonInternalUtils.getTypeName(json));
                }
                map2 = new MapValueImpl(mapType);
                mapConstraint = TypeUtils.getImpliedType(mapType.getConstrainedType());
                if (mapConstraint.getTag() == 29) break block4;
                if (mapConstraint.getTag() != 15) break block5;
            }
            ((MapValueImpl)json).forEach(map2::put);
            return map2;
        }
        ((MapValueImpl)json).forEach((key, value2) -> map2.put(key, JsonInternalUtils.convertJSON(value2, mapConstraint)));
        return map2;
    }

    public static MapValueImpl<BString, Object> convertJSONToRecord(Object json, StructureType structType) {
        if (!JsonInternalUtils.isJSONObject(json)) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, JsonInternalUtils.getComplexObjectTypeName(OBJECT), JsonInternalUtils.getTypeName(json));
        }
        ArrayList<MappingInitialValueEntry.KeyValueEntry> keyValuePairs = new ArrayList<MappingInitialValueEntry.KeyValueEntry>();
        MapValueImpl jsonObject = (MapValueImpl)json;
        for (Map.Entry<String, Field> field : structType.getFields().entrySet()) {
            Type fieldType = field.getValue().getFieldType();
            BString fieldName = StringUtils.fromString(field.getValue().getFieldName());
            try {
                if (!jsonObject.containsKey(fieldName)) {
                    keyValuePairs.add(new MappingInitialValueEntry.KeyValueEntry(fieldName, fieldType.getZeroValue()));
                    continue;
                }
                Object jsonValue = jsonObject.get(fieldName);
                keyValuePairs.add(new MappingInitialValueEntry.KeyValueEntry(fieldName, JsonInternalUtils.convertJSON(jsonValue, fieldType)));
            }
            catch (Exception e) {
                JsonInternalUtils.handleError(e, fieldName.getValue());
            }
        }
        return new MapValueImpl<BString, Object>(structType, (BMapInitialValueEntry[])keyValuePairs.toArray(MappingInitialValueEntry.KeyValueEntry[]::new));
    }

    public static Object convertJSON(Object jsonValue, Type targetType) {
        targetType = TypeUtils.getImpliedType(targetType);
        switch (targetType.getTag()) {
            case 2: {
                return JsonInternalUtils.jsonNodeToByte(jsonValue);
            }
            case 1: {
                return JsonInternalUtils.jsonNodeToInt(jsonValue);
            }
            case 3: {
                return JsonInternalUtils.jsonNodeToFloat(jsonValue);
            }
            case 4: {
                return JsonInternalUtils.jsonNodeToDecimal(jsonValue);
            }
            case 5: {
                if (jsonValue instanceof BString) {
                    return jsonValue;
                }
                return StringUtils.fromString(jsonValue.toString());
            }
            case 6: {
                return JsonInternalUtils.jsonNodeToBoolean(jsonValue);
            }
            case 15: {
                if (jsonValue != null && !TypeChecker.checkIsType(jsonValue, targetType)) {
                    throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, targetType, JsonInternalUtils.getTypeName(jsonValue));
                }
            }
            case 29: {
                return jsonValue;
            }
            case 33: {
                Type matchingType = TypeConverter.getConvertibleTypeInTargetUnionType(jsonValue, (BUnionType)targetType, null, new ArrayList<String>(), new HashSet<TypeValuePair>(), true);
                if (matchingType == null) {
                    throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, targetType, JsonInternalUtils.getTypeName(jsonValue));
                }
                return JsonInternalUtils.convertJSON(jsonValue, matchingType);
            }
            case 46: {
                Type matchingType = TypeConverter.getConvertibleFiniteType(jsonValue, (BFiniteType)targetType, null, new ArrayList<String>(), new HashSet<TypeValuePair>(), true);
                if (matchingType == null) {
                    throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, targetType, JsonInternalUtils.getTypeName(jsonValue));
                }
                return JsonInternalUtils.convertJSON(jsonValue, matchingType);
            }
            case 24: 
            case 47: {
                return JsonInternalUtils.convertJSONToRecord(jsonValue, (BStructureType)targetType);
            }
            case 32: {
                return JsonInternalUtils.convertJSONToBArray(jsonValue, (BArrayType)targetType);
            }
            case 27: {
                return JsonInternalUtils.jsonToMap(jsonValue, (MapType)targetType);
            }
            case 14: {
                if (jsonValue != null) break;
                return null;
            }
        }
        throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, targetType, JsonInternalUtils.getTypeName(jsonValue));
    }

    public static ArrayValue getKeys(Object json) {
        if (!JsonInternalUtils.isJSONObject(json)) {
            return new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_STRING));
        }
        BString[] keys = (BString[])((MapValueImpl)json).getKeys();
        return new ArrayValueImpl(keys, false);
    }

    public static Object convertUnionTypeToJSON(Object source, JsonType targetType) {
        if (source == null) {
            return null;
        }
        Type type = TypeUtils.getImpliedType(TypeChecker.getType(source));
        return switch (type.getTag()) {
            case 1, 3, 4, 5, 6, 15 -> source;
            case 14 -> null;
            case 24, 27, 47 -> JsonInternalUtils.convertMapToJSON((MapValueImpl)source, targetType);
            default -> throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_JSON, type);
        };
    }

    public static void remove(Object json, BString fieldName) {
        if (!JsonInternalUtils.isJSONObject(json)) {
            return;
        }
        ((MapValueImpl)json).remove(fieldName);
    }

    public static BError getErrorIfUnmergeable(Object j1, Object j2, List<ObjectPair> visitedPairs) {
        if (j1 == null || j2 == null) {
            return null;
        }
        Type j1Type = TypeUtils.getImpliedType(TypeChecker.getType(j1));
        Type j2Type = TypeUtils.getImpliedType(TypeChecker.getType(j2));
        if (j1Type.getTag() != 27 || j2Type.getTag() != 27) {
            return ErrorCreator.createError(ErrorReasons.MERGE_JSON_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.MERGE_JSON_ERROR, j1Type, j2Type));
        }
        ObjectPair currentPair = new ObjectPair(j1, j2);
        if (visitedPairs.contains(currentPair)) {
            return ErrorCreator.createError(ErrorReasons.MERGE_JSON_ERROR, StringUtils.fromString("Cannot merge JSON values with cyclic references"));
        }
        visitedPairs.add(currentPair);
        MapValue m1 = (MapValue)j1;
        MapValue m2 = (MapValue)j2;
        for (Map.Entry entry : m2.entrySet()) {
            BError elementMergeNullableError;
            BString key = (BString)entry.getKey();
            if (!m1.containsKey(key) || (elementMergeNullableError = JsonInternalUtils.getErrorIfUnmergeable(m1.get(key), entry.getValue(), visitedPairs)) == null) continue;
            BMapInitialValueEntry[] initialValues = new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(TypeConstants.DETAIL_MESSAGE, StringUtils.fromString("JSON Merge failed for key '" + String.valueOf(key) + "'")), new MappingInitialValueEntry.KeyValueEntry(TypeConstants.DETAIL_CAUSE, elementMergeNullableError)};
            MapValueImpl<BString, Object> detailMap = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
            return ErrorCreator.createError(ErrorReasons.MERGE_JSON_ERROR, detailMap);
        }
        return null;
    }

    public static Object mergeJson(Object j1, Object j2, boolean checkMergeability) {
        if (j1 == null) {
            return j2;
        }
        if (j2 == null) {
            return j1;
        }
        if (checkMergeability) {
            Type j1Type = TypeUtils.getImpliedType(TypeChecker.getType(j1));
            Type j2Type = TypeUtils.getImpliedType(TypeChecker.getType(j2));
            if (j1Type.getTag() != 27 || j2Type.getTag() != 27) {
                return ErrorCreator.createError(ErrorReasons.MERGE_JSON_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.MERGE_JSON_ERROR, j1Type, j2Type));
            }
        }
        MapValue m1 = (MapValue)j1;
        MapValue m2 = (MapValue)j2;
        return m1.merge(m2, true);
    }

    public static ArrayValue convertJSONToBArray(Object json, BArrayType targetArrayType) {
        if (!(json instanceof ArrayValue)) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, JsonInternalUtils.getComplexObjectTypeName(ARRAY), JsonInternalUtils.getTypeName(json));
        }
        ArrayValue jsonArray = (ArrayValue)json;
        Type targetElementType = TypeUtils.getImpliedType(targetArrayType.getElementType());
        switch (targetElementType.getTag()) {
            case 1: {
                return JsonInternalUtils.jsonArrayToBIntArray(jsonArray);
            }
            case 3: {
                return JsonInternalUtils.jsonArrayToBFloatArray(jsonArray);
            }
            case 4: {
                return JsonInternalUtils.jsonArrayToBDecimalArray(jsonArray);
            }
            case 5: {
                return JsonInternalUtils.jsonArrayToBStringArray(jsonArray);
            }
            case 6: {
                return JsonInternalUtils.jsonArrayToBooleanArray(jsonArray);
            }
            case 29: {
                ArrayList<ListInitialValueEntry.ExpressionEntry> array2 = new ArrayList<ListInitialValueEntry.ExpressionEntry>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    array2.add(i, new ListInitialValueEntry.ExpressionEntry(jsonArray.getRefValue(i)));
                }
                return new ArrayValueImpl((Type)targetArrayType, (BListInitialValueEntry[])array2.toArray(ListInitialValueEntry[]::new));
            }
        }
        ArrayList<ListInitialValueEntry.ExpressionEntry> array3 = new ArrayList<ListInitialValueEntry.ExpressionEntry>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            array3.add(new ListInitialValueEntry.ExpressionEntry(JsonInternalUtils.convertJSON(jsonArray.getRefValue(i), targetElementType)));
        }
        return new ArrayValueImpl((Type)targetArrayType, (BListInitialValueEntry[])array3.toArray(ListInitialValueEntry[]::new));
    }

    public static Object toJSON(BTable<?, ?> table2) {
        TableJsonDataSource jsonDataSource = new TableJsonDataSource(table2);
        return jsonDataSource.build();
    }

    public static BError createJsonConversionError(Throwable throwable, String prefix) {
        BString detail = StringUtils.fromString((String)(throwable.getMessage() != null ? prefix + ": " + throwable.getMessage() : "error occurred in JSON Conversion"));
        return ErrorCreator.createError(ErrorReasons.JSON_CONVERSION_ERROR, detail);
    }

    private static long jsonNodeToInt(Object json) {
        if (!(json instanceof Long) && !(json instanceof Integer)) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_INT, JsonInternalUtils.getTypeName(json));
        }
        return ((Number)json).longValue();
    }

    private static long jsonNodeToByte(Object json) {
        long x;
        if ((json instanceof Long || json instanceof Integer) && TypeChecker.isByteLiteral(x = ((Number)json).longValue())) {
            return x;
        }
        throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_BYTE, JsonInternalUtils.getTypeName(json));
    }

    private static double jsonNodeToFloat(Object json) {
        if (json instanceof Integer) {
            Integer i = (Integer)json;
            return i.longValue();
        }
        if (json instanceof Double) {
            Double d = (Double)json;
            return d;
        }
        if (json instanceof DecimalValue) {
            DecimalValue decimalValue = (DecimalValue)json;
            return decimalValue.floatValue();
        }
        throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_FLOAT, JsonInternalUtils.getTypeName(json));
    }

    private static DecimalValue jsonNodeToDecimal(Object json) {
        BigDecimal decimal2;
        if (json instanceof Integer) {
            Integer i = (Integer)json;
            decimal2 = new BigDecimal(i.longValue());
        } else if (json instanceof Double) {
            Double d = (Double)json;
            decimal2 = BigDecimal.valueOf(d);
        } else if (json instanceof BigDecimal) {
            BigDecimal bigDecimal;
            decimal2 = bigDecimal = (BigDecimal)json;
        } else {
            if (json instanceof DecimalValue) {
                DecimalValue decimalValue = (DecimalValue)json;
                return decimalValue;
            }
            throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_DECIMAL, JsonInternalUtils.getTypeName(json));
        }
        return new DecimalValue(decimal2);
    }

    private static boolean jsonNodeToBoolean(Object json) {
        if (!(json instanceof Boolean)) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_BOOLEAN, JsonInternalUtils.getTypeName(json));
        }
        Boolean b = (Boolean)json;
        return b;
    }

    private static ArrayValue jsonArrayToBIntArray(ArrayValue arrayNode) {
        ArrayValueImpl intArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_INT));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            intArray.add((long)i, JsonInternalUtils.jsonNodeToInt(jsonValue));
        }
        return intArray;
    }

    private static ArrayValue jsonArrayToBFloatArray(ArrayValue arrayNode) {
        ArrayValueImpl floatArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_FLOAT));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            floatArray.add((long)i, JsonInternalUtils.jsonNodeToFloat(jsonValue));
        }
        return floatArray;
    }

    private static ArrayValue jsonArrayToBDecimalArray(ArrayValue arrayNode) {
        ArrayValueImpl decimalArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_DECIMAL));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            decimalArray.add((long)i, JsonInternalUtils.jsonNodeToDecimal(jsonValue));
        }
        return decimalArray;
    }

    private static ArrayValue jsonArrayToBStringArray(ArrayValue arrayNode) {
        ArrayValueImpl stringArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_STRING));
        for (int i = 0; i < arrayNode.size(); ++i) {
            stringArray.add((long)i, arrayNode.getRefValue(i).toString());
        }
        return stringArray;
    }

    private static ArrayValue jsonArrayToBooleanArray(ArrayValue arrayNode) {
        ArrayValueImpl booleanArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_BOOLEAN));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            booleanArray.add((long)i, JsonInternalUtils.jsonNodeToBoolean(jsonValue));
        }
        return booleanArray;
    }

    private static ArrayValue convertRefArrayToJSON(BArray refValueArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        block5: for (int i = 0; i < refValueArray.size(); ++i) {
            Object value2 = refValueArray.getRefValue(i);
            if (value2 == null) {
                json.append(null);
            }
            Type type = TypeUtils.getImpliedType(TypeChecker.getType(value2));
            switch (type.getTag()) {
                case 15: {
                    json.append(value2);
                    continue block5;
                }
                case 24: 
                case 27: 
                case 47: {
                    json.append(JsonInternalUtils.convertMapToJSON((MapValueImpl)value2, PredefinedTypes.TYPE_JSON));
                    continue block5;
                }
                case 32: {
                    json.append(JsonInternalUtils.convertArrayToJSON((ArrayValue)value2));
                    continue block5;
                }
                default: {
                    throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_JSON, type);
                }
            }
        }
        return json;
    }

    private static ArrayValue convertIntArrayToJSON(BArray intArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < intArray.size(); ++i) {
            long value2 = intArray.getInt(i);
            json.append(value2);
        }
        return json;
    }

    private static ArrayValue convertFloatArrayToJSON(BArray floatArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < floatArray.size(); ++i) {
            double value2 = floatArray.getFloat(i);
            json.append(value2);
        }
        return json;
    }

    private static ArrayValue convertStringArrayToJSON(BArray stringArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < stringArray.size(); ++i) {
            json.append(stringArray.getBString(i));
        }
        return json;
    }

    private static ArrayValue convertBooleanArrayToJSON(BArray booleanArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < booleanArray.size(); ++i) {
            boolean value2 = booleanArray.getBoolean(i);
            json.append(value2);
        }
        return json;
    }

    private static void populateJSON(BMap<BString, Object> json, BString key, Object value2, Type exptType) {
        try {
            if (value2 == null) {
                json.put(key, null);
                return;
            }
            Type type = TypeUtils.getImpliedType(TypeChecker.getType(value2));
            switch (type.getTag()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 15: {
                    json.put(key, value2);
                    break;
                }
                case 32: {
                    json.put(key, JsonInternalUtils.convertArrayToJSON((ArrayValue)value2));
                    break;
                }
                case 24: 
                case 27: 
                case 47: {
                    json.put(key, JsonInternalUtils.convertMapToJSON((MapValueImpl)value2, (BJsonType)exptType));
                    break;
                }
                default: {
                    throw ErrorHelper.getRuntimeException(ErrorCodes.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_JSON, type);
                }
            }
        }
        catch (Exception e) {
            JsonInternalUtils.handleError(e, key.getValue());
        }
    }

    private static String getTypeName(Object jsonValue) {
        if (jsonValue == null) {
            return PredefinedTypes.TYPE_NULL.toString();
        }
        return TypeChecker.getType(jsonValue).toString();
    }

    private static String getComplexObjectTypeName(String nodeType) {
        return "json-" + nodeType;
    }

    private static void handleError(Exception e, String fieldName) {
        Object errorMsg = e.getCause() == null ? "error while mapping '" + fieldName + "': " : "";
        throw ErrorCreator.createError(StringUtils.fromString((String)errorMsg + e.getMessage()), e);
    }

    private JsonInternalUtils() {
    }

    private static class ObjectPair {
        Object lhsObject;
        Object rhsObject;

        public ObjectPair(Object lhsObject, Object rhsObject) {
            this.lhsObject = lhsObject;
            this.rhsObject = rhsObject;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectPair)) {
                return false;
            }
            ObjectPair other = (ObjectPair)obj;
            return this.lhsObject == other.lhsObject && this.rhsObject == other.rhsObject;
        }
    }
}

