/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.json;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.json.ParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;

public abstract class StateMachine {
    static final char CR = '\r';
    static final char NEWLINE = '\n';
    static final char HZ_TAB = '\t';
    static final char SPACE = ' ';
    static final char BACKSPACE = '\b';
    static final char FORMFEED = '\f';
    static final char QUOTES = '\"';
    static final char REV_SOL = '\\';
    static final char SOL = '/';
    static final char EOF = '\uffff';
    static final String NULL = "null";
    static final String TRUE = "true";
    static final String FALSE = "false";
    static final State DOC_START_STATE = new DocumentStartState();
    static final State DOC_END_STATE = new DocumentEndState();
    static final State FIRST_FIELD_READY_STATE = new FirstFieldReadyState();
    static final State NON_FIRST_FIELD_READY_STATE = new NonFirstFieldReadyState();
    protected State fieldNameState;
    static final State END_FIELD_NAME_STATE = new EndFieldNameState();
    static final State FIELD_VALUE_READY_STATE = new FieldValueReadyState();
    protected State stringFieldValueState;
    static final State NON_STRING_FIELD_VALUE_STATE = new NonStringFieldValueState();
    static final State NON_STRING_VALUE_STATE = new NonStringValueState();
    protected State stringValueState;
    static final State FIELD_END_STATE = new FieldEndState();
    static final State STRING_AE_ESC_CHAR_PROCESSING_STATE = new StringAEEscapedCharacterProcessingState();
    static final State STRING_AE_PROCESSING_STATE = new StringAEProcessingState();
    static final State FIELD_NAME_UNICODE_HEX_PROCESSING_STATE = new FieldNameUnicodeHexProcessingState();
    static final State FIRST_ARRAY_ELEMENT_READY_STATE = new FirstArrayElementReadyState();
    static final State NON_FIRST_ARRAY_ELEMENT_READY_STATE = new NonFirstArrayElementReadyState();
    protected State stringArrayElementState;
    static final State NON_STRING_ARRAY_ELEMENT_STATE = new NonStringArrayElementState();
    static final State ARRAY_ELEMENT_END_STATE = new ArrayElementEndState();
    static final State STRING_FIELD_ESC_CHAR_PROCESSING_STATE = new StringFieldEscapedCharacterProcessingState();
    static final State STRING_VAL_ESC_CHAR_PROCESSING_STATE = new StringValueEscapedCharacterProcessingState();
    static final State FIELD_NAME_ESC_CHAR_PROCESSING_STATE = new FieldNameEscapedCharacterProcessingState();
    static final State STRING_FIELD_UNICODE_HEX_PROCESSING_STATE = new StringFieldUnicodeHexProcessingState();
    static final State STRING_VALUE_UNICODE_HEX_PROCESSING_STATE = new StringValueUnicodeHexProcessingState();
    protected Object currentJsonNode = null;
    protected final Deque<Object> nodesStack = new ArrayDeque<Object>();
    protected final Deque<String> fieldNames = new ArrayDeque<String>();
    protected final StringBuilder hexBuilder = new StringBuilder(4);
    protected char[] charBuff = new char[1024];
    protected int charBuffIndex;
    protected int index = 0;
    protected int line = 1;
    protected int column = 0;
    protected char currentQuoteChar;
    String errorPrefix;

    StateMachine(String errorPrefix, State fieldNameState, State stringValueState, State stringFieldValueState, State stringArrayElementState) {
        this.errorPrefix = errorPrefix;
        this.fieldNameState = fieldNameState;
        this.stringValueState = stringValueState;
        this.stringFieldValueState = stringFieldValueState;
        this.stringArrayElementState = stringArrayElementState;
    }

    public void reset() {
        this.index = 0;
        this.currentJsonNode = null;
        this.line = 1;
        this.column = 0;
        this.nodesStack.clear();
        this.fieldNames.clear();
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public void processLocation(char ch) {
        if (ch == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
    }

    public Object execute(Reader reader) throws BError {
        State currentState = DOC_START_STATE;
        try {
            int count;
            char[] buff = new char[1024];
            while ((count = reader.read(buff)) > 0) {
                this.index = 0;
                while (this.index < count) {
                    currentState = currentState.transition(this, buff, this.index, count);
                }
            }
            if ((currentState = currentState.transition(this, new char[]{'\uffff'}, 0, 1)) != DOC_END_STATE) {
                throw ErrorCreator.createError(StringUtils.fromString("invalid JSON document"));
            }
            return this.currentJsonNode;
        }
        catch (IOException e) {
            throw ErrorCreator.createError(StringUtils.fromString("Error reading JSON: " + e.getMessage()));
        }
        catch (ParserException e) {
            throw ErrorCreator.createError(StringUtils.fromString(e.getMessage() + " at line: " + this.line + " column: " + this.column));
        }
    }

    public void append(char ch) {
        try {
            this.charBuff[this.charBuffIndex] = ch;
            ++this.charBuffIndex;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.growCharBuff();
            this.charBuff[this.charBuffIndex++] = ch;
        }
    }

    public void growCharBuff() {
        char[] newBuff = new char[this.charBuff.length * 2];
        System.arraycopy(this.charBuff, 0, newBuff, 0, this.charBuff.length);
        this.charBuff = newBuff;
    }

    public static void throwExpected(String ... chars) throws ParserException {
        throw new ParserException("expected '" + String.join((CharSequence)"' or '", chars) + "'");
    }

    protected abstract State finalizeObject() throws ParserException;

    protected abstract State initNewObject() throws ParserException;

    protected abstract State initNewArray() throws ParserException;

    String value() {
        String result = new String(this.charBuff, 0, this.charBuffIndex);
        this.charBuffIndex = 0;
        return result;
    }

    public void processFieldName() {
        this.fieldNames.push(this.value());
    }

    abstract void processNonStringValue(ValueType var1) throws ParserException;

    abstract void setValueToJsonType(ValueType var1, Object var2);

    static boolean isExponential(String str) {
        return str.contains("e") || str.contains("E");
    }

    static boolean isNegativeZero(String str) {
        return '-' == str.charAt(0) && 0.0 == Double.parseDouble(str);
    }

    public static interface State {
        public State transition(StateMachine var1, char[] var2, int var3, int var4) throws ParserException;
    }

    private static class DocumentStartState
    implements State {
        private DocumentStartState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (ch == '{') {
                    state = sm.initNewObject();
                    break;
                }
                if (ch == '[') {
                    state = sm.initNewArray();
                    break;
                }
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == '\"') {
                        sm.currentQuoteChar = ch;
                        state = sm.stringValueState;
                        break;
                    }
                    if (ch == '\uffff') {
                        throw new ParserException("empty JSON document");
                    }
                    state = NON_STRING_VALUE_STATE;
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = state == NON_STRING_VALUE_STATE ? i : i + 1;
            return state;
        }
    }

    private static class DocumentEndState
    implements State {
        private DocumentEndState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            DocumentEndState state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (!StateMachine.isWhitespace(ch) && ch != '\uffff') {
                    throw new ParserException(sm.errorPrefix + " has already ended");
                }
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class FirstFieldReadyState
    implements State {
        private FirstFieldReadyState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (ch == '\"') {
                    state = sm.fieldNameState;
                    sm.currentQuoteChar = ch;
                    break;
                }
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == '}') {
                        state = sm.finalizeObject();
                        break;
                    }
                    StateMachine.throwExpected("\"", "}");
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class NonFirstFieldReadyState
    implements State {
        private NonFirstFieldReadyState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (ch == '\"') {
                    sm.currentQuoteChar = ch;
                    state = sm.fieldNameState;
                    break;
                }
                if (!StateMachine.isWhitespace(ch)) {
                    StateMachine.throwExpected("\"");
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class EndFieldNameState
    implements State {
        private EndFieldNameState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == ':') {
                        state = FIELD_VALUE_READY_STATE;
                        break;
                    }
                    StateMachine.throwExpected(":");
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class FieldValueReadyState
    implements State {
        private FieldValueReadyState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == '\"') {
                        state = sm.stringFieldValueState;
                        sm.currentQuoteChar = ch;
                        break;
                    }
                    if (ch == '{') {
                        state = sm.initNewObject();
                        break;
                    }
                    if (ch == '[') {
                        state = sm.initNewArray();
                        break;
                    }
                    if (ch == ']' || ch == '}') {
                        throw new ParserException("expected a field value");
                    }
                    state = NON_STRING_FIELD_VALUE_STATE;
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = state == NON_STRING_FIELD_VALUE_STATE ? i : i + 1;
            return state;
        }
    }

    private static class NonStringFieldValueState
    implements State {
        private NonStringFieldValueState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (ch == '{') {
                    state = sm.initNewObject();
                    break;
                }
                if (ch == '[') {
                    state = sm.initNewArray();
                    break;
                }
                if (ch == '}' || ch == ']') {
                    sm.processNonStringValue(ValueType.FIELD);
                    state = sm.finalizeObject();
                    break;
                }
                if (ch == ',') {
                    sm.processNonStringValue(ValueType.FIELD);
                    state = NON_FIRST_FIELD_READY_STATE;
                    break;
                }
                if (StateMachine.isWhitespace(ch)) {
                    sm.processNonStringValue(ValueType.FIELD);
                    state = FIELD_END_STATE;
                    break;
                }
                if (ch == '\uffff') {
                    throw new ParserException("unexpected end of " + sm.errorPrefix);
                }
                sm.append(ch);
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class NonStringValueState
    implements State {
        private NonStringValueState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (StateMachine.isWhitespace(ch) || ch == '\uffff') {
                    sm.currentJsonNode = null;
                    sm.processNonStringValue(ValueType.VALUE);
                    state = DOC_END_STATE;
                    break;
                }
                sm.append(ch);
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class FieldEndState
    implements State {
        private FieldEndState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == ',') {
                        state = NON_FIRST_FIELD_READY_STATE;
                        break;
                    }
                    if (ch == '}') {
                        state = sm.finalizeObject();
                        break;
                    }
                    StateMachine.throwExpected(",", "}");
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class StringAEEscapedCharacterProcessingState
    extends EscapedCharacterProcessingState {
        private StringAEEscapedCharacterProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.stringArrayElementState;
        }
    }

    private static class StringAEProcessingState
    extends UnicodeHexProcessingState {
        private StringAEProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.stringArrayElementState;
        }
    }

    private static class FieldNameUnicodeHexProcessingState
    extends UnicodeHexProcessingState {
        private FieldNameUnicodeHexProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.fieldNameState;
        }
    }

    private static class FirstArrayElementReadyState
    implements State {
        private FirstArrayElementReadyState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == '\"') {
                        state = sm.stringArrayElementState;
                        sm.currentQuoteChar = ch;
                        break;
                    }
                    if (ch == '{') {
                        state = sm.initNewObject();
                        break;
                    }
                    if (ch == '[') {
                        state = sm.initNewArray();
                        break;
                    }
                    if (ch == ']') {
                        state = sm.finalizeObject();
                        break;
                    }
                    state = NON_STRING_ARRAY_ELEMENT_STATE;
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = state == NON_STRING_ARRAY_ELEMENT_STATE ? i : i + 1;
            return state;
        }
    }

    private static class NonFirstArrayElementReadyState
    implements State {
        private NonFirstArrayElementReadyState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == '\"') {
                        state = sm.stringArrayElementState;
                        sm.currentQuoteChar = ch;
                        break;
                    }
                    if (ch == '{') {
                        state = sm.initNewObject();
                        break;
                    }
                    if (ch == '[') {
                        state = sm.initNewArray();
                        break;
                    }
                    if (ch == ']') {
                        throw new ParserException("expected an array element");
                    }
                    state = NON_STRING_ARRAY_ELEMENT_STATE;
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = state == NON_STRING_ARRAY_ELEMENT_STATE ? i : i + 1;
            return state;
        }
    }

    private static class NonStringArrayElementState
    implements State {
        private NonStringArrayElementState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (ch == '{') {
                    state = sm.initNewObject();
                    break;
                }
                if (ch == '[') {
                    state = sm.initNewArray();
                    break;
                }
                if (ch == ']') {
                    sm.processNonStringValue(ValueType.ARRAY_ELEMENT);
                    state = sm.finalizeObject();
                    break;
                }
                if (ch == ',') {
                    sm.processNonStringValue(ValueType.ARRAY_ELEMENT);
                    state = NON_FIRST_ARRAY_ELEMENT_READY_STATE;
                    break;
                }
                if (StateMachine.isWhitespace(ch)) {
                    sm.processNonStringValue(ValueType.ARRAY_ELEMENT);
                    state = ARRAY_ELEMENT_END_STATE;
                    break;
                }
                if (ch == '\uffff') {
                    throw new ParserException("unexpected end of " + sm.errorPrefix);
                }
                sm.append(ch);
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class ArrayElementEndState
    implements State {
        private ArrayElementEndState() {
        }

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (!StateMachine.isWhitespace(ch)) {
                    if (ch == ',') {
                        state = NON_FIRST_ARRAY_ELEMENT_READY_STATE;
                        break;
                    }
                    if (ch == ']') {
                        state = sm.finalizeObject();
                        break;
                    }
                    StateMachine.throwExpected(",", "]");
                    break;
                }
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static class StringFieldEscapedCharacterProcessingState
    extends EscapedCharacterProcessingState {
        private StringFieldEscapedCharacterProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.stringFieldValueState;
        }
    }

    private static class StringValueEscapedCharacterProcessingState
    extends EscapedCharacterProcessingState {
        private StringValueEscapedCharacterProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.stringValueState;
        }
    }

    private static class FieldNameEscapedCharacterProcessingState
    extends EscapedCharacterProcessingState {
        private FieldNameEscapedCharacterProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.fieldNameState;
        }
    }

    private static class StringFieldUnicodeHexProcessingState
    extends UnicodeHexProcessingState {
        private StringFieldUnicodeHexProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.stringFieldValueState;
        }
    }

    private static class StringValueUnicodeHexProcessingState
    extends UnicodeHexProcessingState {
        private StringValueUnicodeHexProcessingState() {
        }

        @Override
        protected State getSourceState(StateMachine sm) {
            return sm.stringValueState;
        }
    }

    static enum ValueType {
        FIELD,
        VALUE,
        ARRAY_ELEMENT;

    }

    private static abstract class EscapedCharacterProcessingState
    implements State {
        private EscapedCharacterProcessingState() {
        }

        protected abstract State getSourceState(StateMachine var1);

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            if (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                switch (ch) {
                    case '\"': {
                        sm.append('\"');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case '\\': {
                        sm.append('\\');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case '/': {
                        sm.append('/');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case 'b': {
                        sm.append('\b');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case 'f': {
                        sm.append('\f');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case 'n': {
                        sm.append('\n');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case 'r': {
                        sm.append('\r');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case 't': {
                        sm.append('\t');
                        state = this.getSourceState(sm);
                        break;
                    }
                    case 'u': {
                        if (this.getSourceState(sm) == sm.stringFieldValueState) {
                            state = STRING_FIELD_UNICODE_HEX_PROCESSING_STATE;
                            break;
                        }
                        if (this.getSourceState(sm) == sm.stringValueState) {
                            state = STRING_VALUE_UNICODE_HEX_PROCESSING_STATE;
                            break;
                        }
                        if (this.getSourceState(sm) == sm.fieldNameState) {
                            state = FIELD_NAME_UNICODE_HEX_PROCESSING_STATE;
                            break;
                        }
                        state = STRING_AE_PROCESSING_STATE;
                        break;
                    }
                    default: {
                        throw new ParserException("expected escaped characters");
                    }
                }
            }
            sm.index = i + 1;
            return state;
        }
    }

    private static abstract class UnicodeHexProcessingState
    implements State {
        private UnicodeHexProcessingState() {
        }

        protected abstract State getSourceState(StateMachine var1);

        @Override
        public State transition(StateMachine sm, char[] buff, int i, int count) throws ParserException {
            State state = null;
            while (i < count) {
                char ch = buff[i];
                sm.processLocation(ch);
                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') {
                    sm.hexBuilder.append(ch);
                    if (sm.hexBuilder.length() >= 4) {
                        sm.append(this.extractUnicodeChar(sm));
                        this.reset(sm);
                        state = this.getSourceState(sm);
                        break;
                    }
                } else {
                    this.reset(sm);
                    throw new ParserException("expected the hexadecimal value of a unicode character");
                }
                state = this;
                ++i;
            }
            sm.index = i + 1;
            return state;
        }

        private void reset(StateMachine sm) {
            sm.hexBuilder.setLength(0);
        }

        private char extractUnicodeChar(StateMachine sm) {
            return Utils.unescapeJava("\\u" + String.valueOf(sm.hexBuilder)).charAt(0);
        }
    }
}

