/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.types.TypeId;
import io.ballerina.runtime.api.types.TypeIdSet;
import io.ballerina.runtime.api.types.semtype.Env;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

final class DistinctIdSupplier
implements Supplier<Collection<Integer>> {
    private List<Integer> ids = null;
    private static final Map<TypeIdWrapper, Integer> allocatedIds = new ConcurrentHashMap<TypeIdWrapper, Integer>();
    private final Env env;
    private final TypeIdSet typeIdSet;

    DistinctIdSupplier(Env env, TypeIdSet typeIdSet) {
        this.env = env;
        this.typeIdSet = typeIdSet;
    }

    @Override
    public synchronized Collection<Integer> get() {
        if (this.ids != null) {
            return this.ids;
        }
        if (this.typeIdSet == null) {
            return List.of();
        }
        this.ids = this.typeIdSet.getIds().stream().map(TypeIdWrapper::new).map(typeId -> allocatedIds.computeIfAbsent((TypeIdWrapper)typeId, ignored -> this.env.distinctAtomCountGetAndIncrement())).toList();
        return this.ids;
    }

    private record TypeIdWrapper(TypeId typeId) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TypeIdWrapper) {
                TypeIdWrapper other = (TypeIdWrapper)obj;
                return this.typeId.getName().equals(other.typeId().getName()) && this.typeId.getPkg().equals(other.typeId().getPkg());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.typeId.getPkg(), this.typeId.getName());
        }
    }
}

