/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;

public final class BBooleanSubType
extends SubType {
    private final BBooleanSubTypeData data;
    private static final BBooleanSubType ALL = new BBooleanSubType(BBooleanSubTypeData.ALL);
    private static final BBooleanSubType NOTHING = new BBooleanSubType(BBooleanSubTypeData.NOTHING);
    private static final BBooleanSubType TRUE = new BBooleanSubType(BBooleanSubTypeData.TRUE);
    private static final BBooleanSubType FALSE = new BBooleanSubType(BBooleanSubTypeData.FALSE);

    private BBooleanSubType(BBooleanSubTypeData data) {
        super(data.isAll(), data.isNothing());
        this.data = data;
    }

    public static BBooleanSubType from(boolean value2) {
        return value2 ? TRUE : FALSE;
    }

    @Override
    public SubType union(SubType otherSubtype) {
        if (!(otherSubtype instanceof BBooleanSubType)) {
            throw new IllegalArgumentException("union of different subtypes");
        }
        BBooleanSubType other = (BBooleanSubType)otherSubtype;
        if (this.isAll() || other.isAll()) {
            return ALL;
        }
        if (this.isNothing()) {
            return other;
        }
        if (other.isNothing()) {
            return this;
        }
        if (this.data.value == other.data.value) {
            return this;
        }
        return ALL;
    }

    @Override
    public SubType intersect(SubType otherSubtype) {
        if (!(otherSubtype instanceof BBooleanSubType)) {
            throw new IllegalArgumentException("intersection of different subtypes");
        }
        BBooleanSubType other = (BBooleanSubType)otherSubtype;
        if (this.isAll()) {
            return other;
        }
        if (other.isAll()) {
            return this;
        }
        if (this.isNothing() || other.isNothing()) {
            return NOTHING;
        }
        if (this.data.value == other.data.value) {
            return this;
        }
        return NOTHING;
    }

    @Override
    public SubType diff(SubType otherSubtype) {
        if (!(otherSubtype instanceof BBooleanSubType)) {
            throw new IllegalArgumentException("diff of different subtypes");
        }
        BBooleanSubType other = (BBooleanSubType)otherSubtype;
        if (this.isAll() && other.isAll()) {
            return NOTHING;
        }
        if (this.isNothing() || other.isAll()) {
            return NOTHING;
        }
        if (other.isNothing()) {
            return this;
        }
        if (this.isAll()) {
            return BBooleanSubType.from(!other.data.value);
        }
        return this.data.value == other.data.value ? NOTHING : this;
    }

    @Override
    public SubType complement() {
        if (this.isAll()) {
            return NOTHING;
        }
        if (this.isNothing()) {
            return ALL;
        }
        return BBooleanSubType.from(!this.data.value);
    }

    @Override
    public boolean isEmpty(Context cx) {
        return this.data.isNothing();
    }

    @Override
    public SubTypeData data() {
        return this.data.toData();
    }

    @Override
    public int hashCode() {
        if (this == ALL) {
            return 0;
        }
        if (this == NOTHING) {
            return 1;
        }
        if (this == TRUE) {
            return 2;
        }
        if (this == FALSE) {
            return 3;
        }
        assert (false) : "unexpected BBooleanSubType instance";
        return -1;
    }

    private record BBooleanSubTypeData(boolean isAll, boolean isNothing, boolean value) {
        private static final BBooleanSubTypeData ALL = new BBooleanSubTypeData(true, false, false);
        private static final BBooleanSubTypeData NOTHING = new BBooleanSubTypeData(false, true, false);
        private static final BBooleanSubTypeData TRUE = new BBooleanSubTypeData(false, false, true);
        private static final BBooleanSubTypeData FALSE = new BBooleanSubTypeData(false, false, false);

        SubTypeData toData() {
            if (this.isAll()) {
                return AllOrNothing.ALL;
            }
            if (this.isNothing()) {
                return AllOrNothing.NOTHING;
            }
            return new BooleanSubTypeData(this.value());
        }
    }

    private record BooleanSubTypeData(boolean value) implements SubTypeData
    {
    }
}

