/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.SemType;
import java.util.Arrays;
import java.util.Objects;

public final class FixedLengthArray {
    private final SemType[] initial;
    private final int fixedLength;
    private Integer hashCode;
    private static final FixedLengthArray EMPTY = new FixedLengthArray(new SemType[0], 0);

    private FixedLengthArray(SemType[] initial, int fixedLength) {
        for (SemType semType : initial) {
            if (semType != null) continue;
            throw new IllegalArgumentException("initial members can't be null");
        }
        this.initial = initial;
        this.fixedLength = fixedLength;
    }

    public static FixedLengthArray from(SemType[] initial, int fixedLength) {
        return new FixedLengthArray(initial, fixedLength);
    }

    static FixedLengthArray normalized(SemType[] initial, int fixedLength) {
        if (initial.length < 2) {
            return new FixedLengthArray(initial, fixedLength);
        }
        int i = initial.length - 1;
        SemType last = initial[i];
        --i;
        while (i >= 0 && last == initial[i]) {
            --i;
        }
        int length = Integer.max(1, i + 2);
        SemType[] buffer = new SemType[length];
        if (length == 1) {
            buffer[0] = last;
        } else {
            System.arraycopy(initial, 0, buffer, 0, length);
        }
        return new FixedLengthArray(buffer, fixedLength);
    }

    public static FixedLengthArray empty() {
        return EMPTY;
    }

    public FixedLengthArray shallowCopy() {
        return new FixedLengthArray((SemType[])this.initial.clone(), this.fixedLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedLengthArray)) {
            return false;
        }
        FixedLengthArray that = (FixedLengthArray)o;
        return this.fixedLength == that.fixedLength && Objects.deepEquals(this.initial, that.initial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Integer result = this.hashCode;
        if (result == null) {
            FixedLengthArray fixedLengthArray = this;
            synchronized (fixedLengthArray) {
                result = this.hashCode;
                if (result == null) {
                    this.hashCode = result = Integer.valueOf(this.computeHashCode());
                }
            }
        }
        return result;
    }

    private int computeHashCode() {
        return Objects.hash(Arrays.hashCode(this.initial), this.fixedLength);
    }

    public int fixedLength() {
        return this.fixedLength;
    }

    public SemType[] initial() {
        return this.initial;
    }
}

