/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.BMappingSubType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.MappingAtomicType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MappingDefinition
extends Definition {
    private volatile RecAtom rec = null;
    private volatile SemType semType = null;
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemType getSemType(Env env) {
        try {
            RecAtom rec;
            this.lock.lock();
            if (this.semType != null) {
                SemType semType = this.semType;
                return semType;
            }
            assert (this.rec == null);
            this.rec = rec = env.recMappingAtom();
            SemType semType = this.createSemType(env, rec);
            return semType;
        }
        finally {
            this.lock.unlock();
        }
    }

    private SemType createSemType(Env env, Atom atom) {
        BddNode bdd = BddNode.bddAtom(atom);
        this.semType = Builder.basicSubType(BasicTypeCode.BT_MAPPING, BMappingSubType.createDelegate(bdd));
        return this.semType;
    }

    public SemType defineMappingTypeWrapped(Env env, Field[] fields, SemType rest, CellAtomicType.CellMutability mut) {
        assert (rest != null);
        BCellField[] cellFields = new BCellField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            BCellField cellField;
            Field field = fields[i];
            cellFields[i] = cellField = BCellField.from(env, field, mut);
        }
        SemType restCell = Builder.getCellContaining(env, Core.union(rest, Builder.getUndefType()), Core.isNever(rest) ? CellAtomicType.CellMutability.CELL_MUT_NONE : mut);
        return this.define(env, cellFields, restCell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SemType define(Env env, BCellField[] cellFields, SemType rest) {
        String[] names = new String[cellFields.length];
        SemType[] types2 = new SemType[cellFields.length];
        this.sortAndSplitFields(cellFields, names, types2);
        MappingAtomicType atomicType = new MappingAtomicType(names, types2, rest);
        try {
            Atom atom;
            this.lock.lock();
            RecAtom rec = this.rec;
            if (rec != null) {
                atom = rec;
                env.setRecMappingAtomType(rec, atomicType);
            } else {
                atom = env.mappingAtom(atomicType);
            }
            SemType semType = this.createSemType(env, atom);
            return semType;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void sortAndSplitFields(BCellField[] fields, String[] names, SemType[] types2) {
        assert (fields.length == names.length && fields.length == types2.length);
        Arrays.sort(fields, Comparator.comparing(field -> field.name));
        for (int i = 0; i < fields.length; ++i) {
            names[i] = fields[i].name;
            types2[i] = fields[i].type;
        }
    }

    record BCellField(String name, SemType type) {
        static BCellField from(Env env, Field field, CellAtomicType.CellMutability mut) {
            SemType type = field.ty;
            SemType cellType = Builder.getCellContaining(env, field.optional ? Core.union(type, Builder.getUndefType()) : type, field.readonly ? CellAtomicType.CellMutability.CELL_MUT_NONE : mut);
            BCellField cellField = new BCellField(field.name, cellType);
            return cellField;
        }
    }

    public record Field(String name, SemType ty, boolean readonly, boolean optional) {
    }
}

