/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.MappingDefinition;

public record Member(String name, SemType valueTy, Kind kind, Visibility visibility, boolean immutable) {

    public static enum Kind {
        Field,
        Method;

        private static final MappingDefinition.Field FIELD;
        private static final MappingDefinition.Field METHOD;

        public MappingDefinition.Field field() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> FIELD;
                case 1 -> METHOD;
            };
        }

        static {
            FIELD = new MappingDefinition.Field("kind", Builder.getStringConst("field"), true, false);
            METHOD = new MappingDefinition.Field("kind", Builder.getStringConst("method"), true, false);
        }
    }

    public static enum Visibility {
        Public,
        Private;

        private static final SemType PUBLIC_TAG;
        private static final MappingDefinition.Field PUBLIC;
        private static final SemType PRIVATE_TAG;
        private static final MappingDefinition.Field PRIVATE;
        static final MappingDefinition.Field ALL;

        public MappingDefinition.Field field() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> PUBLIC;
                case 1 -> PRIVATE;
            };
        }

        static {
            PUBLIC_TAG = Builder.getStringConst("public");
            PUBLIC = new MappingDefinition.Field("visibility", PUBLIC_TAG, true, false);
            PRIVATE_TAG = Builder.getStringConst("private");
            PRIVATE = new MappingDefinition.Field("visibility", PRIVATE_TAG, true, false);
            ALL = new MappingDefinition.Field("visibility", Core.union(PRIVATE_TAG, PUBLIC_TAG), true, false);
        }
    }
}

