/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.MappingDefinition;
import io.ballerina.runtime.internal.types.semtype.Member;
import io.ballerina.runtime.internal.types.semtype.ObjectQualifiers;
import java.util.List;
import java.util.stream.Stream;

public class ObjectDefinition
extends Definition {
    private final MappingDefinition mappingDefinition = new MappingDefinition();

    @Override
    public SemType getSemType(Env env) {
        return this.objectContaining(this.mappingDefinition.getSemType(env));
    }

    public SemType define(Env env, ObjectQualifiers qualifiers, List<Member> members, CellAtomicType.CellMutability mut) {
        Stream<MappingDefinition.Field> memberStream = members.stream().map(member -> ObjectDefinition.memberField(env, member, qualifiers.readonly()));
        Stream<MappingDefinition.Field> qualifierStream = Stream.of(qualifiers.field(env));
        SemType mappingType = this.mappingDefinition.define(env, (MappingDefinition.BCellField[])Stream.concat(memberStream, qualifierStream).map(field -> MappingDefinition.BCellField.from(env, field, mut)).toArray(MappingDefinition.BCellField[]::new), this.restMemberType(env, mut, qualifiers.readonly()));
        return this.objectContaining(mappingType);
    }

    private SemType objectContaining(SemType mappingType) {
        Bdd mappingSubTypeData = (Bdd)Core.subTypeData(mappingType, BasicTypeCode.BT_MAPPING);
        return Core.createBasicSemType(BasicTypeCode.BT_OBJECT, mappingSubTypeData);
    }

    private SemType restMemberType(Env env, CellAtomicType.CellMutability mut, boolean readonly) {
        MappingDefinition fieldDefn = new MappingDefinition();
        SemType fieldMemberType = fieldDefn.defineMappingTypeWrapped(env, new MappingDefinition.Field[]{new MappingDefinition.Field("value", readonly ? Builder.getReadonlyType() : Builder.getValType(), readonly, false), Member.Kind.Field.field(), Member.Visibility.ALL}, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        MappingDefinition methodDefn = new MappingDefinition();
        SemType methodMemberType = methodDefn.defineMappingTypeWrapped(env, new MappingDefinition.Field[]{new MappingDefinition.Field("value", Builder.getFunctionType(), true, false), Member.Kind.Method.field(), Member.Visibility.ALL}, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        return Builder.getCellContaining(env, Core.union(fieldMemberType, methodMemberType), mut);
    }

    private static MappingDefinition.Field memberField(Env env, Member member, boolean immutableObject) {
        MappingDefinition md = new MappingDefinition();
        SemType semtype = md.defineMappingTypeWrapped(env, new MappingDefinition.Field[]{new MappingDefinition.Field("value", member.valueTy(), member.immutable(), false), member.kind().field(), member.visibility().field()}, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_LIMITED);
        return new MappingDefinition.Field(member.name(), semtype, immutableObject | member.immutable(), false);
    }

    public static SemType distinct(int distinctId) {
        assert (distinctId >= 0);
        BddNode bdd = BddNode.bddAtom(RecAtom.createDistinctRecAtom(-distinctId - 1));
        return Core.createBasicSemType(BasicTypeCode.BT_OBJECT, bdd);
    }
}

