/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.MappingDefinition;

public record ObjectQualifiers(boolean isolated, boolean readonly, NetworkQualifier networkQualifier) {
    public MappingDefinition.Field field(Env env) {
        MappingDefinition md = new MappingDefinition();
        MappingDefinition.Field isolatedField = new MappingDefinition.Field("isolated", this.isolated ? Builder.getBooleanConst(true) : Builder.getBooleanType(), true, false);
        MappingDefinition.Field networkField = this.networkQualifier.field();
        SemType ty = md.defineMappingTypeWrapped(env, new MappingDefinition.Field[]{isolatedField, networkField}, Builder.getNeverType(), CellAtomicType.CellMutability.CELL_MUT_NONE);
        return new MappingDefinition.Field("$qualifiers", ty, true, false);
    }

    public static enum NetworkQualifier {
        Client,
        Service,
        None;

        private static final SemType CLIENT_TAG;
        private static final MappingDefinition.Field CLIENT;
        private static final SemType SERVICE_TAG;
        private static final MappingDefinition.Field SERVICE;
        private static final MappingDefinition.Field NONE;

        private MappingDefinition.Field field() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> CLIENT;
                case 1 -> SERVICE;
                case 2 -> NONE;
            };
        }

        static {
            CLIENT_TAG = Builder.getStringConst("client");
            CLIENT = new MappingDefinition.Field("network", CLIENT_TAG, true, false);
            SERVICE_TAG = Builder.getStringConst("service");
            SERVICE = new MappingDefinition.Field("network", SERVICE_TAG, true, false);
            NONE = new MappingDefinition.Field("network", Core.union(CLIENT_TAG, SERVICE_TAG), true, false);
        }
    }
}

