/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.SemType;

public final class SemTypeHelper {
    private SemTypeHelper() {
    }

    public static String stringRepr(SemType ty) {
        return "all[" + SemTypeHelper.bitSetRepr(ty.all()) + "] some [" + SemTypeHelper.bitSetRepr(ty.some()) + "]";
    }

    public static String bitSetRepr(int bits) {
        StringBuilder sb = new StringBuilder();
        SemTypeHelper.appendBitSetRepr(sb, bits, 0, "NIL");
        SemTypeHelper.appendBitSetRepr(sb, bits, 1, "BOOLEAN");
        SemTypeHelper.appendBitSetRepr(sb, bits, 2, "INT");
        SemTypeHelper.appendBitSetRepr(sb, bits, 3, "FLOAT");
        SemTypeHelper.appendBitSetRepr(sb, bits, 4, "DECIMAL");
        SemTypeHelper.appendBitSetRepr(sb, bits, 5, "STRING");
        SemTypeHelper.appendBitSetRepr(sb, bits, 6, "ERROR");
        SemTypeHelper.appendBitSetRepr(sb, bits, 7, "TYPE_DESC");
        SemTypeHelper.appendBitSetRepr(sb, bits, 8, "HANDLE");
        SemTypeHelper.appendBitSetRepr(sb, bits, 10, "REGEXP");
        SemTypeHelper.appendBitSetRepr(sb, bits, 9, "FUNCTION");
        SemTypeHelper.appendBitSetRepr(sb, bits, 11, "FUTURE");
        SemTypeHelper.appendBitSetRepr(sb, bits, 12, "STREAM");
        SemTypeHelper.appendBitSetRepr(sb, bits, 13, "LIST");
        SemTypeHelper.appendBitSetRepr(sb, bits, 14, "MAPPING");
        SemTypeHelper.appendBitSetRepr(sb, bits, 15, "TABLE");
        SemTypeHelper.appendBitSetRepr(sb, bits, 16, "XML");
        SemTypeHelper.appendBitSetRepr(sb, bits, 17, "OBJECT");
        SemTypeHelper.appendBitSetRepr(sb, bits, 18, "CELL");
        SemTypeHelper.appendBitSetRepr(sb, bits, 19, "UNDEF");
        return sb.toString();
    }

    private static void appendBitSetRepr(StringBuilder sb, int bits, int index, String name) {
        int mask = 1 << index;
        if ((bits & mask) != 0) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(name).append(" ");
        }
    }
}

