/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddAllOrNothing;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.BXmlSubType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class XmlUtils {
    public static final int XML_PRIMITIVE_NEVER = 1;
    public static final int XML_PRIMITIVE_TEXT = 2;
    public static final int XML_PRIMITIVE_ELEMENT_RO = 4;
    public static final int XML_PRIMITIVE_PI_RO = 8;
    public static final int XML_PRIMITIVE_COMMENT_RO = 16;
    public static final int XML_PRIMITIVE_ELEMENT_RW = 32;
    public static final int XML_PRIMITIVE_PI_RW = 64;
    public static final int XML_PRIMITIVE_COMMENT_RW = 128;
    public static final int XML_PRIMITIVE_RO_SINGLETON = 30;
    public static final int XML_PRIMITIVE_RO_MASK = 31;
    public static final int XML_PRIMITIVE_RW_MASK = 224;
    public static final int XML_PRIMITIVE_SINGLETON = 254;
    public static final int XML_PRIMITIVE_ALL_MASK = 255;
    public static final SubTypeData XML_SUBTYPE_TOP = XmlUtils.from(255, BddAllOrNothing.ALL);
    public static final SubType XML_SUBTYPE_RO = BXmlSubType.createDelegate(31, BddNode.bddAtom(RecAtom.createUnBlockedRecAtom(30)));

    private XmlUtils() {
    }

    public static SemType xmlSingleton(int primitive) {
        if (XmlSingletonCache.isCached(primitive)) {
            return XmlSingletonCache.get(primitive);
        }
        return XmlUtils.createXmlSingleton(primitive);
    }

    private static SemType createXmlSingleton(int primitive) {
        return XmlUtils.createXmlSemtype(XmlUtils.createXmlSubtype(primitive, BddAllOrNothing.NOTHING));
    }

    private static SemType createXmlSemtype(SubTypeData xmlSubtype) {
        if (xmlSubtype instanceof AllOrNothing) {
            return xmlSubtype == AllOrNothing.ALL ? Builder.getXmlType() : Builder.getNeverType();
        }
        assert (xmlSubtype instanceof BXmlSubType) : "subtype must be wrapped by delegate by now";
        return Builder.basicSubType(BasicTypeCode.BT_XML, (SubType)((Object)xmlSubtype));
    }

    private static SubTypeData createXmlSubtype(int primitives, Bdd sequence) {
        int p = primitives & 0xFF;
        if (XmlUtils.primitiveShouldIncludeNever(p)) {
            p |= 1;
        }
        if (sequence == BddAllOrNothing.ALL && p == 255) {
            return AllOrNothing.ALL;
        }
        if (sequence == BddAllOrNothing.NOTHING && p == 0) {
            return AllOrNothing.NOTHING;
        }
        return XmlUtils.from(p, sequence);
    }

    private static boolean primitiveShouldIncludeNever(int primitive) {
        return (primitive & 2) == 2;
    }

    public static SubTypeData from(int primitives, Bdd sequence) {
        return BXmlSubType.createDelegate(primitives, sequence);
    }

    public static SemType xmlSequence(SemType constituentType) {
        assert (Core.isSubtypeSimple(constituentType, Builder.getXmlType())) : "It is a precondition that constituentType is a subtype of XML";
        if (Core.isNever(constituentType)) {
            return XmlUtils.xmlSequence(XmlUtils.xmlSingleton(1));
        }
        if (constituentType.some() == 0) {
            assert (Core.isNever(Core.diff(Builder.getXmlType(), constituentType)));
            return constituentType;
        }
        SubType xmlSubType = Core.getComplexSubtypeData(constituentType, BasicTypeCode.BT_XML);
        if (!xmlSubType.isAll() && !xmlSubType.isNothing()) {
            xmlSubType = XmlUtils.makeXmlSequence((BXmlSubType)xmlSubType);
        }
        return XmlUtils.createXmlSemtype((SubTypeData)((Object)xmlSubType));
    }

    private static SubType makeXmlSequence(BXmlSubType xmlSubType) {
        int primitives = xmlSubType.primitives() | 1;
        int atom = xmlSubType.primitives() & 0xFE;
        Bdd sequence = (Bdd)xmlSubType.bdd().union(BddNode.bddAtom(RecAtom.createRecAtom(atom)));
        return BXmlSubType.createDelegate(primitives, sequence);
    }

    private static final class XmlSingletonCache {
        private static final Map<Integer, SemType> CACHE = new ConcurrentHashMap<Integer, SemType>();

        private XmlSingletonCache() {
        }

        private static boolean isCached(int primitive) {
            return Integer.bitCount(primitive) < 3;
        }

        private static SemType get(int primitive) {
            return CACHE.computeIfAbsent(primitive, XmlUtils::createXmlSingleton);
        }
    }
}

