/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFuture;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.scheduling.AsyncUtils;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BFutureType;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class FutureValue
implements BFuture,
RefValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getFutureType();
    public Strand strand;
    Type type;
    public final CompletableFuture<Object> completableFuture;
    private final BTypedesc typedesc;
    private final AtomicBoolean waited;

    public FutureValue(Strand strand, Type constraint) {
        this.strand = strand;
        this.type = new BFutureType(constraint);
        this.typedesc = new TypedescValueImpl(this.type);
        this.completableFuture = new CompletableFuture();
        this.waited = new AtomicBoolean();
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",", "{", "}");
        boolean isDone = this.completableFuture.isDone();
        sj.add("isDone:" + this.completableFuture.isDone());
        Object result = this.completableFuture.getNow(null);
        if (isDone) {
            if (result instanceof BError) {
                BError error2 = result;
                sj.add("panic:" + error2.getLocalizedMessage());
            } else {
                sj.add("result:" + StringUtils.getStringVal(this.completableFuture.getNow(null), parent));
            }
        }
        return "future " + String.valueOf(sj);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BTypedesc getTypedesc() {
        return this.typedesc;
    }

    @Override
    public void cancel() {
        this.strand.cancelled = true;
        if (this.strand.workerChannelMap != null) {
            this.strand.workerChannelMap.cancel();
        }
    }

    @Override
    public Object get() {
        return AsyncUtils.handleWait(Scheduler.getStrand(), this.completableFuture);
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public boolean isPanic() {
        return this.completableFuture.isCompletedExceptionally();
    }

    public boolean getAndSetWaited() {
        return this.waited.getAndSet(true);
    }
}

