/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BStreamingJson;
import io.ballerina.runtime.internal.json.JsonDataSource;
import io.ballerina.runtime.internal.json.JsonGenerator;
import io.ballerina.runtime.internal.json.JsonInternalUtils;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.IteratorValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class StreamingJsonValue
extends ArrayValueImpl
implements BStreamingJson {
    JsonDataSource datasource;

    @Deprecated
    public StreamingJsonValue(JsonDataSource datasource) {
        super(new BArrayType(new BMapType(PredefinedTypes.TYPE_JSON)));
        this.datasource = datasource;
    }

    @Override
    public void add(long index, Object value2) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        super.add(index, value2);
    }

    @Override
    public void append(Object value2) {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        super.append(value2);
    }

    @Override
    public Object getRefValue(long index) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        return super.getRefValue(index);
    }

    public void serialize(JsonGenerator gen) {
        try {
            gen.writeStartArray();
            for (int i = 0; i < this.size; ++i) {
                gen.serialize(this.refValues[i]);
            }
            while (this.datasource.hasNext()) {
                gen.serialize(this.datasource.next());
            }
            gen.writeEndArray();
            gen.flush();
        }
        catch (IOException e) {
            throw JsonInternalUtils.createJsonConversionError(e, "error occurred while serializing data");
        }
    }

    @Override
    public void serialize(Writer writer) {
        try (JsonGenerator gen = new JsonGenerator(writer);){
            this.serialize(gen);
        }
        catch (IOException e) {
            throw JsonInternalUtils.createJsonConversionError(e, "error occurred while serializing data");
        }
    }

    @Override
    public void serialize(OutputStream outputStream) {
        try (JsonGenerator gen = new JsonGenerator(outputStream);){
            this.serialize(gen);
        }
        catch (IOException e) {
            throw JsonInternalUtils.createJsonConversionError(e, "error occurred while serializing data");
        }
    }

    @Override
    public Object[] getValues() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.refValues;
    }

    @Override
    public String toString() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return super.toString();
    }

    @Override
    public String stringValue(BLink parent) {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return super.stringValue(parent);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public int size() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.size;
    }

    void appendToCache(Object value2) {
        super.add((long)this.size, value2);
    }

    @Override
    public String getJSONString() {
        this.buildDatasource();
        return super.getJSONString();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        this.buildDatasource();
        return super.copy(refs);
    }

    private void buildDatasource() {
        try {
            while (this.datasource.hasNext()) {
                this.appendToCache(this.datasource.next());
            }
        }
        catch (Throwable t) {
            throw JsonInternalUtils.createJsonConversionError(t, "error occurred while building JSON");
        }
    }

    @Override
    public IteratorValue<Object> getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    static class StreamingJsonIterator
    implements IteratorValue<Object> {
        StreamingJsonValue array;
        long cursor = 0L;

        StreamingJsonIterator(StreamingJsonValue value2) {
            this.array = value2;
        }

        @Override
        public Object next() {
            Object value2;
            if (this.cursor < (long)this.array.size) {
                value2 = this.array.get(this.cursor);
            } else {
                value2 = this.array.datasource.next();
                this.array.appendToCache(value2);
            }
            ++this.cursor;
            return value2;
        }

        @Override
        public boolean hasNext() {
            if (this.cursor < (long)this.array.size) {
                return true;
            }
            return this.array.datasource.hasNext();
        }
    }
}

