/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.types.BStringType;
import io.ballerina.runtime.internal.values.CharIterator;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.SimpleValue;
import java.util.Map;
import java.util.Optional;

public abstract class StringValue
implements BString,
SimpleValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getStringType();
    private static final BStringType STRING_TYPE = new BStringType("string", new Module(null, null, null));
    final String value;
    final boolean isNonBmp;
    private BStringType type;
    private boolean shapeCalculated = false;

    protected StringValue(String value2, boolean isNonBmp) {
        this.value = value2;
        this.isNonBmp = isNonBmp;
        this.type = STRING_TYPE;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    public IteratorValue<String> getIterator() {
        return new CharIterator(this);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String stringValue(BLink parent) {
        return this.value;
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "\"" + String.valueOf(this) + "\"";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.informalStringValue(parent);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object str) {
        if (str == this) {
            return true;
        }
        if (str instanceof BString) {
            BString bString = (BString)str;
            return bString.getValue().equals(this.value);
        }
        return false;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        if (!this.shapeCalculated) {
            this.type = BStringType.singletonType(this.value);
        }
        return Optional.of(this.type.shape());
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }
}

