/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.xml;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.internal.values.XmlComment;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.values.XmlPi;
import io.ballerina.runtime.internal.values.XmlQName;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlText;
import io.ballerina.runtime.internal.xml.XmlFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlTreeBuilder {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private XMLStreamReader xmlStreamReader;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Deque<BXmlSequence> seqDeque = new ArrayDeque<BXmlSequence>();
    private final Deque<List<BXml>> siblingDeque = new ArrayDeque<List<BXml>>();

    public XmlTreeBuilder(String str) {
        this(new StringReader(str));
    }

    public XmlTreeBuilder(Reader stringReader) {
        ArrayList<BXml> siblings = new ArrayList<BXml>();
        this.siblingDeque.push(siblings);
        this.seqDeque.push(new XmlSequence(siblings));
        try {
            this.xmlStreamReader = XML_INPUT_FACTORY.createXMLStreamReader(stringReader);
        }
        catch (XMLStreamException e) {
            this.handleXMLStreamException(e);
        }
    }

    private void handleXMLStreamException(Exception e) {
        String reason;
        String string2 = reason = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
        if (reason == null) {
            throw ErrorCreator.createError(StringUtils.fromString("failed to parse xml"));
        }
        throw ErrorCreator.createError(StringUtils.fromString("failed to parse xml: " + reason));
    }

    public BXml parse() {
        boolean readNext = false;
        try {
            block12: while (this.xmlStreamReader.hasNext()) {
                int next2;
                if (readNext) {
                    readNext = false;
                    next2 = this.xmlStreamReader.getEventType();
                } else {
                    next2 = this.xmlStreamReader.next();
                }
                switch (next2) {
                    case 1: {
                        this.readElement(this.xmlStreamReader);
                        continue block12;
                    }
                    case 2: {
                        this.endElement();
                        continue block12;
                    }
                    case 3: {
                        this.readPI(this.xmlStreamReader);
                        continue block12;
                    }
                    case 5: {
                        this.readComment(this.xmlStreamReader);
                        continue block12;
                    }
                    case 12: {
                        this.readCData(this.xmlStreamReader);
                        continue block12;
                    }
                    case 4: {
                        this.readText(this.xmlStreamReader);
                        readNext = true;
                        continue block12;
                    }
                    case 8: {
                        return this.buildDocument();
                    }
                    case 11: {
                        this.handleDTD(this.xmlStreamReader);
                        continue block12;
                    }
                }
                assert (false);
            }
        }
        catch (Exception e) {
            this.handleXMLStreamException(e);
        }
        return null;
    }

    private void handleDTD(XMLStreamReader xmlStreamReader) {
    }

    private void readPI(XMLStreamReader xmlStreamReader) {
        XmlPi xmlItem = (XmlPi)XmlFactory.createXMLProcessingInstruction(xmlStreamReader.getPITarget(), xmlStreamReader.getPIData());
        this.siblingDeque.peek().add(xmlItem);
    }

    private void readCData(XMLStreamReader xmlStreamReader) {
        this.siblingDeque.peek().add(new XmlText(xmlStreamReader.getText()));
    }

    private void readText(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        StringBuilder textBuilder = new StringBuilder();
        while (xmlStreamReader.getEventType() == 4) {
            textBuilder.append(xmlStreamReader.getText());
            xmlStreamReader.next();
        }
        this.siblingDeque.peek().add(new XmlText(textBuilder.toString()));
    }

    private void readComment(XMLStreamReader xmlStreamReader) {
        XmlComment xmlComment = (XmlComment)XmlFactory.createXMLComment(xmlStreamReader.getText());
        this.siblingDeque.peek().add(xmlComment);
    }

    private BXmlSequence buildDocument() {
        this.siblingDeque.pop();
        return this.seqDeque.pop();
    }

    private void endElement() {
        this.siblingDeque.pop();
        this.seqDeque.pop();
    }

    private void readElement(XMLStreamReader xmlStreamReader) {
        QName elemName = xmlStreamReader.getName();
        XmlQName name = new XmlQName(elemName.getLocalPart(), elemName.getNamespaceURI(), elemName.getPrefix());
        XmlItem xmlItem = (XmlItem)XmlFactory.createXMLElement((BXmlQName)name, name, null);
        this.seqDeque.push(xmlItem.getChildrenSeq());
        this.siblingDeque.peek().add(xmlItem);
        this.populateAttributeMap(xmlStreamReader, xmlItem, elemName);
        this.siblingDeque.push(xmlItem.getChildrenSeq().getChildrenList());
    }

    private void populateAttributeMap(XMLStreamReader xmlStreamReader, XmlItem xmlItem, QName elemName) {
        BMap attributesMap = xmlItem.getAttributesMap();
        HashSet<QName> usedNS = new HashSet<QName>();
        int count = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            QName attributeName = xmlStreamReader.getAttributeName(i);
            attributesMap.put(StringUtils.fromString(attributeName.toString()), StringUtils.fromString(xmlStreamReader.getAttributeValue(i)));
            if (attributeName.getPrefix().isEmpty()) continue;
            usedNS.add(attributeName);
        }
        if (!elemName.getPrefix().isEmpty()) {
            usedNS.add(elemName);
        }
        for (QName qName : usedNS) {
            String prefix = qName.getPrefix();
            String namespaceURI = qName.getNamespaceURI();
            if (namespaceURI.isEmpty()) {
                namespaceURI = this.namespaces.getOrDefault(prefix, "");
            }
            BString xmlnsPrefix = StringUtils.fromString("{http://www.w3.org/2000/xmlns/}" + prefix);
            attributesMap.put(xmlnsPrefix, StringUtils.fromString(namespaceURI));
        }
        int namespaceCount = xmlStreamReader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String uri = xmlStreamReader.getNamespaceURI(i);
            String prefix = xmlStreamReader.getNamespacePrefix(i);
            if (prefix == null || prefix.isEmpty()) {
                attributesMap.put(XmlItem.XMLNS_PREFIX, StringUtils.fromString(uri));
                continue;
            }
            attributesMap.put(StringUtils.fromString("{http://www.w3.org/2000/xmlns/}" + prefix), StringUtils.fromString(uri));
        }
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

