/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.transactions;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.transactions.BallerinaTransactionContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class TransactionLocalContext {
    private final String globalTransactionId;
    private final String url;
    private final String protocol;
    private int transactionLevel;
    private final Map<String, Integer> allowedTransactionRetryCounts;
    private final Map<String, Integer> currentTransactionRetryCounts;
    private Map<String, BallerinaTransactionContext> transactionContextStore;
    private final Deque<String> transactionBlockIdStack;
    private final Deque<TransactionFailure> transactionFailure;
    private static final TransactionResourceManager TRANSACTION_RESOURCE_MANAGER = TransactionResourceManager.getInstance();
    private boolean isResourceParticipant;
    private Object rollbackOnlyError;
    private Object transactionData;
    private final BArray transactionId;
    private boolean isTransactional;

    private TransactionLocalContext(String globalTransactionId, String url, String protocol, Object infoRecord) {
        this.globalTransactionId = globalTransactionId;
        this.url = url;
        this.protocol = protocol;
        this.transactionLevel = 0;
        this.allowedTransactionRetryCounts = new HashMap<String, Integer>();
        this.currentTransactionRetryCounts = new HashMap<String, Integer>();
        this.transactionContextStore = new HashMap<String, BallerinaTransactionContext>();
        this.transactionBlockIdStack = new ArrayDeque<String>();
        this.transactionFailure = new ArrayDeque<TransactionFailure>();
        this.rollbackOnlyError = null;
        this.isTransactional = true;
        this.transactionId = ValueCreator.createArrayValue(globalTransactionId.getBytes());
        this.validateAndPutTransactionInfo(ByteBuffer.wrap((byte[])this.transactionId.getBytes().clone()), infoRecord);
    }

    private void validateAndPutTransactionInfo(ByteBuffer transactionIdBytes, Object infoRecord) {
        if (infoRecord == null) {
            return;
        }
        TransactionLocalContext.TRANSACTION_RESOURCE_MANAGER.transactionInfoMap.put(transactionIdBytes, infoRecord);
    }

    public static TransactionLocalContext createTransactionParticipantLocalCtx(String globalTransactionId, String url, String protocol, Object infoRecord) {
        TransactionLocalContext localContext = new TransactionLocalContext(globalTransactionId, url, protocol, infoRecord);
        localContext.setResourceParticipant(true);
        return localContext;
    }

    public static TransactionLocalContext create(String globalTransactionId, String url, String protocol) {
        return new TransactionLocalContext(globalTransactionId, url, protocol, null);
    }

    public static TransactionLocalContext create(String globalTransactionId, String url, String protocol, Object infoRecord) {
        return new TransactionLocalContext(globalTransactionId, url, protocol, infoRecord);
    }

    public String getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public String getCurrentTransactionBlockId() {
        return this.transactionBlockIdStack.peek();
    }

    public void addCurrentTransactionBlockId(String blockId) {
        this.transactionBlockIdStack.push(blockId);
    }

    public boolean hasTransactionBlock() {
        return !this.transactionBlockIdStack.isEmpty();
    }

    public String getURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void beginTransactionBlock(String localTransactionID) {
        this.transactionBlockIdStack.push(localTransactionID);
        this.currentTransactionRetryCounts.put(localTransactionID, 0);
        ++this.transactionLevel;
    }

    public void incrementCurrentRetryCount(String localTransactionID) {
        this.currentTransactionRetryCounts.putIfAbsent(localTransactionID, 0);
        this.currentTransactionRetryCounts.computeIfPresent(localTransactionID, (k, v) -> v + 1);
    }

    public BallerinaTransactionContext getTransactionContext(String connectorid) {
        return this.transactionContextStore.get(connectorid);
    }

    public void registerTransactionContext(String connectorid, BallerinaTransactionContext txContext) {
        this.transactionContextStore.put(connectorid, txContext);
    }

    public boolean isRetryAttempt(String transactionId) {
        return this.getCurrentRetryCount(transactionId) > 0;
    }

    public boolean isRetryPossible(Strand context, String transactionId) {
        int allowedRetryCount = this.getAllowedRetryCount(transactionId);
        int currentRetryCount = this.getCurrentRetryCount(transactionId);
        return currentRetryCount < allowedRetryCount || currentRetryCount == 0;
    }

    public void notifyAbortAndClearTransaction(String transactionBlockId) {
        this.transactionContextStore.clear();
        TRANSACTION_RESOURCE_MANAGER.endXATransaction(this.globalTransactionId, transactionBlockId, true);
        TRANSACTION_RESOURCE_MANAGER.notifyAbort(this.globalTransactionId, transactionBlockId);
    }

    public void setRollbackOnlyError(Object error2) {
        this.rollbackOnlyError = error2;
    }

    public Object getRollbackOnly() {
        return this.rollbackOnlyError;
    }

    public void setTransactionData(Object data) {
        this.transactionData = data;
    }

    public Object getTransactionData() {
        return this.transactionData;
    }

    public void removeTransactionInfo() {
        TransactionLocalContext.TRANSACTION_RESOURCE_MANAGER.transactionInfoMap.remove(ByteBuffer.wrap(this.transactionId.getBytes()));
    }

    public void notifyLocalParticipantFailure() {
        String blockId = this.transactionBlockIdStack.peek();
        TRANSACTION_RESOURCE_MANAGER.notifyLocalParticipantFailure(this.globalTransactionId, blockId);
    }

    public void notifyLocalRemoteParticipantFailure() {
        TransactionResourceManager.getInstance().notifyResourceFailure(this.globalTransactionId);
    }

    public int getAllowedRetryCount(String localTransactionID) {
        return this.allowedTransactionRetryCounts.get(localTransactionID);
    }

    private int getCurrentRetryCount(String localTransactionID) {
        return this.currentTransactionRetryCounts.get(localTransactionID);
    }

    private void resetTransactionInfo() {
        this.allowedTransactionRetryCounts.clear();
        this.currentTransactionRetryCounts.clear();
        this.transactionContextStore.clear();
    }

    public void markFailure() {
        this.transactionFailure.push(TransactionFailure.at(-1));
    }

    public TransactionFailure getAndClearFailure() {
        if (this.transactionFailure.isEmpty()) {
            return null;
        }
        TransactionFailure failure = this.transactionFailure.pop();
        this.transactionFailure.clear();
        return failure;
    }

    public TransactionFailure getFailure() {
        if (this.transactionFailure.isEmpty()) {
            return null;
        }
        return this.transactionFailure.peek();
    }

    public boolean isResourceParticipant() {
        return this.isResourceParticipant;
    }

    public void setResourceParticipant(boolean resourceParticipant) {
        this.isResourceParticipant = resourceParticipant;
    }

    public Object getInfoRecord() {
        return TRANSACTION_RESOURCE_MANAGER.getTransactionRecord(this.transactionId);
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional(boolean transactional) {
        this.isTransactional = transactional;
    }

    public Map<String, BallerinaTransactionContext> getTransactionContextStore() {
        return this.transactionContextStore;
    }

    public void setTransactionContextStore(Map<String, BallerinaTransactionContext> transactionContextStore) {
        this.transactionContextStore = transactionContextStore;
    }

    public static class TransactionFailure {
        private final int offendingIp;

        private TransactionFailure(int offendingIp) {
            this.offendingIp = offendingIp;
        }

        private static TransactionFailure at(int offendingIp) {
            return new TransactionFailure(offendingIp);
        }

        public int getOffendingIp() {
            return this.offendingIp;
        }
    }

    public static enum TransactionParticipantType {
        LOCAL_PARTICIPANT,
        REMOTE_PARTICIPANT,
        NON_PARTICIPANT;

    }
}

