/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.transactions;

import com.atomikos.icatch.jta.UserTransactionManager;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.configurable.ConfigMap;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import io.ballerina.runtime.transactions.BallerinaTransactionContext;
import io.ballerina.runtime.transactions.TransactionConstants;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.XIDGenerator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionResourceManager {
    private static TransactionResourceManager transactionResourceManager = null;
    private static UserTransactionManager userTransactionManager = null;
    private static final String ATOMIKOS_LOG_BASE_PROPERTY = "com.atomikos.icatch.log_base_dir";
    private static final String ATOMIKOS_LOG_NAME_PROPERTY = "com.atomikos.icatch.log_base_name";
    private static final String ATOMIKOS_REGISTERED_PROPERTY = "com.atomikos.icatch.registered";
    public static final String TRANSACTION_AUTO_COMMIT_TIMEOUT_KEY = "transactionAutoCommitTimeout";
    public static final String TRANSACTION_CLEANUP_TIMEOUT_KEY = "transactionCleanupTimeout";
    private static final Logger LOG = LoggerFactory.getLogger(TransactionResourceManager.class);
    private final Map<String, List<BallerinaTransactionContext>> resourceRegistry = new HashMap<String, List<BallerinaTransactionContext>>();
    private Map<String, Transaction> trxRegistry;
    private Map<String, Xid> xidRegistry;
    private final Map<String, List<BFunctionPointer>> committedFuncRegistry = new HashMap<String, List<BFunctionPointer>>();
    private final Map<String, List<BFunctionPointer>> abortedFuncRegistry = new HashMap<String, List<BFunctionPointer>>();
    private final Set<String> failedResourceParticipantSet = new ConcurrentSkipListSet<String>();
    private final Set<String> failedLocalParticipantSet = new ConcurrentSkipListSet<String>();
    private final ConcurrentMap<String, Set<String>> localParticipants = new ConcurrentHashMap<String, Set<String>>();
    private final boolean transactionManagerEnabled;
    private static final PrintStream STDERR = System.err;
    final Map<ByteBuffer, Object> transactionInfoMap = new ConcurrentHashMap<ByteBuffer, Object>();

    private TransactionResourceManager() {
        this.transactionManagerEnabled = this.getTransactionManagerEnabled();
        if (this.transactionManagerEnabled) {
            this.trxRegistry = new HashMap<String, Transaction>();
            this.setLogProperties();
            userTransactionManager = new UserTransactionManager();
        } else {
            this.xidRegistry = new HashMap<String, Xid>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionResourceManager getInstance() {
        if (transactionResourceManager != null) return transactionResourceManager;
        Class<TransactionResourceManager> clazz = TransactionResourceManager.class;
        synchronized (TransactionResourceManager.class) {
            if (transactionResourceManager != null) return transactionResourceManager;
            transactionResourceManager = new TransactionResourceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return transactionResourceManager;
        }
    }

    private void setLogProperties() {
        Path transactionLogDirectory;
        Path projectRoot = Path.of(RuntimeUtils.USER_DIR, new String[0]);
        Object logDir = this.getTransactionLogDirectory();
        Path logDirPath = Path.of((String)logDir, new String[0]);
        if (!logDirPath.isAbsolute()) {
            logDir = projectRoot.toAbsolutePath().toString() + File.separatorChar + (String)logDir;
            transactionLogDirectory = Path.of((String)logDir, new String[0]);
        } else {
            transactionLogDirectory = logDirPath;
        }
        if (!Files.exists(transactionLogDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(transactionLogDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                STDERR.println("error: failed to create transaction log directory in " + (String)logDir);
            }
        }
        System.setProperty(ATOMIKOS_LOG_BASE_PROPERTY, (String)logDir);
        System.setProperty(ATOMIKOS_LOG_NAME_PROPERTY, "transaction_recovery");
        System.setProperty(ATOMIKOS_REGISTERED_PROPERTY, "not-registered");
    }

    public boolean getTransactionManagerEnabled() {
        VariableKey managerEnabledKey = new VariableKey(TransactionConstants.TRANSACTION_PACKAGE_ID, "managerEnabled", PredefinedTypes.TYPE_BOOLEAN, false);
        if (!ConfigMap.containsKey(managerEnabledKey)) {
            return false;
        }
        return (Boolean)ConfigMap.get(managerEnabledKey);
    }

    private String getTransactionLogDirectory() {
        VariableKey logKey = new VariableKey(TransactionConstants.TRANSACTION_PACKAGE_ID, "logBase", PredefinedTypes.TYPE_STRING, false);
        if (!ConfigMap.containsKey(logKey)) {
            return "transaction_log_dir";
        }
        return ((BString)ConfigMap.get(logKey)).getValue();
    }

    public static int getTransactionAutoCommitTimeout() {
        VariableKey transactionAutoCommitTimeoutKey = new VariableKey(TransactionConstants.TRANSACTION_PACKAGE_ID, TRANSACTION_AUTO_COMMIT_TIMEOUT_KEY, PredefinedTypes.TYPE_INT, false);
        if (!ConfigMap.containsKey(transactionAutoCommitTimeoutKey)) {
            return 120;
        }
        Object configValue = ConfigMap.get(transactionAutoCommitTimeoutKey);
        if (configValue == null) {
            return 120;
        }
        return TransactionResourceManager.parseTimeoutValue(configValue, 120);
    }

    public static int getTransactionCleanupTimeout() {
        VariableKey transactionCleanupTimeoutKey = new VariableKey(TransactionConstants.TRANSACTION_PACKAGE_ID, TRANSACTION_CLEANUP_TIMEOUT_KEY, PredefinedTypes.TYPE_INT, false);
        if (!ConfigMap.containsKey(transactionCleanupTimeoutKey)) {
            return 600;
        }
        Object configValue = ConfigMap.get(transactionCleanupTimeoutKey);
        if (configValue == null) {
            return 600;
        }
        return TransactionResourceManager.parseTimeoutValue(configValue, 600);
    }

    private static int parseTimeoutValue(Object configValue, int defaultValue) {
        if (!(configValue instanceof Number)) {
            return defaultValue;
        }
        Number number = (Number)configValue;
        int timeoutValue = number.intValue();
        if (timeoutValue <= 0) {
            return defaultValue;
        }
        return timeoutValue;
    }

    public void register(String transactionId, String transactionBlockId, BallerinaTransactionContext txContext) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        this.resourceRegistry.computeIfAbsent(combinedId, resourceList -> new ArrayList()).add(txContext);
    }

    public void registerCommittedFunction(String transactionBlockId, BFunctionPointer fpValue) {
        if (fpValue != null) {
            this.committedFuncRegistry.computeIfAbsent(transactionBlockId, list -> new ArrayList()).add(fpValue);
        }
    }

    public void registerAbortedFunction(String transactionBlockId, BFunctionPointer fpValue) {
        if (fpValue != null) {
            this.abortedFuncRegistry.computeIfAbsent(transactionBlockId, list -> new ArrayList()).add(fpValue);
        }
    }

    public void registerParticipation(String gTransactionId, String transactionBlockId) {
        this.localParticipants.computeIfAbsent(gTransactionId, gid -> new ConcurrentSkipListSet()).add(transactionBlockId);
        TransactionLocalContext transactionLocalContext = Scheduler.getStrand().currentTrxContext;
        transactionLocalContext.beginTransactionBlock(transactionBlockId);
    }

    public boolean prepare(String transactionId, String transactionBlockId) {
        this.endXATransaction(transactionId, transactionBlockId, false);
        if (this.transactionManagerEnabled) {
            return true;
        }
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            Xid xid = this.xidRegistry.get(combinedId);
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (xaResource == null) continue;
                    xaResource.prepare(xid);
                }
                catch (Exception e) {
                    LOG.error("error at transaction prepare phase in transaction " + transactionId + ":" + e.getMessage(), e);
                    return false;
                }
            }
        }
        boolean status = true;
        if (this.failedResourceParticipantSet.contains(transactionId) || this.failedLocalParticipantSet.contains(transactionId)) {
            status = false;
        }
        LOG.info(String.format("Transaction prepare (participants): %s", status ? "success" : "failed"));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyCommit(String transactionId, String transactionBlockId) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        boolean commitSuccess = true;
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            if (this.transactionManagerEnabled) {
                Transaction trx = this.trxRegistry.get(combinedId);
                try {
                    if (trx != null) {
                        trx.commit();
                    }
                }
                catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                    LOG.error("error when committing transaction " + transactionId + ":" + e.getMessage(), e);
                    commitSuccess = false;
                }
            }
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (this.transactionManagerEnabled && xaResource == null) {
                        ctx.commit();
                        continue;
                    }
                    if (xaResource != null) {
                        Xid xid = this.xidRegistry.get(combinedId);
                        xaResource.commit(xid, false);
                        continue;
                    }
                    ctx.commit();
                }
                catch (Exception e) {
                    LOG.error("error when committing transaction " + transactionId + ":" + e.getMessage(), e);
                    commitSuccess = false;
                }
                finally {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {
                        LOG.error("error when committing and releasing resources for transaction " + transactionId + ":" + e.getMessage(), e);
                        commitSuccess = false;
                    }
                }
            }
        }
        return commitSuccess;
    }

    public void cleanTransaction(String transactionId, String transactionBlockId) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        this.removeContextsFromRegistry(combinedId, transactionId);
        this.failedResourceParticipantSet.remove(transactionId);
        this.failedLocalParticipantSet.remove(transactionId);
        this.localParticipants.remove(transactionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyAbort(String transactionId, String transactionBlockId) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        boolean abortSuccess = true;
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            if (this.transactionManagerEnabled) {
                Transaction trx = this.trxRegistry.get(combinedId);
                try {
                    if (trx != null) {
                        trx.rollback();
                    }
                }
                catch (SystemException e) {
                    LOG.error("error when aborting transaction " + transactionId + ":" + e.getMessage(), e);
                    abortSuccess = false;
                }
            }
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (this.transactionManagerEnabled && xaResource == null) {
                        ctx.rollback();
                        continue;
                    }
                    Xid xid = this.xidRegistry.get(combinedId);
                    if (xaResource != null) {
                        ctx.getXAResource().rollback(xid);
                        continue;
                    }
                    ctx.rollback();
                }
                catch (Exception e) {
                    LOG.error("error when aborting the transaction " + transactionId + ":" + e.getMessage(), e);
                    abortSuccess = false;
                }
                finally {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {
                        LOG.error("error when aborting and releasing resources for transaction " + transactionId + ":" + e.getMessage(), e);
                        abortSuccess = false;
                    }
                }
            }
        }
        this.removeContextsFromRegistry(combinedId, transactionId);
        this.failedResourceParticipantSet.remove(transactionId);
        this.failedLocalParticipantSet.remove(transactionId);
        this.localParticipants.remove(transactionId);
        return abortSuccess;
    }

    public void beginXATransaction(String transactionId, String transactionBlockId, XAResource xaResource) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        if (this.transactionManagerEnabled) {
            Transaction trx = this.trxRegistry.get(combinedId);
            try {
                if (trx == null) {
                    userTransactionManager.begin();
                    trx = userTransactionManager.getTransaction();
                    this.trxRegistry.put(combinedId, trx);
                }
            }
            catch (NotSupportedException | SystemException e) {
                LOG.error("error in initiating transaction " + transactionId + ":" + e.getMessage(), e);
            }
        } else {
            Xid xid = this.xidRegistry.get(combinedId);
            if (xid == null) {
                xid = XIDGenerator.createXID();
                this.xidRegistry.put(combinedId, xid);
            }
            try {
                xaResource.start(xid, 0);
            }
            catch (XAException e) {
                LOG.error("error in starting XA transaction " + transactionId + ":" + e.getMessage(), e);
            }
        }
    }

    public void cleanupTransactionContext() {
        Strand strand = Scheduler.getStrand();
        TransactionLocalContext transactionLocalContext = strand.currentTrxContext;
        transactionLocalContext.removeTransactionInfo();
        strand.removeCurrentTrxContext();
    }

    public boolean getAndClearFailure() {
        return Scheduler.getStrand().currentTrxContext.getAndClearFailure() != null;
    }

    public Object getRollBackOnlyError() {
        TransactionLocalContext transactionLocalContext = Scheduler.getStrand().currentTrxContext;
        return transactionLocalContext.getRollbackOnly();
    }

    public boolean isInTransaction() {
        return Scheduler.getStrand().isInTransaction();
    }

    public void notifyTransactionAbort(String transactionBlockId) {
        Scheduler.getStrand().currentTrxContext.notifyAbortAndClearTransaction(transactionBlockId);
    }

    public BArray getRegisteredRollbackHandlerList() {
        List<BFunctionPointer> abortFunctions = this.abortedFuncRegistry.get(Scheduler.getStrand().currentTrxContext.getGlobalTransactionId());
        if (abortFunctions != null && !abortFunctions.isEmpty()) {
            Collections.reverse(abortFunctions);
            return ValueCreator.createArrayValue(abortFunctions.toArray(), TypeCreator.createArrayType(abortFunctions.get(0).getType()));
        }
        return this.getNillArray();
    }

    public BArray getRegisteredCommitHandlerList() {
        List<BFunctionPointer> commitFunctions = this.committedFuncRegistry.get(Scheduler.getStrand().currentTrxContext.getGlobalTransactionId());
        if (commitFunctions != null && !commitFunctions.isEmpty()) {
            Collections.reverse(commitFunctions);
            return ValueCreator.createArrayValue(commitFunctions.toArray(), TypeCreator.createArrayType(commitFunctions.get(0).getType()));
        }
        return this.getNillArray();
    }

    private BArray getNillArray() {
        return ValueCreator.createArrayValue(TypeCreator.createArrayType(PredefinedTypes.TYPE_NULL));
    }

    public void setContextNonTransactional() {
        TransactionLocalContext localContext = Scheduler.getStrand().currentTrxContext;
        if (localContext != null) {
            localContext.setTransactional(false);
        }
    }

    public void setCurrentTransactionContext(TransactionLocalContext trxCtx) {
        Scheduler.getStrand().setCurrentTransactionContext(trxCtx);
    }

    public TransactionLocalContext getCurrentTransactionContext() {
        return Scheduler.getStrand().currentTrxContext;
    }

    void endXATransaction(String transactionId, String transactionBlockId, boolean abortOnly) {
        block8: {
            String combinedId;
            block7: {
                List<BallerinaTransactionContext> txContextList;
                combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
                if (!this.transactionManagerEnabled) break block7;
                Transaction trx = this.trxRegistry.get(combinedId);
                if (trx == null || (txContextList = this.resourceRegistry.get(combinedId)) == null) break block8;
                for (BallerinaTransactionContext ctx : txContextList) {
                    try {
                        XAResource xaResource = ctx.getXAResource();
                        if (xaResource == null) continue;
                        trx.delistResource(xaResource, 0x4000000);
                    }
                    catch (IllegalStateException | SystemException e) {
                        LOG.error("error in ending the XA transaction " + transactionId + ":" + e.getMessage(), e);
                    }
                }
                break block8;
            }
            Xid xid = this.xidRegistry.get(combinedId);
            List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
            if (xid != null && txContextList != null) {
                for (BallerinaTransactionContext ctx : txContextList) {
                    try {
                        XAResource xaResource = ctx.getXAResource();
                        if (xaResource == null) continue;
                        xaResource.end(xid, abortOnly ? 0x20000000 : 0x4000000);
                    }
                    catch (XAException e) {
                        LOG.error("error in ending XA transaction " + transactionId + ":" + e.getMessage(), e);
                    }
                }
            }
        }
    }

    private void removeContextsFromRegistry(String transactionCombinedId, String gTransactionId) {
        this.resourceRegistry.remove(transactionCombinedId);
        if (this.transactionManagerEnabled) {
            this.trxRegistry.remove(transactionCombinedId);
        } else {
            this.xidRegistry.remove(transactionCombinedId);
        }
    }

    private String generateCombinedTransactionId(String transactionId, String transactionBlockId) {
        if (transactionBlockId.contains("_")) {
            return transactionBlockId.split("_")[0];
        }
        return transactionId + ":" + transactionBlockId;
    }

    public void notifyResourceFailure(String gTransactionId) {
        this.failedResourceParticipantSet.add(gTransactionId);
        LOG.info("Trx infected callable unit excepted id : " + gTransactionId);
    }

    public void notifyLocalParticipantFailure(String gTransactionId, String blockId) {
        Set participantBlockIds = (Set)this.localParticipants.get(gTransactionId);
        if (participantBlockIds != null && participantBlockIds.contains(blockId)) {
            this.failedLocalParticipantSet.add(gTransactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTransactionRecord(BArray xid) {
        Map<ByteBuffer, Object> map2 = this.transactionInfoMap;
        synchronized (map2) {
            if (this.transactionInfoMap.containsKey(ByteBuffer.wrap(xid.getBytes()))) {
                return this.transactionInfoMap.get(ByteBuffer.wrap(xid.getBytes()));
            }
            return null;
        }
    }
}

