/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.toml.internal.parser.AbstractLexer;
import io.ballerina.toml.internal.parser.ParserMode;
import io.ballerina.toml.internal.parser.SyntaxErrors;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;
import java.util.List;

public class TomlLexer
extends AbstractLexer {
    public TomlLexer(CharReader charReader) {
        super(charReader, ParserMode.DEFAULT);
    }

    @Override
    public STToken nextToken() {
        STToken token;
        switch (this.mode) {
            case STRING: {
                token = this.readStringToken();
                break;
            }
            case MULTILINE_STRING: {
                token = this.readMultilineStringToken();
                break;
            }
            case LITERAL_STRING: {
                token = this.readLiteralStringToken();
                break;
            }
            case MULTILINE_LITERAL_STRING: {
                token = this.readMultilineLiteralStringToken();
                break;
            }
            case NEW_LINE: {
                token = this.readNewlineToken();
                if (token != null) break;
                token = this.nextToken();
                break;
            }
            default: {
                this.processLeadingTrivia();
                token = this.readToken();
            }
        }
        return this.cloneWithDiagnostics(token);
    }

    private STToken readToken() {
        STToken token;
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char c = this.reader.peek();
        this.reader.advance();
        switch (c) {
            case '\n': 
            case '\r': {
                token = this.getNewlineToken();
                break;
            }
            case '[': {
                token = this.getSyntaxToken(SyntaxKind.OPEN_BRACKET_TOKEN);
                break;
            }
            case '{': {
                token = this.getSyntaxToken(SyntaxKind.OPEN_BRACE_TOKEN);
                break;
            }
            case '}': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_BRACE_TOKEN);
                break;
            }
            case ']': {
                token = this.getSyntaxToken(SyntaxKind.CLOSE_BRACKET_TOKEN);
                break;
            }
            case '\'': {
                if (this.reader.peek() == '\'' && this.reader.peek(1) == '\'') {
                    this.reader.advance(2);
                    token = this.getQuoteToken(SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN);
                    this.startMode(ParserMode.MULTILINE_LITERAL_STRING);
                    break;
                }
                token = this.getQuoteToken(SyntaxKind.SINGLE_QUOTE_TOKEN);
                this.startMode(ParserMode.LITERAL_STRING);
                break;
            }
            case '=': {
                token = this.getSyntaxToken(SyntaxKind.EQUAL_TOKEN);
                break;
            }
            case ',': {
                token = this.getSyntaxToken(SyntaxKind.COMMA_TOKEN);
                break;
            }
            case '.': {
                token = this.getSyntaxToken(SyntaxKind.DOT_TOKEN);
                break;
            }
            case '+': {
                token = this.getSyntaxToken(SyntaxKind.PLUS_TOKEN);
                break;
            }
            case '-': {
                token = this.getSyntaxToken(SyntaxKind.MINUS_TOKEN);
                break;
            }
            case '\"': {
                if (this.reader.peek() == '\"' && this.reader.peek(1) == '\"') {
                    this.reader.advance(2);
                    token = this.getQuoteToken(SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN);
                    this.startMode(ParserMode.MULTILINE_STRING);
                    break;
                }
                token = this.getQuoteToken(SyntaxKind.DOUBLE_QUOTE_TOKEN);
                this.startMode(ParserMode.STRING);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                token = this.processNumericLiteral(c);
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                token = this.processKey();
                break;
            }
            default: {
                STToken invalidToken = this.processInvalidToken();
                token = this.nextToken();
                token = SyntaxErrors.addDiagnostic(token, DiagnosticErrorCode.ERROR_INVALID_TOKEN, invalidToken);
            }
        }
        return token;
    }

    private STToken readNewlineToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char c = this.reader.peek();
        this.endMode();
        if (c == '\n' || c == '\r') {
            this.reader.advance();
            return this.getNewlineToken();
        }
        return null;
    }

    private STToken readStringToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        if (nextChar == '\"') {
            this.endMode();
            this.reader.advance();
            return this.getSyntaxToken(SyntaxKind.DOUBLE_QUOTE_TOKEN);
        }
        block10: while (!this.reader.isEOF()) {
            nextChar = this.reader.peek();
            switch (nextChar) {
                case '\"': {
                    break block10;
                }
                case '\n': 
                case '\r': {
                    this.endMode();
                    return this.getUnquotedKey();
                }
                case '\\': {
                    switch (this.reader.peek(1)) {
                        case 'n': 
                        case 'r': {
                            this.endMode();
                            continue block10;
                        }
                        case '\"': 
                        case '\\': 
                        case 't': {
                            this.reader.advance(2);
                            continue block10;
                        }
                        case 'U': 
                        case 'u': {
                            this.processStringNumericEscape();
                            continue block10;
                        }
                    }
                    String escapeSequence = String.valueOf(this.reader.peek(2));
                    this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, escapeSequence);
                    this.reader.advance();
                    continue block10;
                }
                default: {
                    this.reader.advance();
                    continue block10;
                }
            }
        }
        return this.getUnquotedKey();
    }

    private STToken readLiteralStringToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        if (nextChar == '\'') {
            this.endMode();
            this.reader.advance();
            return this.getSyntaxToken(SyntaxKind.SINGLE_QUOTE_TOKEN);
        }
        block4: while (!this.reader.isEOF()) {
            nextChar = this.reader.peek();
            switch (nextChar) {
                case '\'': {
                    break block4;
                }
                case '\n': 
                case '\r': {
                    this.endMode();
                    return this.getUnquotedKey();
                }
                default: {
                    this.reader.advance();
                    continue block4;
                }
            }
        }
        return this.getUnquotedKey();
    }

    private STToken readMultilineStringToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        char secondNextChar = this.reader.peek(1);
        char thirdNextChar = this.reader.peek(2);
        if (nextChar == '\"' && secondNextChar == '\"' && thirdNextChar == '\"') {
            this.endMode();
            this.reader.advance(3);
            return this.getSyntaxToken(SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN);
        }
        block5: while (!(this.reader.isEOF() || (nextChar = this.reader.peek()) == '\"' && this.reader.peek(1) == '\"' && this.reader.peek(2) == '\"')) {
            if (nextChar != '\\') {
                this.reader.advance();
                continue;
            }
            switch (this.reader.peek(1)) {
                case '\n': 
                case '\r': {
                    this.reader.advance();
                    continue block5;
                }
                case '\"': 
                case '\\': 
                case 'n': 
                case 'r': 
                case 't': {
                    this.reader.advance(2);
                    continue block5;
                }
                case 'U': 
                case 'u': {
                    this.processStringNumericEscape();
                    continue block5;
                }
            }
            String escapeSequence = String.valueOf(this.reader.peek(2));
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_ESCAPE_SEQUENCE, escapeSequence);
            this.reader.advance();
        }
        return this.getUnquotedKey();
    }

    private STToken readMultilineLiteralStringToken() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        char nextChar = this.reader.peek();
        char secondNextChar = this.reader.peek(1);
        char thirdNextChar = this.reader.peek(2);
        if (nextChar == '\'' && secondNextChar == '\'' && thirdNextChar == '\'') {
            this.endMode();
            this.reader.advance(3);
            return this.getSyntaxToken(SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN);
        }
        while (!(this.reader.isEOF() || (nextChar = this.reader.peek()) == '\'' && this.reader.peek(1) == '\'' && this.reader.peek(2) == '\'')) {
            this.reader.advance();
        }
        return this.getUnquotedKey();
    }

    private STToken getNewlineToken() {
        STNode leadingTrivia = STNodeFactory.createEmptyNodeList();
        STNode trailingTrivia = STNodeFactory.createEmptyNodeList();
        return STNodeFactory.createToken(SyntaxKind.NEWLINE, leadingTrivia, trailingTrivia);
    }

    private STToken getSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getUnquotedKey() {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createIdentifierToken(lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getLiteral(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = this.processTrailingTrivia();
        return STNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getQuoteToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STNodeFactory.createEmptyNodeList();
        return STNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private void processLeadingTrivia() {
        this.processSyntaxTrivia(this.leadingTriviaList, true);
    }

    private STNode processTrailingTrivia() {
        ArrayList<STNode> triviaList = new ArrayList<STNode>(10);
        this.processSyntaxTrivia(triviaList, false);
        return STNodeFactory.createNodeList(triviaList);
    }

    private void processSyntaxTrivia(List<STNode> triviaList, boolean isLeading) {
        block5: while (!this.reader.isEOF()) {
            this.reader.mark();
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    triviaList.add(this.processWhitespaces());
                    continue block5;
                }
                case '\n': 
                case '\r': {
                    if (!isLeading) {
                        this.startMode(ParserMode.NEW_LINE);
                    }
                    triviaList.add(this.processEndOfLine());
                    return;
                }
                case '#': {
                    triviaList.add(this.processComment());
                    continue block5;
                }
            }
            return;
        }
    }

    private STNode processWhitespaces() {
        block4: while (!this.reader.isEOF()) {
            char c = this.reader.peek();
            switch (c) {
                case '\t': 
                case '\f': 
                case ' ': {
                    this.reader.advance();
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    break block4;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.WHITESPACE_MINUTIAE, this.getLexeme());
    }

    private STNode processEndOfLine() {
        char c = this.reader.peek();
        return switch (c) {
            case '\n' -> STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, "\n");
            case '\r' -> {
                if (this.reader.peek(1) == '\n') {
                    this.reader.advance();
                }
                yield STNodeFactory.createMinutiae(SyntaxKind.END_OF_LINE_MINUTIAE, "\r\n");
            }
            default -> throw new IllegalStateException();
        };
    }

    private STNode processComment() {
        this.reader.advance();
        int nextToken = this.peek();
        block3: while (!this.reader.isEOF()) {
            switch (nextToken) {
                case 10: 
                case 13: {
                    break block3;
                }
                default: {
                    this.reader.advance();
                    nextToken = this.peek();
                    continue block3;
                }
            }
        }
        return STNodeFactory.createMinutiae(SyntaxKind.COMMENT_MINUTIAE, this.getLexeme());
    }

    private STToken processNumericLiteral(int startChar) {
        int nextChar = this.peek();
        if (this.isHexIndicator(startChar, nextChar)) {
            return this.processHexLiteral();
        }
        if (this.isOctalIndicator(startChar, nextChar)) {
            return this.processOctalLiteral();
        }
        if (this.isBinaryIndicator(startChar, nextChar)) {
            return this.processBinaryLiteral();
        }
        int len = 1;
        block3: while (!this.reader.isEOF()) {
            switch (nextChar) {
                case 46: 
                case 69: 
                case 101: {
                    if (this.reader.peek(1) == '.') break block3;
                    if (startChar == 48 && len > 1) {
                        this.reportLexerError(DiagnosticErrorCode.ERROR_LEADING_ZEROS_IN_NUMERIC_LITERALS, new Object[0]);
                    }
                    return this.processDecimalFloatLiteral();
                }
                default: {
                    if (this.isAlphabeticChar(nextChar)) {
                        return this.processKey();
                    }
                    if (!TomlLexer.isValidNumericalDigit(nextChar)) break block3;
                    this.reader.advance();
                    ++len;
                    nextChar = this.peek();
                    continue block3;
                }
            }
        }
        if (startChar == 48 && len > 1) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_LEADING_ZEROS_IN_NUMERIC_LITERALS, new Object[0]);
        }
        return this.getLiteral(SyntaxKind.DECIMAL_INT_TOKEN);
    }

    private STToken processDecimalFloatLiteral() {
        int nextChar = this.peek();
        if (nextChar == 46) {
            this.reader.advance();
            nextChar = this.peek();
        }
        while (TomlLexer.isValidNumericalDigit(nextChar)) {
            this.reader.advance();
            nextChar = this.peek();
        }
        return switch (nextChar) {
            case 69, 101 -> this.processExponent();
            default -> this.getLiteral(SyntaxKind.DECIMAL_FLOAT_TOKEN);
        };
    }

    private STToken processHexLiteral() {
        this.reader.advance();
        while (TomlLexer.isHexDigit(this.peek())) {
            this.reader.advance();
        }
        return this.getLiteral(SyntaxKind.HEX_INTEGER_LITERAL_TOKEN);
    }

    private STToken processOctalLiteral() {
        this.reader.advance();
        while (TomlLexer.isOctalDigit(this.peek())) {
            this.reader.advance();
        }
        return this.getLiteral(SyntaxKind.OCTAL_INTEGER_LITERAL_TOKEN);
    }

    private STToken processBinaryLiteral() {
        this.reader.advance();
        while (TomlLexer.isBinaryDigit(this.peek())) {
            this.reader.advance();
        }
        return this.getLiteral(SyntaxKind.BINARY_INTEGER_LITERAL_TOKEN);
    }

    private STToken processExponent() {
        this.reader.advance();
        int nextChar = this.peek();
        if (nextChar == 43 || nextChar == 45) {
            this.reader.advance();
            nextChar = this.peek();
        }
        if (!TomlLexer.isValidNumericalDigit(nextChar)) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_MISSING_DIGIT_AFTER_EXPONENT_INDICATOR, new Object[0]);
        }
        while (TomlLexer.isValidNumericalDigit(nextChar)) {
            this.reader.advance();
            nextChar = this.peek();
        }
        return this.getLiteral(SyntaxKind.DECIMAL_FLOAT_TOKEN);
    }

    private boolean isHexIndicator(int startChar, int nextChar) {
        return startChar == 48 && (nextChar == 120 || nextChar == 88);
    }

    private boolean isOctalIndicator(int startChar, int nextChar) {
        return startChar == 48 && (nextChar == 111 || nextChar == 79);
    }

    private boolean isBinaryIndicator(int startChar, int nextChar) {
        return startChar == 48 && (nextChar == 98 || nextChar == 66);
    }

    private STToken processKey() {
        String tokenText;
        while (this.isIdentifierFollowingChar(this.peek())) {
            this.reader.advance();
        }
        return switch (tokenText = this.getLexeme()) {
            case "true" -> this.getSyntaxToken(SyntaxKind.TRUE_KEYWORD);
            case "false" -> this.getSyntaxToken(SyntaxKind.FALSE_KEYWORD);
            case "inf" -> this.getSyntaxToken(SyntaxKind.INF_TOKEN);
            case "nan" -> this.getSyntaxToken(SyntaxKind.NAN_TOKEN);
            default -> this.getUnquotedKey();
        };
    }

    private STToken processInvalidToken() {
        while (!this.isEndOfInvalidToken()) {
            this.reader.advance();
        }
        String tokenText = this.getLexeme();
        STToken invalidToken = STNodeFactory.createInvalidToken(tokenText);
        STNode invalidNodeMinutiae = STNodeFactory.createInvalidNodeMinutiae(invalidToken);
        this.leadingTriviaList.add(invalidNodeMinutiae);
        return invalidToken;
    }

    private boolean isEndOfInvalidToken() {
        if (this.reader.isEOF()) {
            return true;
        }
        int currentChar = this.peek();
        return switch (currentChar) {
            case 9, 10, 13, 32, 40, 41, 59, 91, 93, 123, 125 -> true;
            default -> false;
        };
    }

    private boolean isAlphabeticChar(int c) {
        return 65 <= c && c <= 90 || 97 <= c && c <= 122;
    }

    private boolean isIdentifierFollowingChar(int c) {
        return this.isAlphabeticChar(c) || TomlLexer.isValidNumericalDigit(c) || c == 45;
    }

    private static boolean isValidNumericalDigit(int c) {
        return c == 95 || TomlLexer.isDigit(c);
    }

    static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    static boolean isHexDigit(int c) {
        if (97 <= c && c <= 102) {
            return true;
        }
        if (65 <= c && c <= 70) {
            return true;
        }
        return TomlLexer.isValidNumericalDigit(c);
    }

    static boolean isOctalDigit(int c) {
        return c == 95 || 48 <= c && c <= 55;
    }

    static boolean isBinaryDigit(int c) {
        return c == 48 || c == 49 || c == 95;
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    private void processStringNumericEscape() {
        this.reader.advance(2);
        if (!TomlLexer.isHexDigit(this.peek())) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_STRING_NUMERIC_ESCAPE_SEQUENCE, new Object[0]);
            return;
        }
        this.reader.advance();
        while (TomlLexer.isHexDigit(this.peek())) {
            this.reader.advance();
        }
        this.reader.advance();
    }
}

